/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.debugger;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.javascript.debugger.JSDebuggerEditorsProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerEvaluateActionHandler;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XEvaluationCallbackBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodePresentationConfigurator;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceFileValueHint
extends AbstractValueHint {
    @NlsSafe
    private final String myExpression;
    @NlsSafe
    private final String myValueName;
    private final XSourcePosition myExpressionPosition;
    private final XDebuggerEvaluator myEvaluator;
    private static final Logger LOG = Logger.getInstance(SourceFileValueHint.class);

    public SourceFileValueHint(@NotNull Project project, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, TextRange textRange, @NotNull XDebuggerEvaluator evaluator, @NotNull ExpressionInfo expressionInfo) {
        if (project == null) {
            SourceFileValueHint.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SourceFileValueHint.$$$reportNull$$$0(1);
        }
        if (point == null) {
            SourceFileValueHint.$$$reportNull$$$0(2);
        }
        if (type == null) {
            SourceFileValueHint.$$$reportNull$$$0(3);
        }
        if (evaluator == null) {
            SourceFileValueHint.$$$reportNull$$$0(4);
        }
        if (expressionInfo == null) {
            SourceFileValueHint.$$$reportNull$$$0(5);
        }
        super(project, editor, point, type, textRange);
        this.myEvaluator = evaluator;
        this.myExpression = XDebuggerEvaluateActionHandler.getExpressionText((ExpressionInfo)expressionInfo, (Document)editor.getDocument());
        this.myValueName = XDebuggerEvaluateActionHandler.getDisplayText((ExpressionInfo)expressionInfo, (Document)editor.getDocument());
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        this.myExpressionPosition = file != null ? XDebuggerUtil.getInstance().createPositionByOffset(file, expressionInfo.getTextRange().getStartOffset()) : null;
    }

    protected boolean canShowHint() {
        return true;
    }

    protected void evaluateAndShowHint() {
        this.myEvaluator.evaluate(this.myExpression, (XDebuggerEvaluator.XEvaluationCallback)new XEvaluationCallbackBase(){

            public void evaluated(final @NotNull XValue result) {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                result.computePresentation((XValueNode)new XValueNodePresentationConfigurator.ConfigurableXValueNodeImpl(){
                    private XFullValueEvaluator myFullValueEvaluator;

                    public void applyPresentation(@Nullable Icon icon, @NotNull XValuePresentation valuePresenter, boolean hasChildren) {
                        if (valuePresenter == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (SourceFileValueHint.this.isHintHidden()) {
                            return;
                        }
                        SimpleColoredText text = new SimpleColoredText();
                        text.append(SourceFileValueHint.this.myValueName, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                        XValueNodeImpl.buildText((XValuePresentation)valuePresenter, (ColoredTextContainer)text);
                        if (!hasChildren) {
                            SimpleColoredComponent component = HintUtil.createInformationComponent();
                            text.appendToComponent((ColoredTextContainer)component);
                            if (this.myFullValueEvaluator != null) {
                                component.append(this.myFullValueEvaluator.getLinkText(), XDebuggerTreeNodeHyperlink.TEXT_ATTRIBUTES, event -> DebuggerUIUtil.showValuePopup((XFullValueEvaluator)this.myFullValueEvaluator, (MouseEvent)event, (Project)SourceFileValueHint.this.getProject(), (Editor)SourceFileValueHint.this.getEditor()));
                                LinkMouseListenerBase.installSingleTagOn((SimpleColoredComponent)component);
                            }
                            SourceFileValueHint.this.showHint((JComponent)component);
                        } else if (SourceFileValueHint.this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                            SourceFileValueHint.this.showTree(result);
                        } else {
                            JComponent component = SourceFileValueHint.this.createExpandableHintComponent(icon, text, () -> SourceFileValueHint.this.showTree(result));
                            SourceFileValueHint.this.showHint(component);
                        }
                    }

                    public void setFullValueEvaluator(@NotNull XFullValueEvaluator fullValueEvaluator) {
                        if (fullValueEvaluator == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        this.myFullValueEvaluator = fullValueEvaluator;
                    }

                    public boolean isObsolete() {
                        return SourceFileValueHint.this.isHintHidden();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "valuePresenter";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "fullValueEvaluator";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/javascript/trace/debugger/SourceFileValueHint$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "applyPresentation";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setFullValueEvaluator";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, XValuePlace.TOOLTIP);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                LOG.debug("Cannot evaluate '" + SourceFileValueHint.this.myExpression + "':" + errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/trace/debugger/SourceFileValueHint$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "evaluated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this.myExpressionPosition);
    }

    private void showTree(XValue value) {
        XDebuggerTreeCreator creator = new XDebuggerTreeCreator(this.getProject(), (XDebuggerEditorsProvider)new JSDebuggerEditorsProvider(), this.myExpressionPosition, null);
        this.showTreePopup((DebuggerTreeCreator)creator, Pair.create((Object)value, (Object)this.myValueName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "point";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "evaluator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "expressionInfo";
                break;
            }
        }
        objectArray[1] = "com/intellij/javascript/trace/debugger/SourceFileValueHint";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

