/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.util.HashMap;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssColorCSS1;
import org.w3c.css.values.CssColorCSS2;
import org.w3c.css.values.CssColorCSS21;
import org.w3c.css.values.CssColorCSS3;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.HSL;
import org.w3c.css.values.HSLA;
import org.w3c.css.values.HWB;
import org.w3c.css.values.RGB;
import org.w3c.css.values.RGBA;

public class CssColor
extends CssValue {
    public static final int type = 3;
    Object color = null;
    RGB rgb = null;
    RGBA rgba = null;
    HSL hsl = null;
    HSLA hsla = null;
    HWB hwb = null;

    @Override
    public final int getType() {
        return 3;
    }

    public CssColor() {
    }

    public CssColor(ApplContext ac, String s) throws InvalidParamException {
        this.setIdentColor(s, ac);
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        if (s.charAt(0) == '#') {
            this.setShortRGBColor(s.toLowerCase(), ac);
        } else {
            this.setIdentColor(s, ac);
        }
    }

    @Override
    public Object get() {
        if (this.color != null) {
            return this.color;
        }
        return this.rgb;
    }

    public String toString() {
        if (this.color != null) {
            return this.color.toString();
        }
        if (this.rgb != null) {
            return this.rgb.toString();
        }
        if (this.rgba != null) {
            return this.rgba.toString();
        }
        if (this.hsl != null) {
            return this.hsl.toString();
        }
        if (this.hsla != null) {
            return this.hsla.toString();
        }
        return this.hwb.toString();
    }

    public void setRGBColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        this.color = null;
        this.rgb = new RGB();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                this.rgb.setPercent(false);
                this.rgb.setRed(ac, val);
                break;
            }
            case 4: {
                this.rgb.setPercent(true);
                this.rgb.setRed(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                if (this.rgb.isPercent()) {
                    throw new InvalidParamException("percent", val, ac);
                }
                this.rgb.setGreen(ac, val);
                break;
            }
            case 4: {
                if (!this.rgb.isPercent()) {
                    throw new InvalidParamException("integer", val, ac);
                }
                this.rgb.setGreen(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                if (this.rgb.isPercent()) {
                    throw new InvalidParamException("percent", val, ac);
                }
                this.rgb.setBlue(ac, val);
                break;
            }
            case 4: {
                if (!this.rgb.isPercent()) {
                    throw new InvalidParamException("integer", val, ac);
                }
                this.rgb.setBlue(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        if (exp.getValue() != null) {
            throw new InvalidParamException("rgb", exp.getValue(), ac);
        }
    }

    public void setShortRGBColor(String s, ApplContext ac) throws InvalidParamException {
        int r;
        boolean islong;
        int v = s.length();
        boolean bl = islong = v == 7;
        if (v != 4 && !islong) {
            throw new InvalidParamException("rgb", s, ac);
        }
        int idx = 1;
        if ((r = Character.digit(s.charAt(idx++), 16)) < 0) {
            throw new InvalidParamException("rgb", s, ac);
        }
        if (islong) {
            if ((v = Character.digit(s.charAt(idx++), 16)) < 0) {
                throw new InvalidParamException("rgb", s, ac);
            }
            r = (r << 4) + v;
        } else {
            r |= r << 4;
        }
        int g = Character.digit(s.charAt(idx++), 16);
        if (g < 0) {
            throw new InvalidParamException("rgb", s, ac);
        }
        if (islong) {
            if ((v = Character.digit(s.charAt(idx++), 16)) < 0) {
                throw new InvalidParamException("rgb", s, ac);
            }
            g = (g << 4) + v;
        } else {
            g |= g << 4;
        }
        int b = Character.digit(s.charAt(idx), 16);
        if (b < 0) {
            throw new InvalidParamException("rgb", s, ac);
        }
        if (islong) {
            if ((v = Character.digit(s.charAt(++idx), 16)) < 0) {
                throw new InvalidParamException("rgb", s, ac);
            }
            b = (b << 4) + v;
        } else {
            b |= b << 4;
        }
        this.color = null;
        this.rgb = new RGB(r, g, b);
        this.rgb.setRepresentationString(s);
    }

    protected boolean computeIdentColor(HashMap<String, Object> definitions, String s) {
        Object obj = definitions.get(s);
        if (obj != null) {
            if (obj instanceof RGB) {
                this.color = s;
                this.rgb = (RGB)obj;
            } else if (obj instanceof RGBA) {
                this.color = s;
                this.rgba = (RGBA)obj;
            } else if (obj instanceof String) {
                this.color = (String)obj;
            }
            return true;
        }
        return false;
    }

    protected void setIdentColor(String s, ApplContext ac) throws InvalidParamException {
        String lower_s = s.toLowerCase();
        switch (ac.getCssVersion()) {
            case CSS1: {
                this.rgb = CssColorCSS1.getRGB(lower_s);
                if (this.rgb == null) {
                    throw new InvalidParamException("value", s, "color", ac);
                }
                this.color = lower_s;
                break;
            }
            case CSS2: {
                this.rgb = CssColorCSS2.getRGB(lower_s);
                if (this.rgb == null) {
                    this.color = CssColorCSS2.getSystem(lower_s);
                    if (this.color != null) break;
                    throw new InvalidParamException("value", s, "color", ac);
                }
                this.color = lower_s;
                break;
            }
            case CSS21: {
                this.rgb = CssColorCSS21.getRGB(lower_s);
                if (this.rgb == null) {
                    this.color = CssColorCSS21.getSystem(lower_s);
                    if (this.color != null) break;
                    throw new InvalidParamException("value", s, "color", ac);
                }
                this.color = lower_s;
                break;
            }
            case CSS3: 
            case CSS_2015: 
            case CSS: {
                this.rgb = CssColorCSS3.getRGB(lower_s);
                if (this.rgb != null) {
                    this.color = lower_s;
                    break;
                }
                this.rgba = CssColorCSS3.getRGBA(lower_s);
                if (this.rgba != null) {
                    this.color = lower_s;
                    break;
                }
                this.color = CssColorCSS3.getSystem(lower_s);
                if (this.color != null) {
                    ac.getFrame().addWarning("deprecated", s);
                    break;
                }
                this.color = CssColorCSS3.getIdentColor(lower_s);
                if (this.color != null) break;
                throw new InvalidParamException("value", s, "color", ac);
            }
            default: {
                throw new InvalidParamException("value", s, "color", ac);
            }
        }
    }

    @Override
    public boolean equals(Object cssColor) {
        if (!(cssColor instanceof CssColor)) {
            return false;
        }
        CssColor otherColor = (CssColor)cssColor;
        if (this.color != null && otherColor.color != null) {
            return this.color.equals(otherColor.color);
        }
        if (this.rgb != null && otherColor.rgb != null) {
            return this.rgb.equals(otherColor.rgb);
        }
        if (this.rgba != null && otherColor.rgba != null) {
            return this.rgba.equals(otherColor.rgba);
        }
        if (this.hsl != null && otherColor.hsl != null) {
            return this.hsl.equals(otherColor.hsl);
        }
        if (this.hsla != null && otherColor.hsla != null) {
            return this.hsla.equals(otherColor.hsla);
        }
        return false;
    }

    public void setATSCRGBAColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        this.rgba = new RGBA("atsc-rgba");
        this.__setRGBAColor(this.rgba, exp, ac);
    }

    public void setRGBAColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("rgba(").append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        this.rgba = new RGBA();
        this.__setRGBAColor(this.rgba, exp, ac);
    }

    private void __setRGBAColor(RGBA rgba, CssExpression exp, ApplContext ac) throws InvalidParamException {
        this.color = null;
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                rgba.setRed(ac, val);
                rgba.setPercent(false);
                break;
            }
            case 4: {
                rgba.setRed(ac, val);
                rgba.setPercent(true);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                if (rgba.isPercent()) {
                    exp.starts();
                    throw new InvalidParamException("percent", val, ac);
                }
                rgba.setGreen(ac, val);
                break;
            }
            case 4: {
                if (!rgba.isPercent()) {
                    exp.starts();
                    throw new InvalidParamException("integer", val, ac);
                }
                rgba.setGreen(ac, val);
                break;
            }
            default: {
                exp.starts();
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: {
                if (rgba.isPercent()) {
                    exp.starts();
                    throw new InvalidParamException("percent", val, ac);
                }
                rgba.setBlue(ac, val);
                break;
            }
            case 4: {
                if (!rgba.isPercent()) {
                    exp.starts();
                    throw new InvalidParamException("integer", val, ac);
                }
                rgba.setBlue(ac, val);
                break;
            }
            default: {
                exp.starts();
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        if (val == null) {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 4: 
            case 5: {
                rgba.setAlpha(ac, val);
                break;
            }
            default: {
                exp.starts();
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        if (exp.getValue() != null) {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
    }

    public void setHSLColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("hsl(").append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        this.color = null;
        this.hsl = new HSL();
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: 
            case 7: {
                this.hsl.setHue(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 4) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        this.hsl.setSaturation(ac, val);
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null) {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 4) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        this.hsl.setLightness(ac, val);
        exp.next();
        if (exp.getValue() != null) {
            exp.starts();
            throw new InvalidParamException("rgb", exp.getValue(), ac);
        }
    }

    public void setHSLAColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("hsla(").append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        this.color = null;
        this.hsla = new HSLA();
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: 
            case 7: {
                this.hsla.setHue(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 4) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        this.hsla.setSaturation(ac, val);
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 4) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        this.hsla.setLightness(ac, val);
        exp.next();
        val = exp.getValue();
        if (val == null) {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 4: 
            case 5: {
                this.hsla.setAlpha(ac, val);
                break;
            }
            default: {
                exp.starts();
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        if (exp.getValue() != null) {
            exp.starts();
            throw new InvalidParamException("rgb", exp.getValue(), ac);
        }
    }

    public void setHWBColor(CssExpression exp, ApplContext ac) throws InvalidParamException {
        if (ac.getCssVersion().compareTo(CssVersion.CSS3) < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("hwb(").append(exp.toStringFromStart()).append(')');
            throw new InvalidParamException("notversion", sb.toString(), ac.getCssVersionString(), ac);
        }
        this.color = null;
        this.hwb = new HWB();
        CssValue val = exp.getValue();
        char op = exp.getOperator();
        if (val == null || op != ',') {
            throw new InvalidParamException("invalid-color", ac);
        }
        switch (val.getType()) {
            case 5: 
            case 7: {
                this.hwb.setHue(ac, val);
                break;
            }
            default: {
                throw new InvalidParamException("rgb", val, ac);
            }
        }
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',') {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 4) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        this.hwb.setWhiteness(ac, val);
        exp.next();
        val = exp.getValue();
        op = exp.getOperator();
        if (val == null || op != ',' && exp.getRemainingCount() > 1) {
            exp.starts();
            throw new InvalidParamException("invalid-color", ac);
        }
        if (val.getType() != 4) {
            exp.starts();
            throw new InvalidParamException("rgb", val, ac);
        }
        this.hwb.setBlackness(ac, val);
        this.hwb.normalize();
        exp.next();
        val = exp.getValue();
        if (val != null) {
            switch (val.getType()) {
                case 4: 
                case 5: {
                    this.hwb.setAlpha(ac, val);
                    break;
                }
                default: {
                    exp.starts();
                    throw new InvalidParamException("rgb", val, ac);
                }
            }
        }
        exp.next();
        if (exp.getValue() != null) {
            exp.starts();
            throw new InvalidParamException("rgb", exp.getValue(), ac);
        }
    }

    private int clippedIntValue(int rgb, ApplContext ac) {
        if (rgb < 0 || rgb > 255) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(rgb));
            return rgb < 0 ? 0 : 255;
        }
        return rgb;
    }

    private float clippedPercentValue(float p, ApplContext ac) {
        if ((double)p < 0.0 || (double)p > 100.0) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
            return (double)p < 0.0 ? 0.0f : 100.0f;
        }
        return p;
    }

    private float clippedAlphaValue(float p, ApplContext ac) {
        if ((double)p < 0.0 || (double)p > 1.0) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
            return (float)((double)p < 0.0 ? 0.0 : 1.0);
        }
        return p;
    }

    private float angleValue(float p, ApplContext ac) {
        if ((double)p < 0.0 || (double)p >= 360.0) {
            ac.getFrame().addWarning("out-of-range", Util.displayFloat(p));
        }
        return p;
    }
}

