/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils.indexes;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ(\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\f0\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/performancePlugin/utils/indexes/CurrentIndexedFileResolver;", "", "()V", "doesFileBelongToCurrentProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getAllToBeIndexedFilesInProject", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.performanceTesting"})
public final class CurrentIndexedFileResolver {
    public static final CurrentIndexedFileResolver INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<IndexableFilesIterator, Set<VirtualFile>> getAllToBeIndexedFilesInProject(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.setText(PerformanceTestingBundle.message("checking.shared.indexes.collecting.all.indexed.files", new Object[0]));
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        boolean bl = false;
        HashMap providerToFiles = new HashMap();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (fileBasedIndex == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexEx");
        }
        List list = ((FileBasedIndexEx)fileBasedIndex).getOrderedIndexableFilesProviders(project);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"(FileBasedIndex.getInsta\u2026leFilesProviders(project)");
        List providers = list;
        ConcurrentBitSet visitedFileSet = new ConcurrentBitSet();
        boolean bl2 = false;
        for (IndexableFilesIterator provider : (Iterable)providers) {
            void finished;
            indicator.checkCanceled();
            boolean bl3 = false;
            HashSet providerFiles = new HashSet();
            if (!provider.iterateFiles(project, new ContentIterator(providerFiles){
                final /* synthetic */ HashSet $providerFiles;

                public final boolean processFile(@NotNull VirtualFile fileOrDir) {
                    Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
                    if (!fileOrDir.isDirectory()) {
                        Collection collection = this.$providerFiles;
                        boolean bl = false;
                        collection.add(fileOrDir);
                    }
                    return true;
                }
                {
                    this.$providerFiles = hashSet;
                }
            }, visitedFileSet)) break;
            indicator.setFraction((double)(finished + true) * 1.0 / (double)providers.size());
            Map map = providerToFiles;
            IndexableFilesIterator indexableFilesIterator = provider;
            Intrinsics.checkNotNullExpressionValue((Object)indexableFilesIterator, (String)"provider");
            map.put(indexableFilesIterator, providerFiles);
            ++finished;
        }
        return providerToFiles;
    }

    public final boolean doesFileBelongToCurrentProject(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return GlobalSearchScope.everythingScope((Project)project).contains(file);
    }

    private CurrentIndexedFileResolver() {
    }

    static {
        CurrentIndexedFileResolver currentIndexedFileResolver;
        INSTANCE = currentIndexedFileResolver = new CurrentIndexedFileResolver();
    }
}

