/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing.agent;

import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.AdviceAdapter;

class TracingMethodVisitor
extends AdviceAdapter {
    private static final String tracerJVMName = "com.intellij.diagnostic.tracing.MethodTracer".replace('.', '/');
    private static final String tracerTypeDescriptor = "L" + tracerJVMName + ";";
    private static final String getInstance = "getInstance";
    private static final String onMethodStart = "onMethodEnter";
    private static final String onMethodExit = "onMethodExit";
    private static final String tracerGetInstanceSignature = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)" + tracerTypeDescriptor;
    private final String className;
    private final String simpleClassName;
    private final String methodName;
    private final int splitParameter;
    private int newVarIndex;

    TracingMethodVisitor(int api, MethodVisitor mv, int access, String className, String name, String desc, String simpleClassName, String methodName, int splitParameter) {
        super(api, mv, access, name, desc);
        this.className = className;
        this.simpleClassName = simpleClassName;
        this.methodName = methodName;
        this.splitParameter = splitParameter;
    }

    protected void onMethodEnter() {
        this.newVarIndex = this.newLocal(Type.getType((String)tracerTypeDescriptor));
        this.mv.visitLdcInsn((Object)this.className);
        this.mv.visitLdcInsn((Object)this.simpleClassName);
        this.mv.visitLdcInsn((Object)this.methodName);
        if (!this.visitSplitArgument()) {
            this.mv.visitInsn(1);
        }
        this.mv.visitLdcInsn((Object)this.methodDesc);
        this.mv.visitMethodInsn(184, tracerJVMName, getInstance, tracerGetInstanceSignature, false);
        this.mv.visitVarInsn(58, this.newVarIndex);
        this.mv.visitVarInsn(25, this.newVarIndex);
        this.mv.visitMethodInsn(182, tracerJVMName, onMethodStart, "()V", false);
    }

    private boolean visitSplitArgument() {
        if (this.splitParameter < 0) {
            return false;
        }
        Type[] argumentTypes = this.getArgumentTypes();
        if (this.splitParameter >= argumentTypes.length) {
            Logger.getInstance(TracingMethodVisitor.class).warn(String.format("Cannot split %s.%s by argument: invalid argument index", this.simpleClassName, this.methodName));
            return false;
        }
        Type argumentType = argumentTypes[this.splitParameter];
        if (argumentType.getSort() == 1 || argumentType.getSort() == 2 || argumentType.getSort() == 5 || argumentType.getSort() == 7 || argumentType.getSort() == 10) {
            this.loadArg(this.splitParameter);
            String desc = argumentType.getSort() == 10 ? "Ljava/lang/Object;" : argumentType.getDescriptor();
            this.mv.visitMethodInsn(184, "java/lang/String", "valueOf", "(" + desc + ")Ljava/lang/String;", false);
            return true;
        }
        Logger.getInstance(TracingMethodVisitor.class).warn(String.format("Cannot split %s.%s by argument: argument type %s not supported", this.simpleClassName, this.methodName, argumentType.getClassName()));
        return false;
    }

    protected void onMethodExit(int opcode) {
        this.mv.visitVarInsn(25, this.newVarIndex);
        this.mv.visitMethodInsn(182, tracerJVMName, onMethodExit, "()V", false);
    }
}

