/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing.agent;

import com.intellij.diagnostic.tracing.MethodTracer;
import com.intellij.openapi.util.text.StringUtilRt;
import com.jetbrains.performancePlugin.tracing.agent.AgentLogger;
import com.jetbrains.performancePlugin.tracing.agent.Config;
import com.jetbrains.performancePlugin.tracing.agent.TracingMethodVisitor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class TracingClassVisitor
extends ClassVisitor {
    private final String className;
    private final String simpleClassName;
    private final Config myConfig;
    private final AgentLogger myLogger;
    private static final Map<MethodTracer.TracerId, Boolean> instrumentedMethods = new ConcurrentHashMap<MethodTracer.TracerId, Boolean>();

    public TracingClassVisitor(ClassVisitor cv, String className, String simpleClassName, Config config, AgentLogger logger) {
        super(524288, cv);
        this.className = className;
        this.simpleClassName = simpleClassName;
        this.myConfig = config;
        this.myLogger = logger;
    }

    public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, methodName, desc, signature, exceptions);
        if (mv != null && !TracingClassVisitor.isSynthetic(access) && this.myConfig.shouldTransform(this.className, methodName)) {
            boolean alreadyInstrumented;
            String suffix = this.myConfig.getSuffix(this.className, methodName);
            int splitParameter = StringUtilRt.parseInt((String)suffix, (int)-1);
            MethodTracer.TracerId tracerId = new MethodTracer.TracerId(this.className, methodName, suffix, desc);
            boolean bl = alreadyInstrumented = instrumentedMethods.put(tracerId, true) != null;
            if (alreadyInstrumented) {
                return mv;
            }
            this.myLogger.debug(methodName + desc + " of " + this.className + " instrumented");
            return new TracingMethodVisitor(this.api, mv, access, this.className, methodName, desc, this.simpleClassName, methodName, splitParameter);
        }
        return mv;
    }

    private static boolean isSynthetic(int access) {
        return (access & 0x1000) != 0;
    }
}

