/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing.actions;

import com.intellij.ide.actions.EditCustomSettingsAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.performancePlugin.tracing.MethodTracing;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class ConfigureMethodTracingAction
extends EditCustomSettingsAction {
    public ConfigureMethodTracingAction() {
        this.getTemplatePresentation().setEnabledAndVisible(ApplicationManager.getApplication().isInternal());
    }

    @NotNull
    protected Path file() {
        Path path = MethodTracing.configFile();
        if (path == null) {
            ConfigureMethodTracingAction.$$$reportNull$$$0(0);
        }
        return path;
    }

    @NotNull
    protected String template() {
        return "# Only classes from platform or plugin classloaders will be instrumented.\n# Instrumentation may be applied several times in the same run, but to revert it restart or hot-swap is required.\n#\n# To apply instrumentation on application loading set system property\n# internal.method.tracing.on.load=true\n#\n# Method and class name should be separated by '#' or '.'.\n# Pattern may contain asterisks to match arbitrary prefix or suffix of a class or method name.\n# A suffix '/ <parameter index>' may follow the method name. If it is specified, \n# the instrumented method calls will be split by a string value of n-th passed argument.\n# Note that computing String.valueOf of an argument on every method invocation may significantly affect performance\n# and introduce bias to time measurements. Trust only invocation counts if you use such patterns.\n#\n# Note that broad patterns may freeze IDE during instrumentation.\n# Very generic patterns may cause JVM crash by hitting limits of native memory.\n#\n# Examples of patterns:\n#\n# com.intellij.psi.impl.source.*.getText\n# com.intellij.psi.impl.PsiImplUtil#*\n# com.intellij.psi.stubs.DefaultStubBuilder.buildStubTree / 0\n";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/performancePlugin/tracing/actions/ConfigureMethodTracingAction", "file"));
    }

    static final class AccessExtension
    implements NonProjectFileWritingAccessExtension {
        AccessExtension() {
        }

        public boolean isWritable(@NotNull VirtualFile file) {
            if (file == null) {
                AccessExtension.$$$reportNull$$$0(0);
            }
            return VfsUtilCore.pathEqualsTo((VirtualFile)file, (String)MethodTracing.configFile().toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/performancePlugin/tracing/actions/ConfigureMethodTracingAction$AccessExtension", "isWritable"));
        }
    }
}

