/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.performancePlugin.tracing.agent.AgentLogger;
import com.jetbrains.performancePlugin.tracing.agent.Config;
import com.jetbrains.performancePlugin.tracing.agent.TracingAgent;
import java.lang.instrument.Instrumentation;
import java.nio.file.Path;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.jetbrains.annotations.NotNull;

public final class MethodTracing {
    public static final String toolWindowId = "Internal Method Tracing";
    public static final String configFileName = "method.tracing.config";
    static final Logger LOG = Logger.getInstance(MethodTracing.class);
    private static Instrumentation ourInstrumentation = null;
    private static final AgentLogger agentLogger = new AgentLogger(){

        @Override
        public void debug(String message) {
            LOG.debug(message);
        }

        @Override
        public void error(String message) {
            LOG.error(message);
        }

        @Override
        public void error(Throwable t) {
            LOG.debug(t);
        }
    };

    public static void instrument(Config config) {
        if (ourInstrumentation == null) {
            try {
                ourInstrumentation = ByteBuddyAgent.install();
                LOG.info("Tracing agent installed");
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                throw e;
            }
        }
        TracingAgent.instrument(ourInstrumentation, config, agentLogger);
    }

    @NotNull
    public static Path configFile() {
        Path path = PathManager.getConfigDir().resolve(configFileName);
        if (path == null) {
            MethodTracing.$$$reportNull$$$0(0);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/performancePlugin/tracing/MethodTracing", "configFile"));
    }
}

