/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class UnloadDynamicPluginCommand
extends AbstractCommand {
    public static final String PREFIX = "%unloadDynamicPlugin";
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(UnloadDynamicPluginCommand.class);

    public UnloadDynamicPluginCommand(@NotNull String text, int line, @NotNull Project project) {
        if (text == null) {
            UnloadDynamicPluginCommand.$$$reportNull$$$0(0);
        }
        if (project == null) {
            UnloadDynamicPluginCommand.$$$reportNull$$$0(1);
        }
        super(text, line);
        this.myProject = project;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String pluginIdString = this.getText().substring(PREFIX.length()).trim();
        PluginId pluginId = PluginId.getId((String)pluginIdString);
        IdeaPluginDescriptorImpl pluginDescriptor = PluginDescriptorLoader.loadFullDescriptor((IdeaPluginDescriptorImpl)((IdeaPluginDescriptorImpl)Objects.requireNonNull(PluginManagerCore.getPlugin((PluginId)pluginId))));
        if (DisabledPluginsState.disabledPlugins().contains(pluginId)) {
            LOG.error("Plugin " + pluginIdString + " is disabled. Unload can not be performed");
            actionCallback.setRejected();
            return Promises.toPromise((ActionCallback)actionCallback);
        }
        for (IdeaPluginDescriptor loadedPlugin : PluginManagerCore.getLoadedPlugins()) {
            if (loadedPlugin.getPluginId().equals(pluginId)) continue;
            List dependencies = ((IdeaPluginDescriptorImpl)loadedPlugin).getPluginDependencies();
            for (PluginDependency dependency : dependencies) {
                if (dependency.isOptional || !dependency.id.equals(pluginId)) continue;
                LOG.error("Plugin " + pluginIdString + " can't be unloaded because it's a non-optional dependency of " + loadedPlugin.getPluginId());
                actionCallback.setRejected();
                return Promises.toPromise((ActionCallback)actionCallback);
            }
        }
        if (DynamicPlugins.allowLoadUnloadWithoutRestart((IdeaPluginDescriptorImpl)pluginDescriptor)) {
            pluginDescriptor.setEnabled(false);
            final MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect();
            appConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

                public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    final MessageBusConnection projectConnection = UnloadDynamicPluginCommand.this.myProject.getMessageBus().connect();
                    projectConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                        public void exitDumbMode() {
                            appConnection.disconnect();
                            projectConnection.disconnect();
                            actionCallback.setDone();
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/jetbrains/performancePlugin/commands/UnloadDynamicPluginCommand$1", "pluginUnloaded"));
                }
            });
            ApplicationManager.getApplication().invokeLater(() -> {
                IdeEventQueue.getInstance().flushQueue();
                boolean pluginUnloaded = DynamicPlugins.unloadPlugin((IdeaPluginDescriptorImpl)pluginDescriptor, (DynamicPlugins.UnloadPluginOptions)new DynamicPlugins.UnloadPluginOptions().withDisable(true).withRequireMemorySnapshot(true));
                if (!pluginUnloaded) {
                    LOG.error("Plugin " + pluginIdString + " was not unloaded");
                    actionCallback.setRejected();
                } else {
                    LOG.info("Plugin " + pluginIdString + " was unloaded");
                }
            });
        } else {
            LOG.error("Plugin " + pluginIdString + " is not dynamic");
            actionCallback.setRejected();
        }
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/performancePlugin/commands/UnloadDynamicPluginCommand";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

