/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticDumper;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.StoreIndices;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/performancePlugin/commands/StoreIndices;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;ILcom/intellij/openapi/project/Project;)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "storeIndexesTo", "", "storedIndexDir", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "intellij.performanceTesting"})
public final class StoreIndices
extends AbstractCommand {
    private final Project myProject;
    @NotNull
    public static final String PREFIX = "%storeIndices";
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        LOG.info("dynamic.classpath: " + PropertiesComponent.getInstance((Project)this.myProject).getValue("dynamic.classpath"));
        Path storedIndexDir = StoreIndices.Companion.getOrCreateDirectoryToStoreIndex();
        LOG.info("Index will be stored to " + storedIndexDir);
        DumbService.getInstance((Project)this.myProject).smartInvokeLater(new Runnable(this, storedIndexDir, actionCallback){
            final /* synthetic */ StoreIndices this$0;
            final /* synthetic */ Path $storedIndexDir;
            final /* synthetic */ ActionCallbackProfilerStopper $actionCallback;

            public final void run() {
                new Task.Modal(this, StoreIndices.access$getMyProject$p(this.this$0), PerformanceTestingBundle.message("storing.indexes", new Object[0]), false){
                    final /* synthetic */ _execute.1 this$0;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        try {
                            StoreIndices.access$storeIndexesTo(this.this$0.this$0, this.this$0.$storedIndexDir, indicator);
                            StoreIndices.access$getLOG$cp().info("Indices have been successfully stored to " + this.this$0.$storedIndexDir);
                            this.this$0.$actionCallback.setDone();
                        }
                        catch (Throwable e) {
                            StoreIndices.access$getLOG$cp().error(e);
                            Intrinsics.checkNotNullExpressionValue((Object)this.this$0.$actionCallback.reject(e.getMessage()), (String)"actionCallback.reject(e.message)");
                        }
                    }
                    {
                        this.this$0 = this$0;
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                    }
                }.queue();
            }
            {
                this.this$0 = storeIndices;
                this.$storedIndexDir = path;
                this.$actionCallback = actionCallbackProfilerStopper;
            }
        });
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private final void storeIndexesTo(Path storedIndexDir, ProgressIndicator indicator) {
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable<T>(){

            public final T compute() {
                boolean bl = false;
                FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                if (fileBasedIndex == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
                }
                ((FileBasedIndexImpl)fileBasedIndex).flushIndexes();
                return (T)Unit.INSTANCE;
            }
        });
        indicator.setIndeterminate(true);
        indicator.setText(PerformanceTestingBundle.message("storing.indexes.copying", new Object[0]));
        File file = PathManager.getIndexRoot();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"PathManager.getIndexRoot()");
        File indexRoot = file;
        try {
            FileUtil.delete((Path)storedIndexDir);
            FileUtil.copyDir((File)indexRoot, (File)storedIndexDir.toFile());
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
        IndexContentDiagnostic contentDiagnostic = IndexContentDiagnosticDumper.INSTANCE.getIndexContentDiagnosticForProject(this.myProject, indicator);
        IndexContentDiagnosticDumper.INSTANCE.writeTo(Companion.getFileForDiagnostic(storedIndexDir), contentDiagnostic);
    }

    public StoreIndices(@Nullable String text, int line, @NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        super(text, line);
        this.myProject = myProject;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(StoreIndices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(StoreIndices::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$storeIndexesTo(StoreIndices $this, Path storedIndexDir, ProgressIndicator indicator) {
        $this.storeIndexesTo(storedIndexDir, indicator);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ Project access$getMyProject$p(StoreIndices $this) {
        return $this.myProject;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\b\u0010\u000b\u001a\u00020\tH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/performancePlugin/commands/StoreIndices$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PREFIX", "", "getFileForDiagnostic", "Ljava/nio/file/Path;", "indexesHomeDirectory", "getOrCreateDirectoryToStoreIndex", "intellij.performanceTesting"})
    public static final class Companion {
        private final Path getOrCreateDirectoryToStoreIndex() {
            Path path;
            String property = System.getProperty("store.indices.command.stored.indexes.dump.directory");
            if (property != null) {
                Path path2 = Paths.get(property, new String[0]);
                path = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(property)");
            } else {
                Path path3;
                try {
                    path3 = FileUtil.createTempDirectory((String)"stored_index", null).toPath();
                }
                catch (IOException e) {
                    throw (Throwable)new RuntimeException(e);
                }
                Path path4 = path3;
                path = path4;
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"try {\n          FileUtil\u2026imeException(e)\n        }");
            }
            return path;
        }

        @NotNull
        public final Path getFileForDiagnostic(@NotNull Path indexesHomeDirectory) {
            Intrinsics.checkNotNullParameter((Object)indexesHomeDirectory, (String)"indexesHomeDirectory");
            Path path = indexesHomeDirectory.resolve("indexedFilePaths.json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"indexesHomeDirectory.res\u2026(\"indexedFilePaths.json\")");
            return path;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

