/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class ReopenProjectCommand
extends AbstractCommand {
    public static final String PREFIX = "%reopenProject";
    private final Project myProject;

    public ReopenProjectCommand(@NotNull String text, int line, @NotNull Project project) {
        if (text == null) {
            ReopenProjectCommand.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ReopenProjectCommand.$$$reportNull$$$0(1);
        }
        super(text, line, true);
        this.myProject = project;
    }

    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            ReopenProjectCommand.$$$reportNull$$$0(2);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        int currentLine = context.getCurrentLine();
        File scriptFile = new File(System.getProperty("testscript.filename"));
        try {
            List<String> lines = Files.readAllLines(scriptFile.toPath(), Charsets.UTF_8);
            int count = 0;
            for (String line : lines) {
                if (++count == currentLine + 1) {
                    FileUtil.writeToFile((File)scriptFile, (String)(line + "\n"), (boolean)false);
                    continue;
                }
                if (count <= currentLine + 1) continue;
                FileUtil.writeToFile((File)scriptFile, (String)(line + "\n"), (boolean)true);
            }
        }
        catch (IOException ex) {
            actionCallback.setRejected();
            return Promises.toPromise((ActionCallback)actionCallback);
        }
        WindowManager.getInstance().updateDefaultFrameInfoOnProjectClose(this.myProject);
        ProjectManagerEx.getInstanceEx().closeAndDispose(this.myProject);
        RecentProjectsManager.getInstance().updateLastProjectPath();
        WelcomeFrame.showIfNoProjectOpened();
        ProjectManagerEx.getInstanceEx().openProject(Paths.get(Objects.requireNonNull(this.myProject.getBasePath()), new String[0]), new OpenProjectTask());
        actionCallback.setDone();
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/commands/ReopenProjectCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "_execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

