/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class MoveDirectoryCommand
extends AbstractCommand {
    public static final String PREFIX = "%moveDirectory";
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(MoveDirectoryCommand.class);

    public MoveDirectoryCommand(@NotNull String text, int line, Project project) {
        if (text == null) {
            MoveDirectoryCommand.$$$reportNull$$$0(0);
        }
        super(text, line, true);
        this.myProject = project;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        PsiManagerImpl myPsiManager = (PsiManagerImpl)PsiManager.getInstance((Project)this.myProject);
        String input = this.getText().substring(PREFIX.length()).trim();
        String[] lineAndColumn = input.split(" ");
        String sourcePath = lineAndColumn[0];
        String targetPath = lineAndColumn[1];
        VirtualFile sourceVirtualFile = ProjectUtil.guessProjectDir((Project)this.myProject).findFileByRelativePath(sourcePath);
        VirtualFile targetVirtualFile = ProjectUtil.guessProjectDir((Project)this.myProject).findFileByRelativePath(targetPath);
        PsiDirectory sourcePsiDir = myPsiManager.findDirectory(sourceVirtualFile);
        PsiDirectory targetPsiDir = myPsiManager.findDirectory(targetVirtualFile);
        ApplicationManager.getApplication().invokeAndWait(() -> WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            MoveFilesOrDirectoriesUtil.doMoveDirectory((PsiDirectory)sourcePsiDir, (PsiDirectory)targetPsiDir);
            LOG.info("Dir " + sourcePath + " has been moved to " + targetPath);
            actionCallback.setDone();
        }), ModalityState.NON_MODAL);
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/MoveDirectoryCommand", "<init>"));
    }
}

