/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class IsPluginEnabledCommand
extends AbstractCommand {
    public static final String PREFIX = "%isPluginEnabled";
    private static final Logger LOG = Logger.getInstance(IsPluginEnabledCommand.class);

    public IsPluginEnabledCommand(@NotNull String text, int line) {
        if (text == null) {
            IsPluginEnabledCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String pluginIdString = this.getText().substring(PREFIX.length()).trim();
        PluginId pluginId = PluginId.getId((String)pluginIdString);
        IdeaPluginDescriptorImpl pluginDescriptor = PluginDescriptorLoader.loadFullDescriptor((IdeaPluginDescriptorImpl)((IdeaPluginDescriptorImpl)Objects.requireNonNull(PluginManagerCore.getPlugin((PluginId)pluginId))));
        if (DisabledPluginsState.disabledPlugins().contains(pluginId)) {
            LOG.error("Plugin " + pluginDescriptor.getName() + " is disabled.");
            actionCallback.setRejected();
            return Promises.toPromise((ActionCallback)actionCallback);
        }
        for (IdeaPluginDescriptor loadedPlugin : PluginManagerCore.getLoadedPlugins()) {
            if (!loadedPlugin.getPluginId().equals(pluginId)) continue;
            actionCallback.setDone();
            LOG.info("Plugin " + pluginDescriptor.getName() + " has been found in the list of loaded plugins");
            return Promises.toPromise((ActionCallback)actionCallback);
        }
        LOG.error("Plugin " + pluginDescriptor.getName() + " has not been found in the list of loaded plugins.");
        actionCallback.setRejected();
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/IsPluginEnabledCommand", "<init>"));
    }
}

