/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class GitCheckoutCommand
extends AbstractCommand {
    public static final String PREFIX = "%gitCheckout";
    private final Project myProject;

    public GitCheckoutCommand(@NotNull String text, int line, Project project) {
        if (text == null) {
            GitCheckoutCommand.$$$reportNull$$$0(0);
        }
        super(text, line, true);
        this.myProject = project;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        String error;
        String output;
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String branchName = this.getText().substring(PREFIX.length()).trim().replaceAll("\"", "");
        String command = "git checkout " + branchName;
        File projectDir = new File(Objects.requireNonNull(this.myProject.getBasePath()));
        try {
            Process process = Runtime.getRuntime().exec(command, null, projectDir);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                output = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));
            try {
                error = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            finally {
                reader.close();
            }
            process.waitFor(1L, TimeUnit.MINUTES);
        }
        catch (IOException | InterruptedException ex) {
            actionCallback.reject("Could not run the process with args: " + command + "\n" + ex.getMessage());
            return Promises.toPromise((ActionCallback)actionCallback);
        }
        String message = output + System.lineSeparator() + error;
        if (error.contains("Switched to branch")) {
            context.message(message, this.getLine());
            final MessageBusConnection projectConnection = this.myProject.getMessageBus().connect();
            projectConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void exitDumbMode() {
                    projectConnection.disconnect();
                    actionCallback.setDone();
                }
            });
            ApplicationManager.getApplication().invokeLater(() -> {
                FileDocumentManager.getInstance().saveAllDocuments();
                SaveAndSyncHandler.getInstance().refreshOpenFiles();
                VirtualFileManager.getInstance().refreshWithoutFileWatcher(false);
            });
        } else {
            actionCallback.reject(message);
        }
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/GitCheckoutCommand", "<init>"));
    }
}

