/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class FindUsagesCommand
extends AbstractCommand {
    private static final String DUMP_FOUND_USAGES_DESTINATION_FILE = "find.usages.command.found.usages.list.file";
    private static final ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().setDefaultPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
    public static final String PREFIX = "%findUsages";
    private final Project myProject;

    public FindUsagesCommand(String text, int line, @NotNull Project project) {
        if (project == null) {
            FindUsagesCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
        this.myProject = project;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        CountDownLatch findUsagesFinished = new CountDownLatch(1);
        ArrayList allUsages = new ArrayList();
        DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> {
            Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
            if (editor == null) {
                actionCallback.reject("The action invoked without editor");
                return;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
            if (psiFile == null) {
                actionCallback.reject("Psi File is not found");
                return;
            }
            int offset = editor.getCaretModel().getOffset();
            PsiElement[] elements = GotoDeclarationAction.findTargetElementsNoVS((Project)this.myProject, (Editor)editor, (int)offset, (boolean)true);
            PsiElement element = elements != null && elements.length > 0 ? elements[0] : PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(offset), PsiNamedElement.class);
            if (element == null) {
                actionCallback.reject("Can't find an element under " + offset + " offset.");
                return;
            }
            FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)this.myProject)).getFindUsagesManager();
            FindUsagesHandler handler = findUsagesManager.getFindUsagesHandler(element, FindUsagesHandlerFactory.OperationMode.HIGHLIGHT_USAGES);
            if (handler == null) {
                actionCallback.reject("No find usage handler found for the element:" + element.getText());
                return;
            }
            FindUsagesOptions findUsagesOptions = new FindUsagesOptions(this.myProject);
            findUsagesOptions.isUsages = true;
            findUsagesOptions.isSearchForTextOccurrences = false;
            findUsagesOptions.searchScope = GlobalSearchScope.allScope((Project)this.myProject);
            Processor collectProcessor = Processors.cancelableCollectProcessor(Collections.synchronizedList(allUsages));
            FindUsagesManager.startProcessUsages((FindUsagesHandlerBase)handler, (PsiElement[])handler.getPrimaryElements(), (PsiElement[])handler.getSecondaryElements(), (Processor)collectProcessor, (FindUsagesOptions)findUsagesOptions, () -> findUsagesFinished.countDown());
        });
        try {
            findUsagesFinished.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        List foundUsages = ContainerUtil.map(allUsages, usage -> FindUsagesCommand.convertToFoundUsage(this.myProject, usage));
        Path jsonPath = FindUsagesCommand.getFoundUsagesJsonPath();
        if (jsonPath != null) {
            this.dumpFoundUsagesToFile(foundUsages, context, jsonPath);
        }
        actionCallback.setDone();
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private void dumpFoundUsagesToFile(@NotNull List<FoundUsage> foundUsages, @NotNull PlaybackContext context, @NotNull Path jsonPath) {
        if (foundUsages == null) {
            FindUsagesCommand.$$$reportNull$$$0(1);
        }
        if (context == null) {
            FindUsagesCommand.$$$reportNull$$$0(2);
        }
        if (jsonPath == null) {
            FindUsagesCommand.$$$reportNull$$$0(3);
        }
        context.message("Found usages will be dumped to " + jsonPath, this.getLine());
        Collections.sort(foundUsages);
        FoundUsagesReport foundUsagesReport = new FoundUsagesReport(foundUsages.size(), foundUsages);
        try {
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(jsonPath.toFile(), (Object)foundUsagesReport);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write found usages to " + jsonPath, e);
        }
    }

    @NotNull
    private static FoundUsage convertToFoundUsage(@NotNull Project project, @NotNull Usage usage) {
        if (project == null) {
            FindUsagesCommand.$$$reportNull$$$0(4);
        }
        if (usage == null) {
            FindUsagesCommand.$$$reportNull$$$0(5);
        }
        PortableFilePath portableFilePath = null;
        Integer line = null;
        if (usage instanceof UsageInfo2UsageAdapter) {
            UsageInfo2UsageAdapter adapter = (UsageInfo2UsageAdapter)usage;
            VirtualFile file = (VirtualFile)ReadAction.compute(() -> adapter.getFile());
            if (file != null) {
                portableFilePath = PortableFilePaths.INSTANCE.getPortableFilePath(file, project);
            }
            line = adapter.getLine() + 1;
        }
        String text = (String)ReadAction.compute(() -> usage.getPresentation().getPlainText());
        return new FoundUsage(text, portableFilePath, line);
    }

    @Nullable
    private static Path getFoundUsagesJsonPath() {
        String property = System.getProperty(DUMP_FOUND_USAGES_DESTINATION_FILE);
        if (property != null) {
            return Paths.get(property, new String[0]);
        }
        return null;
    }

    @NotNull
    public static FoundUsagesReport parseFoundUsagesReportFromFile(@NotNull Path reportPath) throws IOException {
        if (reportPath == null) {
            FindUsagesCommand.$$$reportNull$$$0(6);
        }
        FoundUsagesReport foundUsagesReport = (FoundUsagesReport)objectMapper.readValue(reportPath.toFile(), FoundUsagesReport.class);
        if (foundUsagesReport == null) {
            FindUsagesCommand.$$$reportNull$$$0(7);
        }
        return foundUsagesReport;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundUsages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/FindUsagesCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/FindUsagesCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFoundUsagesReportFromFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dumpFoundUsagesToFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertToFoundUsage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseFoundUsagesReportFromFile";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class FoundUsage
    implements Comparable<FoundUsage> {
        @NotNull
        public final String text;
        @Nullable
        public final PortableFilePath portableFilePath;
        @Nullable
        public final Integer line;
        private static final Comparator<FoundUsage> COMPARATOR = Comparator.comparing(usage -> usage.portableFilePath != null ? usage.portableFilePath.getPresentablePath() : "").thenComparingInt(usage -> usage.line != null ? usage.line : -1).thenComparing(usage -> usage.text);

        @JsonCreator
        private FoundUsage(@JsonProperty(value="text") @NotNull String text, @JsonProperty(value="portableFilePath") @Nullable PortableFilePath portableFilePath, @JsonProperty(value="line") @Nullable Integer line) {
            if (text == null) {
                FoundUsage.$$$reportNull$$$0(0);
            }
            this.portableFilePath = portableFilePath;
            this.text = text;
            this.line = line;
        }

        @Override
        public int compareTo(@NotNull FoundUsage other) {
            if (other == null) {
                FoundUsage.$$$reportNull$$$0(1);
            }
            return COMPARATOR.compare(this, other);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FoundUsage)) {
                return false;
            }
            FoundUsage usage = (FoundUsage)o;
            return this.text.equals(usage.text) && Objects.equals(this.portableFilePath, usage.portableFilePath) && Objects.equals(this.line, usage.line);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.portableFilePath, this.line);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.portableFilePath != null) {
                builder.append("In file '").append(this.portableFilePath.getPresentablePath()).append("' ");
            }
            if (this.line != null) {
                builder.append("(at line #").append(this.line).append(") ");
            }
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(this.text);
            return builder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/performancePlugin/commands/FindUsagesCommand$FoundUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class FoundUsagesReport {
        public final int totalNumberOfUsages;
        public final List<FoundUsage> usages;

        @JsonCreator
        public FoundUsagesReport(@JsonProperty(value="totalNumberOfUsages") int totalNumberOfUsages, @JsonProperty(value="usages") @NotNull List<FoundUsage> foundUsages) {
            if (foundUsages == null) {
                FoundUsagesReport.$$$reportNull$$$0(0);
            }
            this.totalNumberOfUsages = totalNumberOfUsages;
            this.usages = foundUsages;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foundUsages", "com/jetbrains/performancePlugin/commands/FindUsagesCommand$FoundUsagesReport", "<init>"));
        }
    }
}

