/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class FindPluginDependenciesCommand
extends AbstractCommand {
    public static final String PREFIX = "%findDependencies";
    private static final Logger LOG = Logger.getInstance(FindPluginDependenciesCommand.class);

    public FindPluginDependenciesCommand(@NotNull String text, int line) {
        if (text == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String argsString = this.getText().substring(PREFIX.length()).trim();
        String[] args = argsString.split(",");
        String pluginIdString = args[0].trim();
        String fileToStoreDependencies = args[1].trim();
        PluginId pluginId = PluginId.getId((String)pluginIdString);
        ArrayList<String> foundDependencies = new ArrayList<String>();
        for (IdeaPluginDescriptor loadedPlugin : PluginManagerCore.getLoadedPlugins()) {
            if (loadedPlugin.getPluginId().equals(pluginId)) continue;
            List dependencies = ((IdeaPluginDescriptorImpl)loadedPlugin).getPluginDependencies();
            for (PluginDependency dependency : dependencies) {
                if (dependency.isOptional || !dependency.id.equals(pluginId)) continue;
                foundDependencies.add(loadedPlugin.getPluginId().getIdString());
            }
        }
        try {
            FileUtil.writeToFile((File)new File(fileToStoreDependencies), (String)String.join((CharSequence)"\n", foundDependencies));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        actionCallback.setDone();
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/performancePlugin/commands/FindPluginDependenciesCommand", "<init>"));
    }
}

