/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiManager;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class CheckOnRedCodeCommand
extends AbstractCommand {
    public static final String PREFIX = "%checkOnRedCode";
    private final Project myProject;

    public CheckOnRedCodeCommand(@NotNull String text, int line, @NotNull Project project) {
        if (text == null) {
            CheckOnRedCodeCommand.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CheckOnRedCodeCommand.$$$reportNull$$$0(1);
        }
        super(text, line);
        this.myProject = project;
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        if (context == null) {
            CheckOnRedCodeCommand.$$$reportNull$$$0(2);
        }
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        ApplicationManager.getApplication().invokeLater(() -> {
            final Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
            if (editor != null) {
                WriteAction.runAndWait(() -> {
                    PsiManager.getInstance((Project)this.myProject).dropPsiCaches();
                    final MessageBusConnection busConnection = this.myProject.getMessageBus().connect();
                    busConnection.subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListener(){

                        public void daemonFinished() {
                            busConnection.disconnect();
                            List errorsOnHighlighting = DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.ERROR, (Project)CheckOnRedCodeCommand.this.myProject);
                            if (errorsOnHighlighting.size() > 0) {
                                StringBuilder errorMessages = new StringBuilder("Highlighting has discovered some errors: " + errorsOnHighlighting.size());
                                for (HighlightInfo error : errorsOnHighlighting) {
                                    errorMessages.append("\n").append(error.getDescription());
                                }
                                context.message(errorMessages.toString(), CheckOnRedCodeCommand.this.getLine());
                                actionCallback.setRejected();
                            } else {
                                context.message("Highlighting performed successfully", CheckOnRedCodeCommand.this.getLine());
                                actionCallback.setDone();
                            }
                        }
                    });
                    DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
                });
            }
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            CheckOnRedCodeCommand.$$$reportNull$$$0(3);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/CheckOnRedCodeCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/CheckOnRedCodeCommand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

