/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectTaskManager;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class BuildCommand
extends AbstractCommand {
    public static final String PREFIX = "%buildProject";
    private final Project myProject;
    private static String REBUILD = "REBUILD";
    private static String BUILD = "BUILD";

    public BuildCommand(@NotNull String text, int line, @NotNull Project project) {
        if (text == null) {
            BuildCommand.$$$reportNull$$$0(0);
        }
        if (project == null) {
            BuildCommand.$$$reportNull$$$0(1);
        }
        super(text, line);
        this.myProject = project;
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        if (context == null) {
            BuildCommand.$$$reportNull$$$0(2);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String mode = this.getText().substring(PREFIX.length()).trim();
        final MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){

            public void compilationFinished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                if (compileContext == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (errors > 0) {
                    CompilerMessage[] errorMessages = compileContext.getMessages(CompilerMessageCategory.ERROR);
                    StringBuilder errorMessage = new StringBuilder("Errors happened during build: " + errors);
                    for (CompilerMessage error : errorMessages) {
                        errorMessage.append("\n").append(error);
                    }
                    context.message(errorMessage.toString(), BuildCommand.this.getLine());
                }
                if (warnings > 0) {
                    CompilerMessage[] warningMessages = compileContext.getMessages(CompilerMessageCategory.WARNING);
                    StringBuilder warningMessage = new StringBuilder("Warnings happened during build: " + errors);
                    for (CompilerMessage warning : warningMessages) {
                        warningMessage.append("\n").append(warning);
                    }
                    context.message(warningMessage.toString(), BuildCommand.this.getLine());
                }
                connection.disconnect();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compileContext", "com/jetbrains/performancePlugin/commands/BuildCommand$1", "compilationFinished"));
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> {
            ProjectTaskManager instance = ProjectTaskManager.getInstance((Project)this.myProject);
            Promise promise = null;
            if (mode.equals(BUILD)) {
                promise = instance.buildAllModules();
            } else if (mode.equals(REBUILD)) {
                promise = instance.rebuildAllModules();
            } else {
                actionCallback.reject("Specified mode is neither BUILD nor REBUILD");
            }
            if (promise != null) {
                promise.onSuccess(result -> {
                    boolean failed = BuildCommand.hasCompilationErrors(result);
                    if (failed) {
                        String errorMessage = PerformanceTestingBundle.message("command.build.finishWithCompilationErrors", new Object[0]);
                        context.message(errorMessage, this.getLine());
                        actionCallback.reject(errorMessage);
                    } else if (result.hasErrors() || result.isAborted() || this.myProject.isDisposed()) {
                        String errorMessage = PerformanceTestingBundle.message("command.build.finishWithErrors", new Object[0]);
                        context.message(errorMessage, this.getLine());
                        actionCallback.reject(errorMessage);
                    } else {
                        context.message(PerformanceTestingBundle.message("command.build.finish", new Object[0]), this.getLine());
                        actionCallback.setDone();
                    }
                });
            }
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            BuildCommand.$$$reportNull$$$0(3);
        }
        return promise;
    }

    public static boolean hasCompilationErrors(@NotNull ProjectTaskManager.Result result) {
        if (result == null) {
            BuildCommand.$$$reportNull$$$0(4);
        }
        return result.anyTaskMatches((task, state) -> task instanceof ModuleBuildTask && state.isFailed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/BuildCommand";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/BuildCommand";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasCompilationErrors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

