/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.diagnostic.VMOptions;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporter;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import com.intellij.util.SystemProperties;
import com.jetbrains.performancePlugin.CommandLogger;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.PlaybackRunnerExtended;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.profilers.YourKitProfilerHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProjectLoaded
implements StartupActivity.DumbAware,
ApplicationInitializedListener {
    private static final Logger LOG = Logger.getInstance((String)"PerformancePlugin");
    private static final int TIMEOUT = 500;
    private static final String TEST_SCRIPT_FILE_PATH = System.getProperty("testscript.filename");
    private static final boolean MUST_REPORT_TEAMCITY_TEST_FAILURE_ON_IDE_ERROR = Boolean.parseBoolean(System.getProperty("testscript.must.report.teamcity.test.failure.on.error", "true"));
    private static final boolean MUST_EXIT_PROCESS_WITH_NON_SUCCESS_CODE_ON_IDE_ERROR = Boolean.parseBoolean(System.getProperty("testscript.must.exist.process.with.non.success.code.on.ide.error", "false"));
    private static final String INDEXING_PROFILER_PREFIX = "%%profileIndexing";
    private final Alarm myAlarm = AlarmFactory.getInstance().create();

    ProjectLoaded() {
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            ProjectLoaded.$$$reportNull$$$0(0);
        }
        if (TEST_SCRIPT_FILE_PATH != null) {
            LOG.info("Start Execution");
            Pair<String, List<String>> profilerSettings = ProjectLoaded.initializeProfilerSettingsForIndexing();
            if (profilerSettings != null) {
                try {
                    ProfilersController.getInstance().getCurrentProfilerHandler().startProfiling((String)profilerSettings.first, (List)profilerSettings.second);
                }
                catch (Exception e) {
                    System.err.println("Start profile failed: " + e.getMessage());
                    ApplicationManagerEx.getApplicationEx().exit(true, true);
                }
            }
            if (System.getProperty("performance.execute.during.indexing") != null || LightEdit.owns((Project)project)) {
                ProjectLoaded.runScript(project);
            } else {
                this.runScriptAfterDumb(project);
            }
        } else {
            if (YourKitProfilerHandler.isStartupProfilingInVMEnabled() && VMOptions.getWriteFile() != null) {
                YourKitProfilerHandler.disableProfiler();
                ProjectLoaded.showStartupProfilingNotification();
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.info(PerformanceTestingBundle.message("startup.silent", new Object[0]));
            }
        }
    }

    private static Pair<String, List<String>> initializeProfilerSettingsForIndexing() {
        try {
            List lines = FileUtil.loadLines((File)ProjectLoaded.getTestFile());
            for (String line : lines) {
                if (!line.startsWith(INDEXING_PROFILER_PREFIX)) continue;
                String[] command = line.substring(INDEXING_PROFILER_PREFIX.length()).trim().split("\\s+", 2);
                String indexingActivity = command[0];
                ArrayList profilingParameters = command.length > 1 ? Arrays.asList(command[1].trim().split(",")) : new ArrayList();
                return new Pair((Object)indexingActivity, profilingParameters);
            }
        }
        catch (IOException ignored) {
            System.err.println(PerformanceTestingBundle.message("startup.script.read.error", new Object[0]));
            ApplicationManagerEx.getApplicationEx().exit(true, true);
        }
        return null;
    }

    private static File getTestFile() {
        File file = new File(TEST_SCRIPT_FILE_PATH);
        if (!file.isFile()) {
            System.err.println(PerformanceTestingBundle.message("startup.noscript", file.getAbsolutePath()));
            ApplicationManagerEx.getApplicationEx().exit(true, true);
        }
        return file;
    }

    private static void showStartupProfilingNotification() {
        final File snapshotDir = new File(SystemProperties.getUserHome(), "snapshots");
        final Notification completeNotification = new Notification("PerformancePlugin", PerformanceTestingBundle.message("notification.title.startup.profiling.in.progress", new Object[0]), PerformanceTestingBundle.message("notification.message.cpu.snapshot.file", snapshotDir.getAbsolutePath()), NotificationType.INFORMATION);
        completeNotification.addAction(new AnAction(PerformanceTestingBundle.message("action.text.show.profile.location", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileUtil.createDirectory((File)snapshotDir);
                RevealFileAction.openDirectory((File)snapshotDir);
                completeNotification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/performancePlugin/ProjectLoaded$1", "actionPerformed"));
            }
        });
        Notifications.Bus.notify((Notification)completeNotification);
    }

    private static void subscribeToErrors() {
        MessagePool messagePool = MessagePool.getInstance();
        LOG.info("Error watcher has started");
        messagePool.addListener(() -> {
            List ideErrors = messagePool.getFatalErrors(false, true);
            if (!ideErrors.isEmpty()) {
                for (AbstractMessage message : ideErrors) {
                    message.setRead(true);
                    try {
                        ProjectLoaded.reportScriptError(message);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
    }

    private static void reportScriptError(@NotNull AbstractMessage errorMessage) throws IOException {
        if (errorMessage == null) {
            ProjectLoaded.$$$reportNull$$$0(1);
        }
        String message = errorMessage.getMessage();
        Throwable throwable = errorMessage.getThrowable();
        if (message == null || message.isEmpty()) {
            message = ProjectLoaded.getNonEmptyThrowableMessage(throwable);
        }
        String stacktrace = errorMessage.getThrowableText();
        String position = throwable.getStackTrace()[0].toString();
        Path scriptErrorsDir = Paths.get(PathManager.getLogPath(), "script-errors");
        Files.createDirectories(scriptErrorsDir, new FileAttribute[0]);
        for (int i = 1; i < 1000; ++i) {
            Path errorDir = scriptErrorsDir.resolve("error-" + i);
            if (Files.exists(errorDir, new LinkOption[0])) continue;
            Files.createDirectories(errorDir, new FileAttribute[0]);
            Files.writeString(errorDir.resolve("message.txt"), (CharSequence)message, new OpenOption[0]);
            Files.writeString(errorDir.resolve("stacktrace.txt"), (CharSequence)stacktrace, new OpenOption[0]);
            Files.writeString(errorDir.resolve("position.txt"), (CharSequence)position, new OpenOption[0]);
            return;
        }
        LOG.error("Too many errors have been reported during script execution. See " + scriptErrorsDir);
    }

    @NotNull
    private static String getNonEmptyThrowableMessage(@NotNull Throwable throwable) {
        String causeMessage;
        if (throwable == null) {
            ProjectLoaded.$$$reportNull$$$0(2);
        }
        if (throwable.getCause() != null && (causeMessage = throwable.getCause().getMessage()) != null) {
            String string = causeMessage;
            if (string == null) {
                ProjectLoaded.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = throwable.getClass().getName();
        if (string == null) {
            ProjectLoaded.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String getTeamCityFailedTestName() {
        String string = FileUtilRt.getNameWithoutExtension((String)ProjectLoaded.getTestFile().getName());
        if (string == null) {
            ProjectLoaded.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void reportTeamCityFailedTestAndBuildProblem(@NotNull String testName, @NotNull String failureMessage, @NotNull String failureDetails) {
        if (testName == null) {
            ProjectLoaded.$$$reportNull$$$0(6);
        }
        if (failureMessage == null) {
            ProjectLoaded.$$$reportNull$$$0(7);
        }
        if (failureDetails == null) {
            ProjectLoaded.$$$reportNull$$$0(8);
        }
        System.out.printf("##teamcity[testFailed name='%s' message='%s' details='%s']\n", ProjectLoaded.encodeStringForTC(testName), ProjectLoaded.encodeStringForTC(failureMessage), ProjectLoaded.encodeStringForTC(failureDetails));
        System.out.printf("##teamcity[buildProblem description='%s' identity='%s'] ", ProjectLoaded.encodeStringForTC(failureMessage), ProjectLoaded.encodeStringForTC(testName));
    }

    @NotNull
    private static String encodeStringForTC(@NotNull String line) {
        if (line == null) {
            ProjectLoaded.$$$reportNull$$$0(9);
        }
        int MAX_DESCRIPTION_LENGTH = 10000;
        String string = line.substring(0, Math.min(10000, line.length())).replaceAll("\\|", "||").replaceAll("\\[", "|[").replaceAll("]", "|]").replaceAll("\n", "|n").replaceAll("'", "|'").replaceAll("\r", "|r");
        if (string == null) {
            ProjectLoaded.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void componentsInitialized() {
        if (((ApplicationImpl)ApplicationManager.getApplication()).isLightEditMode()) {
            LightEditService.getInstance().getEditorManager().addListener(new LightEditorListener(){

                public void afterSelect(@Nullable LightEditorInfo editorInfo) {
                    StartUpPerformanceReporter.Companion.logStats("LightEditor");
                    ProjectLoaded.this.runActivity(LightEditService.getInstance().getProject());
                }
            });
        }
    }

    private void runScriptAfterDumb(Project project) {
        DumbService.getInstance((Project)project).smartInvokeLater(() -> this.myAlarm.addRequest(() -> {
            if (DumbService.isDumb((Project)project)) {
                this.runScriptAfterDumb(project);
            } else {
                ProjectLoaded.runScript(project);
            }
        }, 500));
    }

    private static void runScript(Project project) {
        PlaybackRunnerExtended playback = new PlaybackRunnerExtended("%include " + ProjectLoaded.getTestFile(), new CommandLogger(), project);
        playback.setScriptDir(ProjectLoaded.getTestFile().getParentFile());
        ActionCallback scriptCallback = playback.run();
        scriptCallback.doWhenDone(() -> LOG.info("Execution of the script has been finished successfully")).doWhenRejected(errorMessage -> {
            String message = "IDE will be terminated because some errors are detected while running the startup script: " + errorMessage;
            if (MUST_REPORT_TEAMCITY_TEST_FAILURE_ON_IDE_ERROR) {
                String testName = ProjectLoaded.getTeamCityFailedTestName();
                ProjectLoaded.reportTeamCityFailedTestAndBuildProblem(testName, message, "");
            }
            LOG.error(message);
            String threadDump = "Thread dump before IDE termination:\n" + ThreadDumper.dumpThreadsToString();
            LOG.info(threadDump);
            if (MUST_EXIT_PROCESS_WITH_NON_SUCCESS_CODE_ON_IDE_ERROR) {
                System.exit(1);
            } else {
                ApplicationManagerEx.getApplicationEx().exit(true, true);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/ProjectLoaded";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failureMessage";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failureDetails";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/ProjectLoaded";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEmptyThrowableMessage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTeamCityFailedTestName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeStringForTC";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reportScriptError";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyThrowableMessage";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reportTeamCityFailedTestAndBuildProblem";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "encodeStringForTC";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class MyAppLifecycleListener
    implements AppLifecycleListener {
        MyAppLifecycleListener() {
            if (TEST_SCRIPT_FILE_PATH == null) {
                throw ExtensionNotApplicableException.INSTANCE;
            }
        }

        public void appStarting(@Nullable Project projectFromCommandLine) {
            ProjectLoaded.subscribeToErrors();
        }
    }
}

