/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler.tools;

import com.android.ide.common.signing.KeytoolException;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.google.common.base.Predicate;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.DateFormatUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.android.util.AndroidBuildTestingManager;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidExecutionUtil;
import org.jetbrains.android.util.AndroidNativeLibData;
import org.jetbrains.android.util.ApkContentFilter;
import org.jetbrains.android.util.DebugKeyProvider;
import org.jetbrains.android.util.SafeSignedJarBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidApkBuilder {
    private static final Logger LOG = Logger.getInstance(AndroidApkBuilder.class);
    @NonNls
    private static final String UNALIGNED_SUFFIX = ".unaligned";
    @NonNls
    private static final String EXT_NATIVE_LIB = "so";

    private AndroidApkBuilder() {
    }

    private static Map<AndroidCompilerMessageKind, List<String>> filterUsingKeystoreMessages(Map<AndroidCompilerMessageKind, List<String>> messages) {
        List<String> infoMessages = messages.get((Object)AndroidCompilerMessageKind.INFORMATION);
        if (infoMessages == null) {
            infoMessages = new ArrayList<String>();
            messages.put(AndroidCompilerMessageKind.INFORMATION, infoMessages);
        }
        List<String> errors = messages.get((Object)AndroidCompilerMessageKind.ERROR);
        Iterator<String> iterator = errors.iterator();
        while (iterator.hasNext()) {
            String s = iterator.next();
            if (!s.startsWith("Using keystore:")) continue;
            infoMessages.add(s);
            iterator.remove();
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectDuplicateEntries(@NotNull String rootFile, @NotNull Set<String> entries, @NotNull Set<String> result) throws IOException {
        if (rootFile == null) {
            AndroidApkBuilder.$$$reportNull$$$0(0);
        }
        if (entries == null) {
            AndroidApkBuilder.$$$reportNull$$$0(1);
        }
        if (result == null) {
            AndroidApkBuilder.$$$reportNull$$$0(2);
        }
        ApkContentFilter apkContentFilter = new ApkContentFilter();
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            ZipEntry entry;
            fis = new FileInputStream(rootFile);
            zis = new ZipInputStream(fis);
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (apkContentFilter.checkEntry(name) && !entries.add(name)) {
                    result.add(name);
                }
                zis.closeEntry();
            }
        }
        finally {
            if (zis != null) {
                zis.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static Map<AndroidCompilerMessageKind, List<String>> execute(@NotNull String resPackagePath, @NotNull String dexPath, @NotNull String[] resourceRoots, @NotNull String[] externalJars, @NotNull String[] nativeLibsFolders, @NotNull Collection<AndroidNativeLibData> additionalNativeLibs, @NotNull String finalApk, boolean unsigned, @NotNull String sdkPath, @NotNull IAndroidTarget target, @Nullable String customKeystorePath, @NotNull Condition<File> resourceFilter) throws IOException {
        block22: {
            block20: {
                block21: {
                    block18: {
                        block19: {
                            if (resPackagePath == null) {
                                AndroidApkBuilder.$$$reportNull$$$0(3);
                            }
                            if (dexPath == null) {
                                AndroidApkBuilder.$$$reportNull$$$0(4);
                            }
                            if (resourceRoots == null) {
                                AndroidApkBuilder.$$$reportNull$$$0(5);
                            }
                            if (externalJars == null) {
                                AndroidApkBuilder.$$$reportNull$$$0(6);
                            }
                            if (nativeLibsFolders == null) {
                                AndroidApkBuilder.$$$reportNull$$$0(7);
                            }
                            if (additionalNativeLibs == null) {
                                AndroidApkBuilder.$$$reportNull$$$0(8);
                            }
                            if (finalApk == null) {
                                AndroidApkBuilder.$$$reportNull$$$0(9);
                            }
                            if (sdkPath == null) {
                                AndroidApkBuilder.$$$reportNull$$$0(10);
                            }
                            if (target == null) {
                                AndroidApkBuilder.$$$reportNull$$$0(11);
                            }
                            if (resourceFilter == null) {
                                AndroidApkBuilder.$$$reportNull$$$0(12);
                            }
                            if ((testingManager = AndroidBuildTestingManager.getTestingManager()) != null) {
                                testingManager.getCommandExecutor().log(StringUtil.join((String[])new String[]{"apk_builder", resPackagePath, dexPath, AndroidBuildTestingManager.arrayToString(resourceRoots), AndroidBuildTestingManager.arrayToString(externalJars), AndroidBuildTestingManager.arrayToString(nativeLibsFolders), additionalNativeLibs.toString(), finalApk, Boolean.toString(unsigned), sdkPath, customKeystorePath}, (String)"\n"));
                            }
                            map = new HashMap<AndroidCompilerMessageKind, List<String>>();
                            map.put(AndroidCompilerMessageKind.ERROR, new ArrayList<E>());
                            map.put(AndroidCompilerMessageKind.WARNING, new ArrayList<E>());
                            outputDir = new File(finalApk).getParentFile();
                            if (!outputDir.exists() && !outputDir.mkdirs()) {
                                ((List)map.get((Object)AndroidCompilerMessageKind.ERROR)).add("Cannot create directory " + outputDir.getPath());
                                return map;
                            }
                            additionalLibsDir = null;
                            try {
                                if (additionalNativeLibs.isEmpty()) ** GOTO lbl52
                                additionalLibsDir = FileUtil.createTempDirectory((String)"android_additional_libs", (String)"tmp");
                                if (AndroidApkBuilder.copyNativeLibs(additionalNativeLibs, additionalLibsDir, map)) break block18;
                                var16_16 = map;
                                if (additionalLibsDir == null) break block19;
                            }
                            catch (Throwable var22_24) {
                                if (additionalLibsDir != null) {
                                    FileUtil.delete(additionalLibsDir);
                                }
                                throw var22_24;
                            }
                            FileUtil.delete((File)additionalLibsDir);
                        }
                        return var16_16;
                    }
                    nativeLibsFolders = (String[])ArrayUtil.append((Object[])nativeLibsFolders, (Object)additionalLibsDir.getPath());
lbl52:
                    // 2 sources

                    if (!unsigned) break block20;
                    var16_17 = AndroidApkBuilder.filterUsingKeystoreMessages(AndroidApkBuilder.finalPackage(dexPath, resourceRoots, externalJars, nativeLibsFolders, finalApk, resPackagePath, customKeystorePath, false, resourceFilter));
                    if (additionalLibsDir == null) break block21;
                    FileUtil.delete((File)additionalLibsDir);
                }
                return var16_17;
            }
            buildTool = target.getBuildToolInfo();
            zipAlignPath = buildTool.getPath(BuildToolInfo.PathId.ZIP_ALIGN);
            withAlignment = new File(zipAlignPath).exists();
            unalignedApk = AndroidBuildCommonUtils.addSuffixToFileName(finalApk, ".unaligned");
            map2 = AndroidApkBuilder.filterUsingKeystoreMessages(AndroidApkBuilder.finalPackage(dexPath, resourceRoots, externalJars, nativeLibsFolders, withAlignment != false ? unalignedApk : finalApk, resPackagePath, customKeystorePath, true, resourceFilter));
            map.putAll(map2);
            if (withAlignment && ((List)map.get((Object)AndroidCompilerMessageKind.ERROR)).isEmpty()) {
                map2 = AndroidExecutionUtil.doExecute(new String[]{zipAlignPath, "-f", "4", unalignedApk, finalApk});
                map.putAll(map2);
            }
            var21_23 = map;
            if (additionalLibsDir == null) break block22;
            FileUtil.delete((File)additionalLibsDir);
        }
        return var21_23;
    }

    private static boolean copyNativeLibs(@NotNull Collection<AndroidNativeLibData> libs, @NotNull File targetDir, @NotNull Map<AndroidCompilerMessageKind, List<String>> map) throws IOException {
        if (libs == null) {
            AndroidApkBuilder.$$$reportNull$$$0(13);
        }
        if (targetDir == null) {
            AndroidApkBuilder.$$$reportNull$$$0(14);
        }
        if (map == null) {
            AndroidApkBuilder.$$$reportNull$$$0(15);
        }
        for (AndroidNativeLibData lib : libs) {
            String path = lib.getPath();
            File srcFile = new File(path);
            if (!srcFile.exists()) {
                map.get((Object)AndroidCompilerMessageKind.WARNING).add("File not found: " + FileUtil.toSystemDependentName((String)path) + ". The native library won't be placed into APK");
                continue;
            }
            File dstDir = new File(targetDir, lib.getArchitecture());
            File dstFile = new File(dstDir, lib.getTargetFileName());
            if (dstFile.exists()) {
                map.get((Object)AndroidCompilerMessageKind.WARNING).add("Duplicate native library " + dstFile.getName() + "; " + dstFile.getPath() + " already exists");
                continue;
            }
            if (!dstDir.exists() && !dstDir.mkdirs()) {
                map.get((Object)AndroidCompilerMessageKind.ERROR).add("Cannot create directory: " + FileUtil.toSystemDependentName((String)dstDir.getPath()));
                continue;
            }
            FileUtil.copy((File)srcFile, (File)dstFile);
        }
        return map.get((Object)AndroidCompilerMessageKind.ERROR).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<AndroidCompilerMessageKind, List<String>> finalPackage(@NotNull String dexPath, @NotNull String[] javaResourceRoots, @NotNull String[] externalJars, @NotNull String[] nativeLibsFolders, @NotNull String outputApk, @NotNull String resApkPath, @Nullable String customKeystorePath, boolean signed, @NotNull Condition<File> resourceFilter) {
        Map<AndroidCompilerMessageKind, List<String>> map;
        if (dexPath == null) {
            AndroidApkBuilder.$$$reportNull$$$0(16);
        }
        if (javaResourceRoots == null) {
            AndroidApkBuilder.$$$reportNull$$$0(17);
        }
        if (externalJars == null) {
            AndroidApkBuilder.$$$reportNull$$$0(18);
        }
        if (nativeLibsFolders == null) {
            AndroidApkBuilder.$$$reportNull$$$0(19);
        }
        if (outputApk == null) {
            AndroidApkBuilder.$$$reportNull$$$0(20);
        }
        if (resApkPath == null) {
            AndroidApkBuilder.$$$reportNull$$$0(21);
        }
        if (resourceFilter == null) {
            AndroidApkBuilder.$$$reportNull$$$0(22);
        }
        HashMap<AndroidCompilerMessageKind, List<String>> result = new HashMap<AndroidCompilerMessageKind, List<String>>();
        result.put(AndroidCompilerMessageKind.ERROR, new ArrayList());
        result.put(AndroidCompilerMessageKind.INFORMATION, new ArrayList());
        result.put(AndroidCompilerMessageKind.WARNING, new ArrayList());
        SafeSignedJarBuilder builder = null;
        try {
            X509Certificate certificate;
            String keyStoreOsPath = customKeystorePath != null && !customKeystorePath.isEmpty() ? customKeystorePath : DebugKeyProvider.getDefaultKeyStoreOsPath();
            DebugKeyProvider provider = AndroidApkBuilder.createDebugKeyProvider(keyStoreOsPath);
            X509Certificate x509Certificate = certificate = signed ? (X509Certificate)provider.getCertificate() : null;
            if (certificate != null && certificate.getNotAfter().compareTo(new Date()) < 0) {
                File keyStoreFile = new File(keyStoreOsPath);
                if (keyStoreFile.exists()) {
                    keyStoreFile.delete();
                }
                provider = AndroidApkBuilder.createDebugKeyProvider(keyStoreOsPath);
                certificate = (X509Certificate)provider.getCertificate();
            }
            if (certificate != null && certificate.getNotAfter().compareTo(new Date()) < 0) {
                String date = DateFormatUtil.formatPrettyDateTime((Date)certificate.getNotAfter());
                ((List)result.get((Object)AndroidCompilerMessageKind.ERROR)).add("Debug certificate expired on " + date + ". Cannot regenerate it, please delete file \"" + keyStoreOsPath + "\" manually.");
                HashMap<AndroidCompilerMessageKind, List<String>> hashMap = result;
                return hashMap;
            }
            PrivateKey key = provider.getDebugKey();
            if (key == null) {
                ((List)result.get((Object)AndroidCompilerMessageKind.ERROR)).add("Cannot create new key or keystore");
                HashMap<AndroidCompilerMessageKind, List<String>> hashMap = result;
                return hashMap;
            }
            if (!new File(resApkPath).exists()) {
                ((List)result.get((Object)AndroidCompilerMessageKind.ERROR)).add("File " + resApkPath + " not found. Try to rebuild project");
                HashMap<AndroidCompilerMessageKind, List<String>> hashMap = result;
                return hashMap;
            }
            File dexEntryFile = new File(dexPath);
            if (!dexEntryFile.exists()) {
                ((List)result.get((Object)AndroidCompilerMessageKind.ERROR)).add("File " + dexEntryFile.getPath() + " not found. Try to rebuild project");
                HashMap<AndroidCompilerMessageKind, List<String>> hashMap = result;
                return hashMap;
            }
            for (String externalJar : externalJars) {
                if (!new File(externalJar).isDirectory()) continue;
                ((List)result.get((Object)AndroidCompilerMessageKind.ERROR)).add(externalJar + " is directory. Directory libraries are not supported");
            }
            if (!((List)result.get((Object)AndroidCompilerMessageKind.ERROR)).isEmpty()) {
                HashMap<AndroidCompilerMessageKind, List<String>> hashMap = result;
                return hashMap;
            }
            builder = new SafeSignedJarBuilder(key, certificate, outputApk);
            builder.writeZip(new File(resApkPath), null);
            builder.writeFile(dexEntryFile, "classes.dex");
            HashSet<String> hashSet = new HashSet<String>();
            for (String resourceRootPath : javaResourceRoots) {
                HashSet<File> javaResources = new HashSet<File>();
                File resourceRoot = new File(resourceRootPath);
                AndroidApkBuilder.collectStandardJavaResources(resourceRoot, javaResources, resourceFilter);
                AndroidApkBuilder.writeStandardJavaResources(javaResources, resourceRoot, builder, hashSet);
            }
            HashSet<String> duplicates = new HashSet<String>();
            HashSet<String> entries = new HashSet<String>();
            for (String externalJar : externalJars) {
                AndroidApkBuilder.collectDuplicateEntries(externalJar, entries, duplicates);
            }
            for (String duplicate : duplicates) {
                ((List)result.get((Object)AndroidCompilerMessageKind.WARNING)).add("Duplicate entry " + duplicate + ". The file won't be added");
            }
            MyResourceFilter filter = new MyResourceFilter(duplicates);
            for (String externalJar : externalJars) {
                builder.writeZip(new File(externalJar), (Predicate<String>)((Predicate)filter::isIgnored));
            }
            HashSet<String> nativeLibs = new HashSet<String>();
            for (String nativeLibsFolderPath : nativeLibsFolders) {
                File nativeLibsFolder = new File(nativeLibsFolderPath);
                File[] children = nativeLibsFolder.listFiles();
                if (children == null) continue;
                for (File child : children) {
                    AndroidApkBuilder.writeNativeLibraries(builder, nativeLibsFolder, child, signed, nativeLibs);
                }
            }
        }
        catch (IOException e) {
            map = AndroidApkBuilder.addExceptionMessage(e, result);
            return map;
        }
        catch (CertificateException e) {
            map = AndroidApkBuilder.addExceptionMessage(e, result);
            return map;
        }
        catch (KeytoolException e) {
            map = AndroidApkBuilder.addExceptionMessage((Exception)((Object)e), result);
            return map;
        }
        catch (AndroidLocation.AndroidLocationException e) {
            map = AndroidApkBuilder.addExceptionMessage((Exception)((Object)e), result);
            return map;
        }
        catch (NoSuchAlgorithmException e) {
            map = AndroidApkBuilder.addExceptionMessage(e, result);
            return map;
        }
        catch (UnrecoverableEntryException e) {
            map = AndroidApkBuilder.addExceptionMessage(e, result);
            return map;
        }
        catch (KeyStoreException e) {
            map = AndroidApkBuilder.addExceptionMessage(e, result);
            return map;
        }
        finally {
            if (builder != null) {
                try {
                    builder.close();
                }
                catch (IOException e) {
                    AndroidApkBuilder.addExceptionMessage(e, result);
                }
            }
        }
        return result;
    }

    private static DebugKeyProvider createDebugKeyProvider(@Nullable String path) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException, IOException, KeytoolException, AndroidLocation.AndroidLocationException {
        return new DebugKeyProvider(path, null);
    }

    private static void writeNativeLibraries(SafeSignedJarBuilder builder, File nativeLibsFolder, File child, boolean debugBuild, Set<String> added) throws IOException {
        ArrayList<File> list = new ArrayList<File>();
        AndroidApkBuilder.collectNativeLibraries(child, list, debugBuild);
        for (File file : list) {
            String relativePath = FileUtil.getRelativePath((File)nativeLibsFolder, (File)file);
            String path = FileUtil.toSystemIndependentName((String)("lib" + File.separator + relativePath));
            if (added.add(path)) {
                builder.writeFile(file, path);
                LOG.info("Native lib file added to APK: " + file.getPath());
                continue;
            }
            LOG.info("Duplicate in APK: native lib file " + file.getPath() + " won't be added.");
        }
    }

    private static Map<AndroidCompilerMessageKind, List<String>> addExceptionMessage(Exception e, Map<AndroidCompilerMessageKind, List<String>> result) {
        LOG.info((Throwable)e);
        String simpleExceptionName = e.getClass().getCanonicalName();
        result.get((Object)AndroidCompilerMessageKind.ERROR).add(simpleExceptionName + ": " + e.getMessage());
        return result;
    }

    public static void collectNativeLibraries(@NotNull File file, @NotNull List<File> result, boolean debugBuild) {
        File[] children;
        if (file == null) {
            AndroidApkBuilder.$$$reportNull$$$0(23);
        }
        if (result == null) {
            AndroidApkBuilder.$$$reportNull$$$0(24);
        }
        if (!file.isDirectory()) {
            if (FileUtilRt.extensionEquals((String)file.getName(), (String)EXT_NATIVE_LIB) || debugBuild && !FileUtilRt.extensionEquals((String)file.getName(), (String)"jar")) {
                result.add(file);
            }
        } else if (ApkContentFilter.checkFolderForPackaging(file.getName()) && (children = file.listFiles()) != null) {
            for (File child : children) {
                AndroidApkBuilder.collectNativeLibraries(child, result, debugBuild);
            }
        }
    }

    public static void collectStandardJavaResources(@NotNull File folder, @NotNull Collection<File> result, @NotNull Condition<? super File> filter) {
        File[] children;
        if (folder == null) {
            AndroidApkBuilder.$$$reportNull$$$0(25);
        }
        if (result == null) {
            AndroidApkBuilder.$$$reportNull$$$0(26);
        }
        if (filter == null) {
            AndroidApkBuilder.$$$reportNull$$$0(27);
        }
        if ((children = folder.listFiles()) != null) {
            for (File child : children) {
                if (!child.exists()) continue;
                if (child.isDirectory()) {
                    if (!ApkContentFilter.checkFolderForPackaging(child.getName()) || !filter.value((Object)child)) continue;
                    AndroidApkBuilder.collectStandardJavaResources(child, result, filter);
                    continue;
                }
                if (!AndroidApkBuilder.checkFileForPackaging(child) || !filter.value((Object)child)) continue;
                result.add(child);
            }
        }
    }

    private static void writeStandardJavaResources(Collection<File> resources, File sourceRoot, SafeSignedJarBuilder jarBuilder, Set<String> added) throws IOException {
        for (File child : resources) {
            String relativePath = FileUtil.getRelativePath((File)sourceRoot, (File)child);
            if (relativePath == null || added.contains(relativePath)) continue;
            jarBuilder.writeFile(child, FileUtil.toSystemIndependentName((String)relativePath));
            added.add(relativePath);
        }
    }

    public static boolean checkFileForPackaging(@NotNull File file) {
        String fileName;
        if (file == null) {
            AndroidApkBuilder.$$$reportNull$$$0(28);
        }
        if (!(fileName = FileUtil.getNameWithoutExtension((File)file)).isEmpty()) {
            String extension = FileUtilRt.getExtension((String)file.getName());
            if ("apk".equals(extension)) {
                return false;
            }
            return ApkContentFilter.checkFileForPackaging(fileName, extension);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 2: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resPackagePath";
                break;
            }
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceRoots";
                break;
            }
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalJars";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nativeLibsFolders";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalNativeLibs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalApk";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFilter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libs";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaResourceRoots";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputApk";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resApkPath";
                break;
            }
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/compiler/tools/AndroidApkBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDuplicateEntries";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "copyNativeLibs";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "finalPackage";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNativeLibraries";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "collectStandardJavaResources";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFileForPackaging";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyResourceFilter
    extends ApkContentFilter {
        private final Set<String> myExcludedEntries;

        private MyResourceFilter(@NotNull Set<String> excludedEntries) {
            if (excludedEntries == null) {
                MyResourceFilter.$$$reportNull$$$0(0);
            }
            this.myExcludedEntries = excludedEntries;
        }

        @Override
        public boolean checkEntry(String name) {
            if (this.myExcludedEntries.contains(name)) {
                return false;
            }
            return super.checkEntry(name);
        }

        public boolean isIgnored(String name) {
            return !this.checkEntry(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludedEntries", "org/jetbrains/android/compiler/tools/AndroidApkBuilder$MyResourceFilter", "<init>"));
        }
    }
}

