/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph;

import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.model.xml.navigationRules.NavigationRule;
import com.intellij.jsf.yfilesGraph.AbstractFacesGraphDataModel;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacesNavigationDataModel
extends AbstractFacesGraphDataModel {
    public FacesNavigationDataModel(FacesConfig facesConfig) {
        super(facesConfig);
    }

    @Override
    public void updateDataModel() {
        for (NavigationRule rule : this.getFacesConfig().getNavigationRules()) {
            String source = rule.getFromViewId().getStringValue();
            if (source == null) {
                source = "EMPTY_NODE";
            }
            this.addNode(source);
            for (NavigationCase navigationCase : rule.getNavigationCases()) {
                String toViewId = navigationCase.getToViewId().getStringValue();
                if (toViewId == null || toViewId.trim().length() <= 0) continue;
                this.addNode(toViewId);
                this.addEdge(navigationCase, source, toViewId);
            }
        }
    }

    public NavigationCase createEdge(@NotNull String from, @NotNull String to) {
        boolean isWritable;
        if (from == null) {
            FacesNavigationDataModel.$$$reportNull$$$0(0);
        }
        if (to == null) {
            FacesNavigationDataModel.$$$reportNull$$$0(1);
        }
        if (!(isWritable = FacesNavigationDataModel.ensureFileWritable(DomUtil.getFile((DomElement)this.getFacesConfig()).getVirtualFile(), this.getFacesConfig().getManager().getProject()))) {
            return null;
        }
        NavigationRule[] rule = new NavigationRule[]{null};
        boolean isEmptyNode = "EMPTY_NODE".equals(from);
        for (NavigationRule navigationRule : this.getFacesConfig().getNavigationRules()) {
            if ((!isEmptyNode || navigationRule.getFromViewId().getStringValue() != null) && !from.equals(navigationRule.getFromViewId().getStringValue())) continue;
            rule[0] = navigationRule;
        }
        return (NavigationCase)WriteCommandAction.writeCommandAction((Project)this.getFacesConfig().getManager().getProject()).compute(() -> {
            if (rule[0] == null) {
                rule[0] = this.getFacesConfig().addNavigationRule();
                rule[0].getFromViewId().setStringValue(isEmptyNode ? "*" : from);
            }
            NavigationCase navigationCase = rule[0].addNavigationCase();
            navigationCase.getToViewId().setStringValue(to);
            return navigationCase;
        });
    }

    private static boolean ensureFileWritable(@Nullable VirtualFile virtualFile, Project project) {
        ReadonlyStatusHandler.OperationStatus status;
        return virtualFile == null || virtualFile.isWritable() || !(status = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(virtualFile))).hasReadonlyFiles();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "from";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "to";
                break;
            }
        }
        objectArray[1] = "com/intellij/jsf/yfilesGraph/FacesNavigationDataModel";
        objectArray[2] = "createEdge";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

