/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph;

import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.yfilesGraph.FacesGraphPresentationModel;
import com.intellij.jsf.yfilesGraph.FacesNavigationDataModel;
import com.intellij.jsf.yfilesGraph.JsfProjectViewDnDSupport;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.dnd.ProjectViewDnDHelper;
import com.intellij.openapi.graph.builder.dnd.ProjectViewDnDSupport;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacesBuildersFactory {
    @NonNls
    public static String FACES_CONFIG_KEY = "FACES_CONFIG_KEY";
    @NonNls
    public static String GRAPH_BUILDER_KEY = "GRAPH_BUILDER_KEY";

    public static GraphBuilderImpl<String, NavigationCase> createNavigationBuilder(@NotNull FacesConfig facesConfig, Graph2D graph, Graph2DView view) {
        if (facesConfig == null) {
            FacesBuildersFactory.$$$reportNull$$$0(0);
        }
        return FacesBuildersFactory.createBuilder(facesConfig, graph, view, new FacesNavigationDataModel(facesConfig), (GraphPresentationModel<String, NavigationCase>)new FacesGraphPresentationModel(facesConfig, graph));
    }

    private static GraphBuilderImpl<String, NavigationCase> createBuilder(FacesConfig facesConfig, Graph2D graph, Graph2DView view, GraphDataModel<String, NavigationCase> model, GraphPresentationModel<String, NavigationCase> presentationModel) {
        GraphBuilderFactory builderFactory = GraphBuilderFactory.getInstance((Project)facesConfig.getManager().getProject());
        GraphBuilderImpl builder = (GraphBuilderImpl)builderFactory.createGraphBuilder(graph, view, model, presentationModel);
        GraphViewUtil.addDataProvider((Graph2DView)builder.getView(), (DataProvider)new MyDataProvider(facesConfig, (GraphBuilder)builder));
        WebFacet webFacet = FacesBuildersFactory.getWebFacet(facesConfig);
        if (webFacet != null) {
            ProjectViewDnDHelper.getInstance((Project)facesConfig.getManager().getProject()).addProjectViewDnDSupport((GraphBuilder)builder, (ProjectViewDnDSupport)new JsfProjectViewDnDSupport((GraphBuilder<String, NavigationCase>)builder, webFacet));
        }
        return builder;
    }

    @Nullable
    private static WebFacet getWebFacet(FacesConfig facesConfig) {
        XmlTag xmlTag = facesConfig.getXmlTag();
        return xmlTag == null ? null : WebUtil.getWebFacet((PsiElement)xmlTag.getContainingFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facesConfig", "com/intellij/jsf/yfilesGraph/FacesBuildersFactory", "createNavigationBuilder"));
    }

    private static class MyDataProvider
    implements DataProvider {
        private final FacesConfig myFacesConfig;
        private final GraphBuilder myBuilder;

        MyDataProvider(FacesConfig facesConfig, GraphBuilder builder) {
            this.myFacesConfig = facesConfig;
            this.myBuilder = builder;
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyDataProvider.$$$reportNull$$$0(0);
            }
            if (FACES_CONFIG_KEY.equals(dataId)) {
                return this.myFacesConfig;
            }
            if (GRAPH_BUILDER_KEY.equals(dataId)) {
                return this.myBuilder;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/jsf/yfilesGraph/FacesBuildersFactory$MyDataProvider", "getData"));
        }
    }
}

