/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph;

import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.graph.base.DataProvider;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import org.jetbrains.annotations.Nullable;

public class DragAndDropNavigationGraphHelper {
    public static Key NODE_DRAGGED_DATA_PROVIDER = Key.create((String)"NODE_DRAGGED_DATA_PROVIDER");
    public static Key NODE_DRAGGED_INFO = Key.create((String)"NODE_DRAGGED_INFO");
    private final FacesConfig myFacesConfig;
    private final GraphBuilder<String, NavigationCase> myBuilder;

    public DragAndDropNavigationGraphHelper(FacesConfig facesConfig, GraphBuilder<String, NavigationCase> builder) {
        this.myFacesConfig = facesConfig;
        this.myBuilder = builder;
        this.myBuilder.getGraph().addDataProvider((Object)NODE_DRAGGED_DATA_PROVIDER, (DataProvider)this.myBuilder.getGraph().createNodeMap());
        this.createDropTarget();
    }

    private void createDropTarget() {
        new DropTarget(this.myBuilder.getView().getCanvasComponent(), new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                Object draggable = DragAndDropNavigationGraphHelper.getDraggableObject(dtde.getTransferable());
                if (draggable instanceof PsiFile && DragAndDropNavigationGraphHelper.this.acceptDraggedFile((PsiFile)draggable)) {
                    dtde.acceptDrag(3);
                } else {
                    dtde.rejectDrag();
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
                Object draggable = DragAndDropNavigationGraphHelper.getDraggableObject(dtde.getTransferable());
                if (draggable instanceof PsiFile) {
                    DragAndDropNavigationGraphHelper.this.createDraggedNode((PsiFile)draggable, dtde.getLocation());
                } else {
                    dtde.rejectDrop();
                }
            }
        });
    }

    @Nullable
    private static Object getDraggableObject(Transferable transferable) {
        PsiElement[] psiElements = AbstractProjectViewPane.getTransferedPsiElements((Transferable)transferable);
        return psiElements != null && psiElements.length == 1 ? psiElements[0] : null;
    }

    protected boolean acceptDraggedFile(PsiFile psiFile) {
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)psiFile);
        XmlTag xmlTag = this.myFacesConfig.getXmlTag();
        return webFacet != null && xmlTag != null && webFacet.equals((Object)WebUtil.getWebFacet((PsiElement)xmlTag.getContainingFile())) && WebUtil.isInsideWebRoots((VirtualFile)psiFile.getVirtualFile(), (Project)psiFile.getProject()) && !this.isExistNode(psiFile);
    }

    private boolean isExistNode(PsiFile psiFile) {
        String relatedPath = JsfCommonUtils.getRelatedPath(psiFile);
        if (relatedPath != null) {
            for (Node node : this.myBuilder.getGraph().getNodeArray()) {
                String nodeObject = (String)this.myBuilder.getNodeObject(node);
                if (nodeObject == null || !relatedPath.equals(nodeObject)) continue;
                return true;
            }
        }
        return false;
    }

    protected void createDraggedNode(PsiFile psiFile, Point location) {
        String name = JsfCommonUtils.getRelatedPath(psiFile);
        NodeFactory.getInstance().createDraggedNode(this.myBuilder, (Object)name, name, location);
        this.myBuilder.updateGraph();
    }
}

