/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.utils;

import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.UserDefinedFacesConfigs;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.FacesDomModelManager;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FacesConfigUtils {
    private FacesConfigUtils() {
    }

    public static Set<XmlFile> getConfigurationFiles(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            FacesConfigUtils.$$$reportNull$$$0(0);
        }
        HashSet<XmlFile> result = new HashSet<XmlFile>();
        XmlFile config = FacesConfigUtils.getFacesConfigsFromWebInf(webFacet);
        if (config != null) {
            result.add(config);
        }
        result.addAll(FacesConfigUtils.getFacesConfigDefinedInWebXml(webFacet));
        result.addAll(FacesConfigUtils.getFacesConfigResources(webFacet.getModule()));
        result.addAll(FacesConfigUtils.getUserDefinedFacesConfigs(webFacet.getModule()));
        return result;
    }

    @Nullable
    public static XmlFile getFacesConfigsFromWebInf(WebFacet webFacet) {
        return FacesConfigUtils.getXmlFileByRelativePath(webFacet, "WEB-INF/faces-config.xml");
    }

    public static Collection<? extends XmlFile> getFacesConfigResources(Module module) {
        GlobalSearchScope moduleContentScope = GlobalSearchScope.moduleWithLibrariesScope((Module)module);
        Collection facesConfigs = DomService.getInstance().getDomFileCandidates(FacesConfig.class, moduleContentScope);
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        ArrayList<XmlFile> resourceFiles = new ArrayList<XmlFile>();
        for (VirtualFile facesConfig : facesConfigs) {
            PsiFile psiFile;
            if (!facesConfig.getPath().endsWith("META-INF/faces-config.xml") || !((psiFile = psiManager.findFile(facesConfig)) instanceof XmlFile)) continue;
            resourceFiles.add((XmlFile)psiFile);
        }
        return resourceFiles;
    }

    @NotNull
    public static List<XmlFile> getFacesConfigDefinedInWebXml(@NotNull WebFacet webFacet) {
        ParamValue jsfContextParameter;
        if (webFacet == null) {
            FacesConfigUtils.$$$reportNull$$$0(1);
        }
        if ((jsfContextParameter = JsfCommonUtils.findContextParameter(webFacet, "javax.faces.CONFIG_FILES")) == null) {
            List<XmlFile> list = Collections.emptyList();
            if (list == null) {
                FacesConfigUtils.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<XmlFile> result = new ArrayList<XmlFile>();
        String contextParam = (String)jsfContextParameter.getParamValue().getValue();
        if (StringUtil.isEmpty((String)contextParam)) {
            ArrayList<XmlFile> arrayList = result;
            if (arrayList == null) {
                FacesConfigUtils.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        StringTokenizer tok = new StringTokenizer(contextParam, ",");
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken().trim();
            XmlFile facesConfig = FacesConfigUtils.getXmlFileByRelativePath(webFacet, s);
            if (facesConfig == null) continue;
            result.add(facesConfig);
        }
        ArrayList<XmlFile> arrayList = result;
        if (arrayList == null) {
            FacesConfigUtils.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static List<XmlFile> getUserDefinedFacesConfigs(Module module) {
        UserDefinedFacesConfigs configs;
        ArrayList<XmlFile> xmlFiles = new ArrayList<XmlFile>();
        if (module != null && (configs = UserDefinedFacesConfigs.getInstance(module)) != null) {
            List<VirtualFile> virtualFiles = configs.getFiles();
            for (VirtualFile file : virtualFiles) {
                PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
                if (!(psiFile instanceof XmlFile)) continue;
                xmlFiles.add((XmlFile)psiFile);
            }
        }
        return xmlFiles;
    }

    @Nullable
    public static XmlFile getXmlFileByRelativePath(@NotNull WebFacet webFacet, String relativePath) {
        PsiFile psiFile;
        WebDirectoryElement element;
        if (webFacet == null) {
            FacesConfigUtils.$$$reportNull$$$0(5);
        }
        if ((element = WebDirectoryUtil.getWebDirectoryUtil((Project)webFacet.getModule().getProject()).findWebDirectoryElementByPath(relativePath, webFacet)) != null && (psiFile = element.getOriginalFile()) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            VirtualFile[] contentRoots;
            for (VirtualFile root : contentRoots = ModuleRootManager.getInstance((Module)webFacet.getModule()).getContentRoots()) {
                PsiFile psiFile2;
                VirtualFile virtualFile = root.findFileByRelativePath(FacesConfigUtils.formatPath(relativePath));
                if (virtualFile == null || !((psiFile2 = PsiManager.getInstance((Project)webFacet.getModule().getProject()).findFile(virtualFile)) instanceof XmlFile)) continue;
                return (XmlFile)psiFile2;
            }
        }
        return null;
    }

    private static String formatPath(String relativePath) {
        relativePath = relativePath.replace(File.separatorChar, '/').trim();
        relativePath = StringUtil.trimStart((String)relativePath, (String)"/");
        return relativePath;
    }

    public static boolean isFacesConfig(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            FacesConfigUtils.$$$reportNull$$$0(6);
        }
        if (file == null) {
            FacesConfigUtils.$$$reportNull$$$0(7);
        }
        if (!file.isValid()) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return psiFile instanceof XmlFile && FacesConfigUtils.isFacesConfig((XmlFile)psiFile);
    }

    public static boolean isFacesConfig(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            FacesConfigUtils.$$$reportNull$$$0(8);
        }
        return FacesDomModelManager.getInstance(xmlFile.getProject()).isFacesConfig(xmlFile);
    }

    public static boolean isFacesConfigResource(@NotNull XmlFile file) {
        if (file == null) {
            FacesConfigUtils.$$$reportNull$$$0(9);
        }
        return FacesConfigUtils.isFacesConfigResource(file.getVirtualFile());
    }

    public static boolean isFacesConfigResource(@Nullable VirtualFile file) {
        VirtualFile forJar;
        if (file != null && file.getName().equals("faces-config.xml") && file.getFileSystem() == JarFileSystem.getInstance() && (forJar = JarFileSystem.getInstance().getVirtualFileForJar(file)) != null) {
            VirtualFile f = JarFileSystem.getInstance().findFileByPath(forJar.getPath() + "!/");
            return f != null && file.equals(f.findFileByRelativePath("META-INF/faces-config.xml"));
        }
        return false;
    }

    @Nullable
    public static FacesConfig getFacesConfig(@NotNull XmlFile xmlFile) {
        DomFileElement fileElement;
        if (xmlFile == null) {
            FacesConfigUtils.$$$reportNull$$$0(10);
        }
        if ((fileElement = DomManager.getDomManager((Project)xmlFile.getProject()).getFileElement(xmlFile, FacesConfig.class)) == null) {
            return null;
        }
        return (FacesConfig)fileElement.getRootElement();
    }

    @Nullable
    public static FacesConfig getFacesConfig(Project project, VirtualFile file) {
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return psiFile instanceof XmlFile ? FacesConfigUtils.getFacesConfig((XmlFile)psiFile) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacet";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/utils/FacesConfigUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/utils/FacesConfigUtils";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacesConfigDefinedInWebXml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationFiles";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFacesConfigDefinedInWebXml";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getXmlFileByRelativePath";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFacesConfig";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isFacesConfigResource";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFacesConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

