/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.providers.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.constants.JsfAnnotationsConstants;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.WebFileReferenceHelper;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class WebFileReferenceHelperForPsiClasses
extends WebFileReferenceHelper {
    private static final Collection<String> RESOURCE_ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{JsfAnnotationsConstants.RESOURCE_DEPENDENCY.javax(), JsfAnnotationsConstants.RESOURCE_DEPENDENCY.jakarta(), JsfAnnotationsConstants.RESOURCE_DEPENDENCIES.javax(), JsfAnnotationsConstants.RESOURCE_DEPENDENCIES.jakarta()});

    public boolean isMine(Project project, @NotNull VirtualFile file) {
        Module module;
        if (file == null) {
            WebFileReferenceHelperForPsiClasses.$$$reportNull$$$0(0);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) == null) {
            return false;
        }
        if (FileTypeRegistry.getInstance().isFileOfType(file, (FileType)StdFileTypes.JAVA) && JsfCommonUtils.isJsfSupported(module)) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            boolean flowSupported = JsfCommonUtils.isFlowSupported(module);
            if (psiFile instanceof PsiJavaFile) {
                PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
                for (PsiClass psiClass : psiJavaFile.getClasses()) {
                    if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, RESOURCE_ANNOTATIONS, (int)0)) {
                        return true;
                    }
                    if (!flowSupported) continue;
                    for (PsiMethod method : psiClass.getMethods()) {
                        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)JsfAnnotationsConstants.FLOW_DEFINITION.fqn(module), (int)0)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static Collection<WebFacet> getWebFacets(Project project, VirtualFile file) {
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module != null) {
            return WebFacet.getInstances((Module)module);
        }
        return Collections.emptyList();
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            WebFileReferenceHelperForPsiClasses.$$$reportNull$$$0(1);
        }
        ArrayList<PsiFileSystemItem> items = new ArrayList<PsiFileSystemItem>();
        for (WebFacet webFacet : WebFileReferenceHelperForPsiClasses.getWebFacets(project, file)) {
            for (WebRoot webRoot : webFacet.getWebRoots(true)) {
                VirtualFile virtualFile = webRoot.getFile();
                if (virtualFile == null) continue;
                items.add((PsiFileSystemItem)PsiManager.getInstance((Project)project).findDirectory(virtualFile));
            }
        }
        ArrayList<PsiFileSystemItem> arrayList = items;
        if (arrayList == null) {
            WebFileReferenceHelperForPsiClasses.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/providers/jam/WebFileReferenceHelperForPsiClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/providers/jam/WebFileReferenceHelperForPsiClasses";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

