/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.providers;

import com.intellij.javaee.model.CommonParamValue;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.ServletMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.CustomServletReferenceProvider;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacesWebPathProvider
implements CustomServletReferenceProvider {
    private static final String FACES_DEFAULT_SERVLET_CLASSNAME = "javax.faces.webapp.FacesServlet";
    @NonNls
    private static final String FACES_DEFAULT_SUFFIX = ".jsp";
    @NonNls
    private static final String FACES_DEFAULT_SUFFIX_PARAM_NAME = "javax.faces.DEFAULT_SUFFIX";
    private static final char SEPARATOR = '/';

    private static PathReference createWebPath(final String path, final WebFacet webFacet) {
        return new PathReference(path, (Function)PathReference.NULL_ICON){

            public PsiElement resolve() {
                return WebDirectoryUtil.getWebDirectoryUtil((Project)webFacet.getModule().getProject()).findFileByPath(path, webFacet);
            }
        };
    }

    @Nullable
    public PathReference createWebPath(String path, @NotNull PsiElement element, ServletMappingInfo info) {
        WebFacet webFacet;
        if (element == null) {
            FacesWebPathProvider.$$$reportNull$$$0(0);
        }
        if ((webFacet = WebUtil.getWebFacet((PsiElement)element)) == null) {
            return null;
        }
        WebApp webApp = webFacet.getRoot();
        if (webApp != null) {
            String pageMapping = FacesWebPathProvider.getFacesPageExtentionMapping(webApp);
            if (pageMapping != null && path.endsWith(pageMapping)) {
                return FacesWebPathProvider.createWebPath(path.replaceFirst(pageMapping, FacesWebPathProvider.getFacesPagesSuffix(webApp)), webFacet);
            }
            String prefixMapping = FacesWebPathProvider.getFacesPagePrefixMapping(webApp);
            if (prefixMapping != null && path.startsWith(prefixMapping)) {
                return FacesWebPathProvider.createWebPath(path.substring(prefixMapping.length() - 1), webFacet);
            }
        }
        return null;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, @Nullable ServletMappingInfo info, boolean soft) {
        WebApp webApp;
        String value;
        if (psiElement == null) {
            FacesWebPathProvider.$$$reportNull$$$0(1);
        }
        if ((value = FacesWebPathProvider.getValue(psiElement)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                FacesWebPathProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String path = WebUtil.trimURL((String)value);
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)psiElement);
        if (path.length() > 0 && webFacet != null && (webApp = webFacet.getRoot()) != null) {
            String pageMapping = FacesWebPathProvider.getFacesPageExtentionMapping(webApp);
            SmartList list = new SmartList();
            if (StringUtil.isNotEmpty((String)pageMapping) && path.endsWith(pageMapping)) {
                String suffix = FacesWebPathProvider.getFacesPagesSuffix(webApp);
                if (StringUtil.isNotEmpty((String)suffix)) {
                    FacesWebPathProvider.createReferenceForServletMappedPage(path, pageMapping, suffix, psiElement, (List<PsiReference>)list, soft);
                }
            } else {
                String prefixMapping = FacesWebPathProvider.getFacesPagePrefixMapping(webApp);
                if (StringUtil.isNotEmpty((String)prefixMapping) && path.startsWith(prefixMapping)) {
                    FacesWebPathProvider.createReferencesForPrefixMappedPages(path, prefixMapping, psiElement, (List<PsiReference>)list, soft);
                }
            }
            PsiReference[] psiReferenceArray = (PsiReference[])list.toArray((Object[])PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                FacesWebPathProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            FacesWebPathProvider.$$$reportNull$$$0(4);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static void createReferencesForPrefixMappedPages(String path, String prefixMapping, PsiElement psiElement, List<PsiReference> references, final boolean soft) {
        String newPath = path.substring(prefixMapping.length() - 1);
        int offset = psiElement.getText().indexOf(prefixMapping) + prefixMapping.length() - 1;
        FileReferenceSet fileReferenceSet = new FileReferenceSet(newPath, psiElement, offset, null, true, false){

            protected boolean isSoft() {
                return soft;
            }
        };
        fileReferenceSet.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        Object[] fileReferences = fileReferenceSet.getAllReferences();
        ContainerUtil.addAll(references, (Object[])fileReferences);
    }

    private static void createReferenceForServletMappedPage(final String path, String pageMapping, final String suffix, final PsiElement psiElement, List<PsiReference> references, boolean soft) {
        TextRange range;
        final String newPath = path.replaceFirst(pageMapping, suffix);
        if (psiElement instanceof XmlElement && (range = FacesWebPathProvider.getSuffixTextRange(psiElement, pageMapping)) != null) {
            PsiReferenceBase<XmlElement> reference = new PsiReferenceBase<XmlElement>((XmlElement)psiElement, range, soft){

                public PsiElement resolve() {
                    return new FileReferenceSet(newPath, psiElement, this.getRangeInElement().getStartOffset(), null, true).resolve();
                }

                public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                    String newPath2;
                    if (element == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if ((newPath2 = FacesWebPathProvider.getNewPath(element, path)) != null) {
                        return FacesWebPathProvider.changeContent(this.getElement(), newPath2);
                    }
                    return element;
                }

                public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                    if (newElementName == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return super.handleElementRename(newElementName.endsWith(suffix) ? newElementName.substring(0, newElementName.length() - suffix.length()) : newElementName);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "newElementName";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/jsf/providers/FacesWebPathProvider$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "bindToElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleElementRename";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            references.add((PsiReference)reference);
        }
    }

    private static PsiElement changeContent(PsiElement element, String newPath) throws IncorrectOperationException {
        return ElementManipulators.handleContentChange((PsiElement)element, (String)newPath);
    }

    @Nullable
    private static String getNewPath(PsiElement element, String oldPath) {
        PsiElement psiFile;
        WebFacet webFacet;
        if (element instanceof PsiFile && (webFacet = WebUtil.getWebFacet((PsiElement)element)) != null && (psiFile = element.getParent()) instanceof PsiDirectory) {
            Object directoryName;
            VirtualFile virtualFile = ((PsiDirectory)psiFile).getVirtualFile();
            WebDirectoryElement directoryByFile = WebDirectoryUtil.getWebDirectoryUtil((Project)element.getProject()).findWebDirectoryByFile(virtualFile, webFacet);
            if (directoryByFile != null && (directoryName = directoryByFile.getName()) != null) {
                if (((String)directoryName).trim().length() > 0) {
                    directoryName = "/" + (String)directoryName;
                }
                String fileName = oldPath.lastIndexOf("/") > 0 ? oldPath.substring(oldPath.lastIndexOf("/")) : oldPath;
                return (String)directoryName + fileName;
            }
        }
        return null;
    }

    @Nullable
    private static TextRange getSuffixTextRange(PsiElement psiElement, String suffix) {
        String text = psiElement.getText();
        String value = FacesWebPathProvider.getValue(psiElement);
        assert (value != null);
        int i = text.indexOf(value);
        int startOffset = i + value.lastIndexOf(47) + 1;
        int endOffset = i + value.indexOf(suffix);
        return endOffset > startOffset ? new TextRange(startOffset, endOffset) : null;
    }

    @Nullable
    private static String getValue(PsiElement psiElement) {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)psiElement);
        if (manipulator != null) {
            return manipulator.getRangeInElement(psiElement).substring(psiElement.getText());
        }
        return null;
    }

    @NotNull
    private static String getFacesPagesSuffix(WebApp app) {
        for (CommonParamValue paramValue : app.getContextParams()) {
            String value;
            if (!FACES_DEFAULT_SUFFIX_PARAM_NAME.equals(paramValue.getParamName().getStringValue()) || (value = paramValue.getParamValue().getStringValue()) == null || value.trim().isEmpty()) continue;
            String string = value;
            if (string == null) {
                FacesWebPathProvider.$$$reportNull$$$0(5);
            }
            return string;
        }
        return FACES_DEFAULT_SUFFIX;
    }

    private static Set<GenericDomValue<String>> getFacesServletMappings(WebApp app) {
        HashSet<GenericDomValue<String>> mappings = new HashSet<GenericDomValue<String>>();
        List servlets = app.getServlets();
        for (Servlet servlet : servlets) {
            if (!FacesWebPathProvider.isFacesServlet(servlet)) continue;
            List list = app.getServletMappings();
            for (ServletMapping servletMapping : list) {
                String servletName = servletMapping.getServletName().getStringValue();
                if (servletName == null || !servletName.equals(servlet.getServletName().getStringValue())) continue;
                mappings.addAll(servletMapping.getUrlPatterns());
            }
        }
        return mappings;
    }

    @Nullable
    private static String getFacesPageExtentionMapping(WebApp webModuleProperties) {
        for (GenericDomValue<String> stringValue : FacesWebPathProvider.getFacesServletMappings(webModuleProperties)) {
            String mapping = stringValue.getStringValue();
            if (mapping == null || !mapping.startsWith("*")) continue;
            return mapping.substring(1);
        }
        return null;
    }

    @Nullable
    private static String getFacesPagePrefixMapping(WebApp webModuleProperties) {
        for (GenericDomValue<String> stringValue : FacesWebPathProvider.getFacesServletMappings(webModuleProperties)) {
            String mapping = stringValue.getStringValue();
            if (mapping == null || !mapping.endsWith("*")) continue;
            return mapping.substring(0, mapping.length() - 1);
        }
        return null;
    }

    private static boolean isFacesServlet(Servlet servlet) {
        return FACES_DEFAULT_SERVLET_CLASSNAME.equals(servlet.getServletClass().getStringValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/providers/FacesWebPathProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/providers/FacesWebPathProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacesPagesSuffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createWebPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

