/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.highlighting.jam;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.jsf.constants.JsfAnnotationsConstants;
import com.intellij.jsf.constants.JsfClassesConstants;
import com.intellij.jsf.highlighting.jam.BaseJsfJamInspection;
import com.intellij.jsf.resources.FacesInspectionsBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JsfJamExtendsClassInconsistencyInspection
extends BaseJsfJamInspection {
    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            JsfJamExtendsClassInconsistencyInspection.$$$reportNull$$$0(0);
        }
        JsfJamExtendsClassInconsistencyInspection.checkAnnotatedComponent(aClass, holder, module, JsfAnnotationsConstants.FACES_COMPONENT, JsfClassesConstants.FACES_COMPONENT_BASE_CLASS);
        JsfJamExtendsClassInconsistencyInspection.checkAnnotatedComponent(aClass, holder, module, JsfAnnotationsConstants.FACES_CONVERTER, JsfClassesConstants.FACES_CONVERTER_BASE_CLASS);
        JsfJamExtendsClassInconsistencyInspection.checkAnnotatedComponent(aClass, holder, module, JsfAnnotationsConstants.FACES_RENDERER, JsfClassesConstants.FACES_RENDERER_BASE_CLASS);
        JsfJamExtendsClassInconsistencyInspection.checkAnnotatedComponent(aClass, holder, module, JsfAnnotationsConstants.FACES_VALIDATOR, JsfClassesConstants.FACES_VALIDATOR_BASE_CLASS);
    }

    private static void checkAnnotatedComponent(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module, @NotNull JavaeeClass annotation, @NotNull JavaeeClass baseClassFQN) {
        PsiAnnotation psiAnnotation;
        if (aClass == null) {
            JsfJamExtendsClassInconsistencyInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            JsfJamExtendsClassInconsistencyInspection.$$$reportNull$$$0(2);
        }
        if (module == null) {
            JsfJamExtendsClassInconsistencyInspection.$$$reportNull$$$0(3);
        }
        if (annotation == null) {
            JsfJamExtendsClassInconsistencyInspection.$$$reportNull$$$0(4);
        }
        if (baseClassFQN == null) {
            JsfJamExtendsClassInconsistencyInspection.$$$reportNull$$$0(5);
        }
        if ((psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{annotation.fqn(module)})) != null && JsfJamExtendsClassInconsistencyInspection.isNonExtends(aClass, baseClassFQN.fqn(module), module)) {
            holder.registerProblem((PsiElement)psiAnnotation, FacesInspectionsBundle.message("JsfJamExtendsClassInconsistencyInspection.interface.must.be.implemented", baseClassFQN), new LocalQuickFix[0]);
        }
    }

    private static boolean isNonExtends(PsiClass psiClass, String baseClass, Module module) {
        PsiClass basePsiClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(baseClass, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        return basePsiClass != null && !psiClass.isInheritor(basePsiClass, true);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "JsfJamExtendsClassInconsistencyInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            JsfJamExtendsClassInconsistencyInspection.$$$reportNull$$$0(6);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassFQN";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/highlighting/jam/JsfJamExtendsClassInconsistencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/highlighting/jam/JsfJamExtendsClassInconsistencyInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotatedComponent";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

