/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.generation.ui;

import com.intellij.jsf.generation.EntityGenerateInfo;
import com.intellij.jsf.generation.FacesGenerationTemplateUtil;
import com.intellij.jsf.generation.GenerateSettings;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.JavaeeIcons;
import com.intellij.util.ListWithSelection;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class FacesGenerationTableView
extends TableView {
    private final EntityGenerateInfo myDefaultSettings;
    private final ArrayList<EntityGenerateInfo> myGenerateInfos;

    public FacesGenerationTableView(List<EntityGenerateInfo> entities, Module module, PersistencePackage persistenceUnit, PersistenceModelBrowser browser) {
        this.myDefaultSettings = new GenerateSettings(module, persistenceUnit, browser);
        this.myGenerateInfos = new ArrayList();
        this.myGenerateInfos.add(this.myDefaultSettings);
        this.myGenerateInfos.addAll(entities);
        this.setModelAndUpdateColumns(new ListTableModel(this.createColumnInfos(), this.myGenerateInfos, 0));
        this.setRowHeight(0, 40);
        TableColumn checkColumn = this.getColumnModel().getColumn(0);
        checkColumn.setMinWidth(15);
        checkColumn.setPreferredWidth(15);
        checkColumn.setMaxWidth(15);
        this.setTableHeader(null);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        ColumnInfo columnInfo = this.getListTableModel().getColumnInfos()[this.convertColumnIndexToModel(column)];
        TableCellEditor editor = columnInfo.getEditor(this.getListTableModel().getItems().get(this.convertColumnIndexToModel(row)));
        if (editor == null) {
            return super.getCellEditor(row, column);
        }
        return editor;
    }

    protected ColumnInfo[] createColumnInfos() {
        return new ColumnInfo[]{new EnabledEntityColumnInfo(), new EntityNameColumnInfo(), new TemplateColumnInfo(FacesBundle.message("edit", new Object[0]), new TemplateColumnHelper(){

            @Override
            public String getCurrentTemplate(EntityGenerateInfo entity) {
                return entity.getEditTemplate();
            }

            @Override
            public void setCurrentTemplate(EntityGenerateInfo entity, String value) {
                entity.setEditTemplate(value);
            }

            @Override
            boolean isCurrentTemplateDefault(EntityGenerateInfo entity) {
                return entity.getEditTemplate().equals(FacesGenerationTableView.this.myDefaultSettings.getEditTemplate());
            }

            @Override
            public ListWithSelection<String> getTemplates() {
                return new ListWithSelection(FacesGenerationTemplateUtil.getEditTemplates());
            }
        }), new TemplateColumnInfo(FacesBundle.message("view", new Object[0]), new TemplateColumnHelper(){

            @Override
            public String getCurrentTemplate(EntityGenerateInfo entity) {
                return entity.getViewTemplate();
            }

            @Override
            public void setCurrentTemplate(EntityGenerateInfo entity, String value) {
                entity.setViewTemplate(value);
            }

            @Override
            boolean isCurrentTemplateDefault(EntityGenerateInfo entity) {
                return entity.getViewTemplate().equals(FacesGenerationTableView.this.myDefaultSettings.getViewTemplate());
            }

            @Override
            public ListWithSelection<String> getTemplates() {
                return new ListWithSelection(FacesGenerationTemplateUtil.getViewTemplates());
            }
        }), new TemplateColumnInfo(FacesBundle.message("list", new Object[0]), new TemplateColumnHelper(){

            @Override
            public String getCurrentTemplate(EntityGenerateInfo entity) {
                return entity.getListTemplate();
            }

            @Override
            public void setCurrentTemplate(EntityGenerateInfo entity, String value) {
                entity.setListTemplate(value);
            }

            @Override
            boolean isCurrentTemplateDefault(EntityGenerateInfo entity) {
                return entity.getListTemplate().equals(FacesGenerationTableView.this.myDefaultSettings.getListTemplate());
            }

            @Override
            public ListWithSelection<String> getTemplates() {
                return new ListWithSelection(FacesGenerationTemplateUtil.getListTemplates());
            }
        }), new TemplateColumnInfo(FacesBundle.message("create", new Object[0]), new TemplateColumnHelper(){

            @Override
            public String getCurrentTemplate(EntityGenerateInfo entity) {
                return entity.getCreateTemplate();
            }

            @Override
            public void setCurrentTemplate(EntityGenerateInfo entity, String value) {
                entity.setCreateTemplate(value);
            }

            @Override
            boolean isCurrentTemplateDefault(EntityGenerateInfo entity) {
                return entity.getCreateTemplate().equals(FacesGenerationTableView.this.myDefaultSettings.getCreateTemplate());
            }

            @Override
            public ListWithSelection<String> getTemplates() {
                return new ListWithSelection(FacesGenerationTemplateUtil.getCretaeTemplates());
            }
        }), new TemplateColumnInfo(FacesBundle.message("model.managed.bean", new Object[0]), new TemplateColumnHelper(){

            @Override
            public String getCurrentTemplate(EntityGenerateInfo entity) {
                return entity.getManagedBeanTemplate();
            }

            @Override
            public void setCurrentTemplate(EntityGenerateInfo entity, String value) {
                entity.setManagedBeanTemplate(value);
            }

            @Override
            boolean isCurrentTemplateDefault(EntityGenerateInfo entity) {
                return entity.getManagedBeanTemplate().equals(FacesGenerationTableView.this.myDefaultSettings.getManagedBeanTemplate());
            }

            @Override
            public ListWithSelection<String> getTemplates() {
                return new ListWithSelection(FacesGenerationTemplateUtil.getManagedBeantTemplates());
            }
        })};
    }

    private static class EntityNameColumnInfo
    extends ColumnInfo<EntityGenerateInfo, String> {
        EntityNameColumnInfo() {
            super(FacesBundle.message("column.name.entity", new Object[0]));
        }

        public String valueOf(EntityGenerateInfo entity) {
            return entity.getName();
        }

        public TableCellRenderer getRenderer(final EntityGenerateInfo entity) {
            return new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (entity.isDefaultSettings()) {
                        JPanel wrapper = new JPanel(new BorderLayout());
                        @NlsSafe String name = table.getColumnName(column);
                        JLabel label = new JLabel(name, 0);
                        label.setFont(label.getFont().deriveFont(1));
                        wrapper.add(label);
                        return wrapper;
                    }
                    JPanel wrapper = new JPanel(new BorderLayout());
                    wrapper.setBackground(isSelected ? table.getSelectionBackground() : Color.WHITE);
                    JLabel jLabel = new JLabel(entity.getName(), JavaeeIcons.ENTITY_ICON, 0);
                    jLabel.setForeground(isSelected ? table.getSelectionForeground() : Color.BLACK);
                    wrapper.add((Component)jLabel, "West");
                    wrapper.setEnabled(entity.isEnabled());
                    return wrapper;
                }
            };
        }
    }

    private static class EnabledEntityColumnInfo
    extends ColumnInfo<EntityGenerateInfo, Boolean> {
        EnabledEntityColumnInfo() {
            super(" ");
        }

        public Boolean valueOf(EntityGenerateInfo entity) {
            return entity.isEnabled();
        }

        public void setValue(EntityGenerateInfo entity, Boolean aValue) {
            entity.setEnabled(aValue);
        }

        public boolean isCellEditable(EntityGenerateInfo entity) {
            return true;
        }

        public TableCellRenderer getRenderer(final EntityGenerateInfo entity) {
            return new BooleanTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (entity.isDefaultSettings()) {
                        return new JPanel();
                    }
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            };
        }

        public TableCellEditor getEditor(EntityGenerateInfo entity) {
            return new BooleanTableCellEditor(){

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    return super.getTableCellEditorComponent(table, value, isSelected, row, column);
                }
            };
        }
    }

    private static abstract class TemplateColumnHelper {
        private TemplateColumnHelper() {
        }

        abstract boolean isCurrentTemplateDefault(EntityGenerateInfo var1);

        public abstract ListWithSelection<String> getTemplates();

        public abstract String getCurrentTemplate(EntityGenerateInfo var1);

        public abstract void setCurrentTemplate(EntityGenerateInfo var1, String var2);
    }

    private class TemplateColumnInfo
    extends ColumnInfo<EntityGenerateInfo, String> {
        private final TemplateColumnHelper myHelper;

        TemplateColumnInfo(String name, TemplateColumnHelper helper) {
            super(name);
            this.myHelper = helper;
        }

        public String valueOf(EntityGenerateInfo entity) {
            return this.myHelper.getCurrentTemplate(entity);
        }

        public void setValue(EntityGenerateInfo entity, String value) {
            String oldTemplate = this.myHelper.getCurrentTemplate(entity);
            if (oldTemplate.equals(value)) {
                return;
            }
            this.myHelper.setCurrentTemplate(entity, value);
            if (entity.isDefaultSettings()) {
                for (EntityGenerateInfo generateInfo : FacesGenerationTableView.this.myGenerateInfos) {
                    if (generateInfo.isDefaultSettings() || !oldTemplate.equals(this.myHelper.getCurrentTemplate(generateInfo))) continue;
                    this.myHelper.setCurrentTemplate(generateInfo, value);
                }
                FacesGenerationTableView.this.getTableViewModel().fireTableDataChanged();
            }
            FacesGenerationTableView.this.setRowHeight(0, 40);
        }

        public boolean isCellEditable(EntityGenerateInfo entity) {
            return entity.isEnabled();
        }

        public TableCellRenderer getRenderer(final EntityGenerateInfo entity) {
            return new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    JComboBox<String> component = new JComboBox<String>();
                    component.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
                    component.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray(TemplateColumnInfo.this.myHelper.getTemplates())));
                    @NlsSafe String template = TemplateColumnInfo.this.myHelper.getCurrentTemplate(entity);
                    component.setSelectedItem(template);
                    if (entity.isDefaultSettings()) {
                        return TemplateColumnInfo.this.createHeaderComponent(component, table.getColumnName(column));
                    }
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                    component.setEnabled(entity.isEnabled());
                    component.setBorder(BorderFactory.createEmptyBorder());
                    component.setForeground(TemplateColumnInfo.this.myHelper.isCurrentTemplateDefault(entity) ? Color.LIGHT_GRAY : Color.BLACK);
                    panel.add(component, "Center");
                    return panel;
                }
            };
        }

        private Component createHeaderComponent(JComboBox component, @NlsSafe String columnName) {
            component.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JLabel label = new JLabel(columnName, 0);
            label.setFont(label.getFont().deriveFont(1));
            panel.add((Component)label, "Center");
            panel.add((Component)component, "South");
            return panel;
        }

        public TableCellEditor getEditor(EntityGenerateInfo item) {
            if (item.isDefaultSettings()) {
                return new MyHeaderComboboxCellEditor();
            }
            JComboBox<String> comboBox = new JComboBox<String>(ArrayUtilRt.toStringArray(this.myHelper.getTemplates()));
            comboBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            return new DefaultCellEditor(comboBox);
        }

        private class MyHeaderComboboxCellEditor
        extends DefaultCellEditor {
            MyHeaderComboboxCellEditor() {
                super(new JComboBox());
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                JComboBox comp = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
                comp.setModel(new DefaultComboBoxModel<String>(ArrayUtilRt.toStringArray(TemplateColumnInfo.this.myHelper.getTemplates())));
                Component headerComponent = TemplateColumnInfo.this.createHeaderComponent(comp, table.getColumnName(column));
                return headerComponent;
            }
        }
    }
}

