/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.generation;

import com.intellij.jsf.generation.AttributeGenerateInfo;
import com.intellij.jsf.generation.FacesGenerationTemplateUtil;
import com.intellij.jsf.generation.PkConverter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddedAttribute;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityGenerateInfo {
    private PersistentEntity myEntity;
    private final Module myModule;
    private final PersistenceModelBrowser myBrowser;
    private AttributeGenerateInfo[] myAttrs;
    private AttributeGenerateInfo[] myEmbeddedAttrs;
    private boolean myEnabled;
    private String myEditTemplate;
    private String myViewTemplate;
    private String myCreateTemplate;
    private String myListTemplate;
    private String myManagedBeanTemplate;
    private String myEditAction;
    private String myListAction;
    private String myViewAction;
    private String myCreateAction;
    private String myDeleteAction;
    private static final String UNKNOWN_PK = "Unknown_PK";
    private static final String UNKNOWN_PK_CLASS = "Unknown_PK_Class";

    public EntityGenerateInfo(PersistentEntity entity, Module module, PersistenceModelBrowser browser) {
        this.myEntity = entity;
        this.myModule = module;
        this.myBrowser = browser;
        this.setEnabled(true);
        this.setEditTemplate(FacesGenerationTemplateUtil.getDefaultEditTemplate());
        this.setCreateTemplate(FacesGenerationTemplateUtil.getDefaultCreateTemplate());
        this.setViewTemplate(FacesGenerationTemplateUtil.getDefaultViewTemplate());
        this.setListTemplate(FacesGenerationTemplateUtil.getDefaultListTemplate());
        this.setManagedBeanTemplate(FacesGenerationTemplateUtil.getDefaultManagedBeanTemplate());
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String value = (String)this.getEntity().getName().getValue();
        String string = value == null ? "" : value;
        if (string == null) {
            EntityGenerateInfo.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PersistentEntity getEntity() {
        return this.myEntity;
    }

    public PersistenceModelBrowser getBrowser() {
        return this.myBrowser;
    }

    public AttributeGenerateInfo[] getAttrs() {
        if (this.myAttrs == null) {
            ArrayList<AttributeGenerateInfo> attributes = new ArrayList<AttributeGenerateInfo>();
            for (PersistentAttribute attribute : this.getEntity().getObjectModelHelper().getAttributes()) {
                if (attribute instanceof PersistentEmbeddedAttribute) {
                    AttributeGenerateInfo parentEmbedded = new AttributeGenerateInfo(this, attribute);
                    parentEmbedded.setEmbedded(true);
                    for (PersistentAttribute attributeBase : this.myBrowser.queryAttributes((PersistentObject)this.myBrowser.queryTargetPersistentObjects((PersistentEmbeddedAttribute)attribute).findFirst())) {
                        attributes.add(new AttributeGenerateInfo(this, attributeBase, parentEmbedded, false));
                    }
                    continue;
                }
                attributes.add(new AttributeGenerateInfo(this, attribute));
            }
            this.myAttrs = attributes.toArray(new AttributeGenerateInfo[0]);
        }
        return this.myAttrs;
    }

    public AttributeGenerateInfo[] getEmbeddedAttrs() {
        ArrayList<AttributeGenerateInfo> attributes = new ArrayList<AttributeGenerateInfo>();
        for (PersistentAttribute attribute : this.getEntity().getObjectModelHelper().getAttributes()) {
            if (!(attribute instanceof PersistentEmbeddedAttribute)) continue;
            attributes.add(new AttributeGenerateInfo(this, attribute, null, true));
        }
        return attributes.toArray(new AttributeGenerateInfo[0]);
    }

    public void setEntity(PersistentEntity entity) {
        this.myEntity = entity;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public String getManagedBeanTemplate() {
        return this.myManagedBeanTemplate;
    }

    public void setManagedBeanTemplate(String managedBeanTemplate) {
        this.myManagedBeanTemplate = managedBeanTemplate;
    }

    public String getEditTemplate() {
        return this.myEditTemplate;
    }

    public void setEditTemplate(String editTemplate) {
        this.myEditTemplate = editTemplate;
    }

    public String getViewTemplate() {
        return this.myViewTemplate;
    }

    public void setViewTemplate(String viewTemplate) {
        this.myViewTemplate = viewTemplate;
    }

    public String getListTemplate() {
        return this.myListTemplate;
    }

    public void setListTemplate(String listTemplate) {
        this.myListTemplate = listTemplate;
    }

    public String getCreateTemplate() {
        return this.myCreateTemplate;
    }

    public void setCreateTemplate(String createTemplate) {
        this.myCreateTemplate = createTemplate;
    }

    public boolean isDefaultSettings() {
        return false;
    }

    public Module getModule() {
        return this.myModule;
    }

    public String getEditAction() {
        return "edit" + this.getName();
    }

    public String getListAction() {
        return StringUtil.decapitalize((String)(this.getName() + "List"));
    }

    public String getViewAction() {
        return "view" + this.getName();
    }

    public String getCreateAction() {
        return "create" + this.getName();
    }

    public String getDeleteAction() {
        return "delete" + this.getName();
    }

    public String getFieldName() {
        return "my" + this.getName();
    }

    @NotNull
    public String getManagedBeanName() {
        String string = FacesGenerationTemplateUtil.getManagedBeanName(this.getName());
        if (string == null) {
            EntityGenerateInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String getAllEntitiesMethod() {
        return "#{" + this.getManagedBeanName() + ".allEntities}";
    }

    public String getStartCreateMethod() {
        return "#{" + this.getManagedBeanName() + ".startCreate}";
    }

    public String getStartViewMethod() {
        return "#{" + this.getManagedBeanName() + ".startView}";
    }

    public String getStartEditMethod() {
        return "#{" + this.getManagedBeanName() + ".startEdit}";
    }

    public String getDeleteMethod() {
        return "#{" + this.getManagedBeanName() + ".delete}";
    }

    public String getSaveMethod() {
        return "#{" + this.getManagedBeanName() + ".save}";
    }

    public String getCreateMethod() {
        return "#{" + this.getManagedBeanName() + ".create}";
    }

    public String getPkClass() {
        String stringValue = this.getEntity().getIdClassValue().getStringValue();
        if (stringValue != null) {
            return stringValue;
        }
        for (PersistentAttribute attr : this.myBrowser.queryAttributes((PersistentObject)this.getEntity())) {
            if (!attr.getAttributeModelHelper().isIdAttribute()) continue;
            PsiType type = attr.getPsiType();
            return type == null ? UNKNOWN_PK_CLASS : type.getCanonicalText();
        }
        return UNKNOWN_PK_CLASS;
    }

    @Nullable
    public String getPkAttribute() {
        for (PersistentAttribute attr : this.myBrowser.queryAttributes((PersistentObject)this.getEntity())) {
            if (!attr.getAttributeModelHelper().isIdAttribute()) continue;
            return attr.getName().getStringValue();
        }
        return UNKNOWN_PK;
    }

    public String getEntityImport() {
        String name = ((PsiClass)this.getEntity().getClazz().getValue()).getQualifiedName();
        return name == null ? "" : "import " + name + ";";
    }

    public String getEntityQualifiedName() {
        String name = ((PsiClass)this.getEntity().getClazz().getValue()).getQualifiedName();
        return name == null ? this.getName() : name;
    }

    public String getPkInitializationCode() {
        return PkConverter.generateGetPKObject(this.getEntity(), this.myBrowser, "string", "id");
    }

    public String getPkToStringCode() {
        return PkConverter.generateGetPKString(this.getEntity(), this.myBrowser, "entity", "pk");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jsf/generation/EntityGenerateInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getManagedBeanName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

