/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite;

import com.intellij.jsf.composite.CompositeComponentAttributeDescriptor;
import com.intellij.jsf.composite.CompositeComponentDescriptor;
import com.intellij.jsf.composite.implementation.JsfImplicitXmlAttributeDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeUtil {
    private static final Key<CachedValue<Set<XmlAttributeDescriptor>>> ATTRIBUTES_CACHE = Key.create((String)"ATTRIBUTES_CACHE");
    private static final Key<CachedValue<Set<XmlTag>>> VALUE_HOLDERS_CACHE = Key.create((String)"VALUE_HOLDERS_CACHE");
    private static final Key<CachedValue<Set<XmlTag>>> ACTION_SOURCE_CACHE = Key.create((String)"ACTION_SOURCE_CACHE");
    private static final Key<CachedValue<Map<String, String>>> FACELET_TAGLIB_NAMESPACES_CACHE = Key.create((String)"FACELET_TAGLIB_NAMESPACES_CACHE");
    private static final Key<CachedValue<Set<XmlFile>>> PARENT_COMPONENTS_CACHE = Key.create((String)"PARENT_COMPONENTS_CACHE");
    private static final Key<Boolean> PARENT_SEARCH_CACHE = Key.create((String)"SOE_CACHE");
    public static String INTERFACE_TAG_NAME = "interface";
    public static String IMPLEMENTATION_TAG_NAME = "implementation";
    public static String ATTRIBUTE_TAG_NAME = "attribute";
    public static String VALUE_HOLDER_TAG_NAME = "valueHolder";
    public static String ACTION_SOURCE_TAG_NAME = "actionSource";
    public static String EDITABLE_VALUE_HOLDER_TAG_NAME = "editableValueHolder";
    public static final String COMPOSITE_LIBRARY_NAME_TAG_NAME = "composite-library-name";
    public static final String NAMESPACE_TAG_NAME = "namespace";
    public static String[] COMPOSITE_NAMESPACES = new String[]{"http://java.sun.com/jsf/composite", "http://xmlns.jcp.org/jsf/composite"};

    private CompositeUtil() {
    }

    @NotNull
    public static Set<XmlAttributeDescriptor> getCompositeComponentXmlAttributeDescriptors(@NotNull XmlFile ccFile) {
        CachedValue value;
        if (ccFile == null) {
            CompositeUtil.$$$reportNull$$$0(0);
        }
        if ((value = (CachedValue)ccFile.getUserData(ATTRIBUTES_CACHE)) == null) {
            value = CachedValuesManager.getManager((Project)ccFile.getProject()).createCachedValue(() -> {
                Set<XmlAttributeDescriptor> descriptors = CompositeUtil.collectXmlAttributeDescriptors(ccFile);
                return CachedValueProvider.Result.create(descriptors, (Object[])new Object[]{ccFile});
            }, false);
            ccFile.putUserData(ATTRIBUTES_CACHE, (Object)value);
        }
        Set set = (Set)value.getValue();
        if (set == null) {
            CompositeUtil.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public static Set<XmlTag> getValueHolderCompositeComponentInterfaceTags(@NotNull XmlFile ccFile) {
        CachedValue value;
        if (ccFile == null) {
            CompositeUtil.$$$reportNull$$$0(2);
        }
        if ((value = (CachedValue)ccFile.getUserData(VALUE_HOLDERS_CACHE)) == null) {
            value = CachedValuesManager.getManager((Project)ccFile.getProject()).createCachedValue(() -> {
                Set<XmlTag> descriptors = CompositeUtil.collectValueHolderTags(ccFile);
                return CachedValueProvider.Result.create(descriptors, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
            ccFile.putUserData(VALUE_HOLDERS_CACHE, (Object)value);
        }
        Set set = (Set)value.getValue();
        if (set == null) {
            CompositeUtil.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static Set<XmlTag> collectValueHolderTags(@NotNull XmlFile ccFile) {
        if (ccFile == null) {
            CompositeUtil.$$$reportNull$$$0(4);
        }
        HashSet<XmlTag> tags = new HashSet<XmlTag>();
        XmlTag interfaceTag = CompositeUtil.findInterfaceTag(ccFile);
        if (interfaceTag != null) {
            for (String compositeNamespace : COMPOSITE_NAMESPACES) {
                ContainerUtil.addAll(tags, (Object[])interfaceTag.findSubTags(VALUE_HOLDER_TAG_NAME, compositeNamespace));
                ContainerUtil.addAll(tags, (Object[])interfaceTag.findSubTags(EDITABLE_VALUE_HOLDER_TAG_NAME, compositeNamespace));
            }
        }
        return tags;
    }

    private static Set<XmlAttributeDescriptor> collectXmlAttributeDescriptors(@NotNull XmlFile ccFile) {
        XmlTag interfaceTag;
        if (ccFile == null) {
            CompositeUtil.$$$reportNull$$$0(5);
        }
        if ((interfaceTag = CompositeUtil.findInterfaceTag(ccFile)) != null) {
            HashSet<XmlAttributeDescriptor> descriptors = new HashSet<XmlAttributeDescriptor>();
            for (String compositeNamespace : COMPOSITE_NAMESPACES) {
                for (XmlTag xmlTag : interfaceTag.findSubTags(ATTRIBUTE_TAG_NAME, compositeNamespace)) {
                    descriptors.add(new CompositeComponentAttributeDescriptor(xmlTag));
                }
            }
            descriptors.add(new JsfImplicitXmlAttributeDescriptor((PsiElement)interfaceTag, "rendered"));
            return descriptors;
        }
        return Collections.emptySet();
    }

    public static boolean isInsideCompositeComponentTag(PsiElement psiElement) {
        return CompositeUtil.getParentCompositeComponentTag(psiElement) != null;
    }

    @Nullable
    public static XmlTag getParentCompositeComponentTag(PsiElement psiElement) {
        for (XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)psiElement, XmlTag.class); xmlTag != null; xmlTag = xmlTag.getParentTag()) {
            XmlElementDescriptor descriptor = xmlTag.getDescriptor();
            if (!(descriptor instanceof CompositeComponentDescriptor)) continue;
            return xmlTag;
        }
        return null;
    }

    @Nullable
    public static XmlTag getCompositeNamespaceTagByName(XmlFile file, String tagName) {
        XmlTag rootTag;
        XmlDocument document = file.getDocument();
        if (document != null && (rootTag = document.getRootTag()) != null) {
            return CompositeUtil.findTagByName(rootTag, tagName);
        }
        return null;
    }

    @Nullable
    private static XmlTag findTagByName(@NotNull XmlTag tag, String tagName) {
        if (tag == null) {
            CompositeUtil.$$$reportNull$$$0(6);
        }
        if (tag.getLocalName().equals(tagName)) {
            for (String compositeNamespace : COMPOSITE_NAMESPACES) {
                if (!compositeNamespace.equals(tag.getNamespace())) continue;
                return tag;
            }
        } else {
            for (XmlTag xmlTag : tag.getSubTags()) {
                XmlTag interfaceTag = CompositeUtil.findTagByName(xmlTag, tagName);
                if (interfaceTag == null) continue;
                return interfaceTag;
            }
        }
        return null;
    }

    public static Set<XmlTag> getActionSourceCompositeComponentInterfaceTags(XmlFile file) {
        CachedValue value = (CachedValue)file.getUserData(ACTION_SOURCE_CACHE);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> {
                Set<XmlTag> descriptors = CompositeUtil.collectActionSourceTags(file);
                return CachedValueProvider.Result.create(descriptors, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
            file.putUserData(ACTION_SOURCE_CACHE, (Object)value);
        }
        return (Set)value.getValue();
    }

    private static Set<XmlTag> collectActionSourceTags(@NotNull XmlFile file) {
        if (file == null) {
            CompositeUtil.$$$reportNull$$$0(7);
        }
        HashSet<XmlTag> tags = new HashSet<XmlTag>();
        XmlTag interfaceTag = CompositeUtil.findInterfaceTag(file);
        if (interfaceTag != null) {
            for (String compositeNamespace : COMPOSITE_NAMESPACES) {
                ContainerUtil.addAll(tags, (Object[])interfaceTag.findSubTags(ACTION_SOURCE_TAG_NAME, compositeNamespace));
            }
        }
        return tags;
    }

    @Nullable
    public static XmlTag findInterfaceTag(XmlFile file) {
        return CompositeUtil.getCompositeNamespaceTagByName(file, INTERFACE_TAG_NAME);
    }

    @Nullable
    public static XmlTag findImplementationTag(XmlFile file) {
        return CompositeUtil.getCompositeNamespaceTagByName(file, IMPLEMENTATION_TAG_NAME);
    }

    public static boolean isInsideImplementationTag(PsiElement element) {
        for (XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class); xmlTag != null; xmlTag = xmlTag.getParentTag()) {
            if (!CompositeUtil.isImplementationTag(xmlTag)) continue;
            return true;
        }
        return false;
    }

    private static boolean isImplementationTag(@Nullable XmlTag xmlTag) {
        return xmlTag != null && IMPLEMENTATION_TAG_NAME.equals(xmlTag.getLocalName()) && Arrays.asList(COMPOSITE_NAMESPACES).contains(xmlTag.getNamespace());
    }

    @NotNull
    public static Set<XmlFile> getParentComponents(@NotNull XmlFile xmlFile) {
        Boolean value;
        PsiFile ccFile;
        if (xmlFile == null) {
            CompositeUtil.$$$reportNull$$$0(8);
        }
        if ((ccFile = xmlFile.getOriginalFile()) instanceof XmlFile && ((value = (Boolean)ccFile.getUserData(PARENT_SEARCH_CACHE)) == null || !value.booleanValue())) {
            CachedValue cachedValue = (CachedValue)ccFile.getUserData(PARENT_COMPONENTS_CACHE);
            if (cachedValue == null) {
                cachedValue = CachedValuesManager.getManager((Project)ccFile.getProject()).createCachedValue(() -> {
                    HashSet<XmlFile> files = new HashSet<XmlFile>();
                    ccFile.putUserData(PARENT_SEARCH_CACHE, (Object)true);
                    Set<XmlFile> parentComponents = CompositeUtil.getParentComponents((XmlFile)ccFile, files);
                    ccFile.putUserData(PARENT_SEARCH_CACHE, (Object)false);
                    return CachedValueProvider.Result.create(parentComponents, (Object[])new Object[]{ccFile, ArrayUtil.toObjectArray(files)});
                }, false);
                ccFile.putUserData(PARENT_COMPONENTS_CACHE, (Object)cachedValue);
            }
            Set set = (Set)cachedValue.getValue();
            if (set == null) {
                CompositeUtil.$$$reportNull$$$0(9);
            }
            return set;
        }
        Set<XmlFile> set = Collections.emptySet();
        if (set == null) {
            CompositeUtil.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    private static Set<XmlFile> getParentComponents(@NotNull XmlFile file, Set<XmlFile> files) {
        if (file == null) {
            CompositeUtil.$$$reportNull$$$0(11);
        }
        ReferencesSearch.search((PsiElement)file).forEach(psiReference -> {
            PsiFile containingFile;
            PsiElement element = psiReference.getElement();
            if (CompositeUtil.isInsideImplementationTag(element) && file != (containingFile = element.getContainingFile().getOriginalFile()) && containingFile instanceof XmlFile) {
                files.add((XmlFile)containingFile);
            }
            return true;
        });
        Set<XmlFile> set = files;
        if (set == null) {
            CompositeUtil.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    public static Map<String, String> getFaceletTaglibNamespacesMap(@NotNull Module module) {
        CachedValue value;
        if (module == null) {
            CompositeUtil.$$$reportNull$$$0(13);
        }
        if ((value = (CachedValue)module.getUserData(FACELET_TAGLIB_NAMESPACES_CACHE)) == null) {
            value = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> {
                Map<String, String> descriptors = CompositeUtil.collectFaceletTaglibNamespaces(module);
                return CachedValueProvider.Result.create(descriptors, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }, false);
            module.putUserData(FACELET_TAGLIB_NAMESPACES_CACHE, (Object)value);
        }
        Map map = (Map)value.getValue();
        if (map == null) {
            CompositeUtil.$$$reportNull$$$0(14);
        }
        return map;
    }

    @NotNull
    private static Map<String, String> collectFaceletTaglibNamespaces(@NotNull Module module) {
        if (module == null) {
            CompositeUtil.$$$reportNull$$$0(15);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Collection files = JspManager.getInstance((Project)module.getProject()).getPossibleTldFiles(module);
        for (XmlFile file : files) {
            XmlTag rootTag;
            XmlDocument document = file.getDocument();
            if (document == null || (rootTag = document.getRootTag()) == null || !rootTag.isValid()) continue;
            String namespace = rootTag.getSubTagText(NAMESPACE_TAG_NAME);
            String compositeLibraryName = rootTag.getSubTagText(COMPOSITE_LIBRARY_NAME_TAG_NAME);
            if (StringUtil.isEmptyOrSpaces((String)namespace) || StringUtil.isEmptyOrSpaces((String)compositeLibraryName)) continue;
            map.put(namespace, compositeLibraryName);
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            CompositeUtil.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    public static boolean hasCompositeNsDefinedIn(@NotNull XmlFile containingFile) {
        XmlTag rootTag;
        XmlDocument document;
        if (containingFile == null) {
            CompositeUtil.$$$reportNull$$$0(17);
        }
        if ((document = containingFile.getDocument()) != null && (rootTag = document.getRootTag()) != null) {
            for (String compositeNS : COMPOSITE_NAMESPACES) {
                String prefix = rootTag.getPrefixByNamespace(compositeNS);
                if (prefix == null) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ccFile";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/composite/CompositeUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/composite/CompositeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositeComponentXmlAttributeDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueHolderCompositeComponentInterfaceTags";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentComponents";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFaceletTaglibNamespacesMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFaceletTaglibNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeComponentXmlAttributeDescriptors";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getValueHolderCompositeComponentInterfaceTags";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectValueHolderTags";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectXmlAttributeDescriptors";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTagByName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectActionSourceTags";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getParentComponents";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFaceletTaglibNamespacesMap";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectFaceletTaglibNamespaces";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasCompositeNsDefinedIn";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

