/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite;

import com.intellij.jsf.composite.CompositeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;

public class CompositeNamespaceFilter
implements ElementFilter {
    public boolean isClassAcceptable(Class hintClass) {
        return ReflectionUtil.isAssignable(XmlTag.class, (Class)hintClass) || ReflectionUtil.isAssignable(XmlDocument.class, (Class)hintClass);
    }

    public boolean isAcceptable(Object element, PsiElement context) {
        if (element instanceof XmlTag) {
            String attributeValue = ((XmlTag)element).getAttributeValue("targetNamespace");
            if (attributeValue != null) {
                for (String compositeNamespace : CompositeUtil.COMPOSITE_NAMESPACES) {
                    if (!attributeValue.startsWith(compositeNamespace + "/")) continue;
                    return true;
                }
            }
        } else if (element instanceof XmlDocument) {
            return this.isAcceptable(((XmlDocument)element).getRootTag(), context);
        }
        return false;
    }
}

