/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSType {
    public static final LocalTypeKey SUBSTITUTE = JSType.createLocalTypeKey("substitute.simple");
    public static final LocalTypeKey SUBSTITUTE_COMPLETE = JSType.createLocalTypeKey("substitute.with.complete");
    public static final String COMMENT_DELIMITERS = "|/";

    public static boolean isEquivalentToSafe(@Nullable JSType lType, @Nullable JSType rType, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        return lType == rType || lType != null && lType.isEquivalentTo(rType, processingContext, allowResolve);
    }

    @NotNull
    public static LocalTypeKey createLocalTypeKey(@NotNull String name) {
        if (name == null) {
            JSType.$$$reportNull$$$0(0);
        }
        return new LocalTypeKey(name);
    }

    @Deprecated
    default public int resolvedHashCode() {
        return this.hashCode();
    }

    @NotNull
    public JSResolvedTypeId getResolvedTypeId();

    @NotNull
    @NlsSafe
    public String getTypeText(@NotNull TypeTextFormat var1);

    @NotNull
    default public String getTypeText() {
        String string = this.getTypeText(TypeTextFormat.SIMPLE);
        if (string == null) {
            JSType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    default public String getResolvedTypeText() {
        String string = this.getTypeText(TypeTextFormat.RESOLVED);
        if (string == null) {
            JSType.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    default public JSType withNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSType.$$$reportNull$$$0(3);
        }
        JSType jSType = this;
        if (jSType == null) {
            JSType.$$$reportNull$$$0(4);
        }
        return jSType;
    }

    default public void buildTypeText(@NotNull TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSType.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            JSType.$$$reportNull$$$0(6);
        }
        builder.append(this.getTypeText(format));
    }

    public void accept(@NotNull JSRecursiveTypeVisitor var1);

    public void acceptChildren(@NotNull JSRecursiveTypeVisitor var1);

    @Deprecated
    @Nullable
    default public JSClass resolveClass() {
        return null;
    }

    @NotNull
    public JSTypeSource getSource();

    public boolean isDirectlyAssignableType(@Nullable JSType var1, @Nullable ProcessingContext var2);

    public boolean isEquivalentTo(@Nullable JSType var1, @Nullable ProcessingContext var2, boolean var3);

    public boolean isEquivalentTo(@Nullable JSType var1, @Nullable ProcessingContext var2);

    @NotNull
    public JSType transformTypeHierarchy(@NotNull Function<JSType, JSType> var1);

    @NotNull
    public JSType transformTypeHierarchy(@NotNull JSRecursiveTypeTransformer var1);

    @NotNull
    public JSType copyWithStrict(boolean var1);

    @NotNull
    public JSType substitute();

    @Nullable
    default public JSType substitute(@NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            JSType.$$$reportNull$$$0(7);
        }
        return this;
    }

    @NotNull
    public JSRecordType asRecordType();

    default public boolean isTypeScript() {
        return this.getSource().isTypeScript();
    }

    default public boolean isEcma() {
        return this.getSource().isEcma();
    }

    default public boolean isJavaScript() {
        return this.getSource().isJavaScript();
    }

    default public boolean isSourceStrict() {
        return this.getSource().isStrict();
    }

    @NotNull
    default public Stream<JSType> getFunctionTypes(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        if (processingContext == null) {
            JSType.$$$reportNull$$$0(8);
        }
        Stream<JSType> stream = Stream.empty();
        if (stream == null) {
            JSType.$$$reportNull$$$0(9);
        }
        return stream;
    }

    @Nullable
    default public PsiElement getSourceElement() {
        JSTypeSource source = this.getSource();
        PsiElement element = source.getSourceElement();
        return element == null || !element.isValid() ? null : element;
    }

    @NotNull
    default public JSType getLocalCachedType(@NotNull Supplier<? extends JSType> factory, @NotNull LocalTypeKey cacheKey) {
        JSType type;
        if (factory == null) {
            JSType.$$$reportNull$$$0(10);
        }
        if (cacheKey == null) {
            JSType.$$$reportNull$$$0(11);
        }
        JSType jSType = (type = factory.get()) == null ? this : type;
        if (jSType == null) {
            JSType.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    default public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSType.$$$reportNull$$$0(13);
        }
    }

    default public <T> void setResolvedFlag(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            JSType.$$$reportNull$$$0(14);
        }
    }

    @Nullable
    default public <T> T getResolvedFlag(@NotNull Key<T> key) {
        if (key == null) {
            JSType.$$$reportNull$$$0(15);
        }
        return null;
    }

    @NotNull
    default public String getDefaultValue() {
        return "undefined";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheKey";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withNewSource";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalCachedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLocalTypeKey";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withNewSource";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLocalCachedType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setResolvedFlag";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedFlag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TypeTextFormat {
        SIMPLE,
        RESOLVED,
        PRESENTABLE,
        CODE;

    }

    public static final class LocalTypeKey
    extends Key<JSType> {
        public LocalTypeKey(@NotNull String name) {
            if (name == null) {
                LocalTypeKey.$$$reportNull$$$0(0);
            }
            super(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/psi/JSType$LocalTypeKey", "<init>"));
        }
    }

    public static interface CompositeStructure {
    }
}

