/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.util.NullableLazyValue;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialectOptionHolder {
    public static final DialectOptionHolder ECMA_4 = new DialectOptionHolder("ECMA_4");
    public static final DialectOptionHolder ECMA_6 = new DialectOptionHolder("JSX");
    public static final DialectOptionHolder JS_WITHOUT_JSX = new DialectOptionHolder("ECMA_6");
    public static final DialectOptionHolder JS_1_5 = new DialectOptionHolder("JS_1_5");
    public static final DialectOptionHolder JS_1_8 = new DialectOptionHolder("JS_1_8");
    @Deprecated
    public static final DialectOptionHolder JSX = ECMA_6;
    public static final DialectOptionHolder TS = new DialectOptionHolder("TS", true);
    public static final DialectOptionHolder TSX = new DialectOptionHolder("TSX", true);
    public static final DialectOptionHolder NASHORN = new DialectOptionHolder("NASHORN");
    public static final DialectOptionHolder FLOW = new DialectOptionHolder("FLOW");
    public static final DialectOptionHolder OTHER = new DialectOptionHolder("OTHER");
    public final boolean isECMA4;
    private final boolean isJavaScript1_6_OrHigher;
    private final boolean hasE4X;
    private final boolean isJavaScript1_7_OrHigher;
    private final boolean isJavaScript1_8_OrHigher;
    public final boolean isECMA6;
    public final boolean isTypeScript;
    public final boolean isNashorn;
    public final boolean isFlow;
    public final boolean isTSX;
    @NonNls
    private final String myName;
    private final Set<JSLanguageFeature> myFeatures;
    private final NullableLazyValue<Constructor<?>> myLexerClass;

    public DialectOptionHolder(@NotNull @NonNls String name) {
        if (name == null) {
            DialectOptionHolder.$$$reportNull$$$0(0);
        }
        this(name, false);
    }

    public DialectOptionHolder(@NotNull @NonNls String name, boolean isTypeScript) {
        if (name == null) {
            DialectOptionHolder.$$$reportNull$$$0(1);
        }
        this(name, isTypeScript, false);
    }

    public DialectOptionHolder(@NotNull @NonNls String name, boolean isTypeScript, boolean isECMA6) {
        if (name == null) {
            DialectOptionHolder.$$$reportNull$$$0(2);
        }
        this.isECMA4 = "ECMA_4".equals(name);
        this.isFlow = "FLOW".equals(name);
        this.isTSX = "TSX".equals(name);
        this.isJavaScript1_8_OrHigher = "JS_1_8".equals(name);
        this.isJavaScript1_7_OrHigher = this.isJavaScript1_8_OrHigher || "JS_1_7".equals(name);
        this.isJavaScript1_6_OrHigher = this.isJavaScript1_7_OrHigher || "JS_1_6".equals(name);
        this.hasE4X = this.isJavaScript1_6_OrHigher || "E4X".equals(name) || "JSX".equals(name) || this.isFlow || this.isTSX;
        this.isNashorn = "NASHORN".equals(name);
        this.isECMA6 = isECMA6 || "ECMA_6".equals(name) || "JSX".equals(name) || this.isFlow || this.isNashorn;
        this.isTypeScript = isTypeScript;
        this.myName = name;
        this.myFeatures = this.defineFeatures();
        this.myLexerClass = new NullableLazyValue<Constructor<?>>(){

            @Nullable
            protected Constructor<?> compute() {
                return DialectOptionHolder.this.findLexerClass();
            }
        };
    }

    @Nullable
    protected Constructor<?> findLexerClass() {
        try {
            return Class.forName("com.intellij.lang.javascript._" + this.myName + "Lexer").getConstructor(Reader.class, Boolean.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasJSSyntax() {
        return true;
    }

    public boolean supportsTypeGuard() {
        return this.hasJSSyntax() && !this.isECMA4;
    }

    @NotNull
    protected @NotNull Set<@NotNull JSLanguageFeature> defineFeatures() {
        EnumSet<JSLanguageFeature> features = EnumSet.noneOf(JSLanguageFeature.class);
        if (this.hasE4X || this.isJavaScript1_6_OrHigher || this.isECMA4) {
            features.add(JSLanguageFeature.E4X);
        }
        if (this.isJavaScript1_6_OrHigher || this.isECMA4 || this.isNashorn) {
            features.add(JSLanguageFeature.FOR_EACH);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.FOR_OF);
        }
        if (this.isJavaScript1_7_OrHigher || this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.LET_DEFINITIONS);
            features.add(JSLanguageFeature.CONST_DEFINITIONS);
        }
        if (this.isJavaScript1_7_OrHigher || this.isECMA6 && !this.isNashorn || this.isTypeScript) {
            features.add(JSLanguageFeature.YIELD_GENERATORS);
        }
        if (this.isJavaScript1_7_OrHigher || this.isECMA6 && !this.isNashorn) {
            features.add(JSLanguageFeature.ARRAY_COMPREHENSIONS);
        }
        if (this.isJavaScript1_7_OrHigher) {
            features.add(JSLanguageFeature.LET_SCOPE);
        }
        if (this.isJavaScript1_7_OrHigher || this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.DESTRUCTURING_ASSIGNMENT);
        }
        if (this.isJavaScript1_7_OrHigher || this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.DESTRUCTURING_PARAMETERS);
        }
        if (this.isJavaScript1_8_OrHigher || this.isNashorn) {
            features.add(JSLanguageFeature.EXPRESSION_CLOSURES);
        }
        if (this.isJavaScript1_8_OrHigher) {
            features.add(JSLanguageFeature.GENERATOR_EXPRESSIONS);
        }
        if (this.isJavaScript1_8_OrHigher) {
            features.add(JSLanguageFeature.REFERENCE_NAMESPACE);
        }
        if (this.isJavaScript1_8_OrHigher) {
            features.add(JSLanguageFeature.ALWAYS_GENERATOR_CONTEXT);
        }
        features.add(JSLanguageFeature.ACCESSORS);
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.ARROW_FUNCTIONS);
        }
        if (this.isECMA4 || this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.REST_PARAMETERS);
        }
        if (this.isTypeScript || this.isFlow) {
            features.add(JSLanguageFeature.GENERICS);
        }
        if (this.isECMA6 && !this.isNashorn || this.isTypeScript) {
            features.add(JSLanguageFeature.IMPORT_DECLARATIONS);
        }
        if (this.isECMA6 && !this.isNashorn || this.isTypeScript) {
            features.add(JSLanguageFeature.EXPORT_DECLARATIONS);
        }
        if (this.isECMA4 || this.isTypeScript || this.isECMA6 && !this.isNashorn) {
            features.add(JSLanguageFeature.CLASSES);
        }
        if (this.isECMA6 && !this.isNashorn || this.isTypeScript) {
            features.add(JSLanguageFeature.ANNOTATIONS);
            features.add(JSLanguageFeature.ASYNC_AWAIT);
            features.add(JSLanguageFeature.SHORTHAND_PROPERTY_NAMES);
            features.add(JSLanguageFeature.COMPUTED_PROPERTY_NAMES);
            features.add(JSLanguageFeature.METHOD_DEFINITION_SHORTHANDS);
        }
        if (this.isECMA6 || this.isTypeScript) {
            features.add(JSLanguageFeature.BINARY_AND_OCTAL_LITERALS);
            features.add(JSLanguageFeature.STRING_TEMPLATES);
        }
        if (this.isECMA6 && !this.isNashorn) {
            features.add(JSLanguageFeature.BIND_EXPRESSIONS);
            features.add(JSLanguageFeature.UNICODE_ESCAPES_WITH_BRACES);
        }
        if (this.isFlow || this.isTypeScript || this.isECMA4) {
            features.add(JSLanguageFeature.TYPES);
            features.add(JSLanguageFeature.INTERFACES);
        }
        if (this.isFlow || this.isTypeScript || this.isECMA6 && !this.isNashorn) {
            features.add(JSLanguageFeature.TRAILING_FUNCTION_COMMA);
            features.add(JSLanguageFeature.OPTIONAL_CATCH_BINDING);
        }
        if (this.isECMA6 && !this.isNashorn) {
            if (!this.isFlow) {
                features.add(JSLanguageFeature.BIG_INT);
                features.add(JSLanguageFeature.OPTIONAL_CHAINING_OPERATOR);
            }
            features.add(JSLanguageFeature.PRIVATE_SHARP_SYNTAX);
            features.add(JSLanguageFeature.THROW_EXPRESSIONS);
            features.add(JSLanguageFeature.DECORATOR_DECLARATIONS);
            features.add(JSLanguageFeature.PIPE_EXPRESSIONS);
        }
        if (this.isTypeScript) {
            features.add(JSLanguageFeature.BIG_INT);
            features.add(JSLanguageFeature.PRIVATE_SHARP_SYNTAX);
        }
        if (this.isTypeScript || this.isECMA4) {
            features.add(JSLanguageFeature.VISIBILITY_MODIFIERS);
        }
        if (this.isTypeScript || this.isECMA4 || this.isECMA6) {
            features.add(JSLanguageFeature.PARAMETER_INITIALIZERS);
        }
        Set<JSLanguageFeature> set = Collections.unmodifiableSet(features);
        if (set == null) {
            DialectOptionHolder.$$$reportNull$$$0(3);
        }
        return set;
    }

    public boolean hasFeature(@NotNull JSLanguageFeature feature) {
        if (feature == null) {
            DialectOptionHolder.$$$reportNull$$$0(4);
        }
        return this.myFeatures.contains((Object)feature);
    }

    public boolean isJSX() {
        return this.isTSX || this.isFlow || "JSX".equals(this.myName);
    }

    public boolean isJavaScript() {
        return this != ECMA_4 && !this.isTypeScript && this != OTHER;
    }

    public boolean hasE4XStandard() {
        return this.isECMA4 || this.isJavaScript1_6_OrHigher;
    }

    @NotNull
    public FlexLexer createLexer(boolean highlightMode) {
        FlexLexer flexLexer;
        try {
            Constructor constructor = (Constructor)this.myLexerClass.getValue();
            assert (constructor != null) : "No lexer constructor for " + this.myName;
            flexLexer = (FlexLexer)constructor.newInstance(null, highlightMode);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (flexLexer == null) {
            DialectOptionHolder.$$$reportNull$$$0(5);
        }
        return flexLexer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/DialectOptionHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/DialectOptionHolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "defineFeatures";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasFeature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

