/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.gradle;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.inspections.gradle.GradleHeuristicHelper;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitor;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleInspectionVisitorKt;
import org.jetbrains.kotlin.idea.inspections.gradle.KotlinGradleModelFacadeKt;
import org.jetbrains.kotlin.idea.inspections.gradle.NodeWithData;
import org.jetbrains.kotlin.idea.platform.IdePlatformKindToolingKt;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0014\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection;", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspection;", "()V", "buildErrorString", "", "args", "", "", "([Ljava/lang/Object;)Ljava/lang/String;", "buildVisitor", "Lorg/jetbrains/plugins/groovy/codeInspection/BaseInspectionVisitor;", "Companion", "MyVisitor", "VersionFinder", "kotlin.gradle.gradle-idea"})
public final class DifferentStdlibGradleVersionInspection
extends BaseInspection {
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        return new MyVisitor("org.jetbrains.kotlin", IdePlatformKindToolingKt.getTooling((IdePlatformKind)((IdePlatformKind)JvmIdePlatformKind.INSTANCE)).getMavenLibraryIds());
    }

    @NotNull
    protected String buildErrorString(Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return KotlinIdeaGradleBundle.message("error.text.different.kotlin.library.version", args[0], args[1]);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH$J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection$VersionFinder;", "Lorg/jetbrains/kotlin/idea/inspections/gradle/KotlinGradleInspectionVisitor;", "groupId", "", "libraryIds", "", "(Ljava/lang/String;Ljava/util/List;)V", "onFound", "", "stdlibVersion", "stdlibStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "visitClosure", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "kotlin.gradle.gradle-idea"})
    private static abstract class VersionFinder
    extends KotlinGradleInspectionVisitor {
        private final String groupId;
        private final List<String> libraryIds;

        protected abstract void onFound(@NotNull String var1, @NotNull GrCallExpression var2);

        public void visitClosure(@NotNull GrClosableBlock closure) {
            Intrinsics.checkNotNullParameter((Object)closure, (String)"closure");
            super.visitClosure(closure);
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)closure;
            boolean $i$f$getStrictParentOfType = false;
            GrMethodCall grMethodCall = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, GrMethodCall.class, (boolean)true);
            if (grMethodCall == null) {
                return;
            }
            GrMethodCall dependenciesCall = grMethodCall;
            GrExpression grExpression = dependenciesCall.getInvokedExpression();
            Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"dependenciesCall.invokedExpression");
            if (Intrinsics.areEqual((Object)grExpression.getText(), (Object)"dependencies") ^ true) {
                return;
            }
            if (!(dependenciesCall.getParent() instanceof PsiFile)) {
                return;
            }
            GrCallExpression grCallExpression = Companion.findLibraryStatement(closure, "org.jetbrains.kotlin", this.libraryIds);
            if (grCallExpression == null) {
                return;
            }
            GrCallExpression stdlibStatement = grCallExpression;
            PsiFile psiFile = closure.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"closure.containingFile");
            String string = Companion.getResolvedLibVersion(psiFile, this.groupId, this.libraryIds);
            if (string == null) {
                return;
            }
            String stdlibVersion = string;
            this.onFound(stdlibVersion, stdlibStatement);
        }

        public VersionFinder(@NotNull String groupId, @NotNull List<String> libraryIds) {
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter(libraryIds, (String)"libraryIds");
            this.groupId = groupId;
            this.libraryIds = libraryIds;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection$MyVisitor;", "Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection$VersionFinder;", "groupId", "", "libraryIds", "", "(Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection;Ljava/lang/String;Ljava/util/List;)V", "onFound", "", "stdlibVersion", "stdlibStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "kotlin.gradle.gradle-idea"})
    private final class MyVisitor
    extends VersionFinder {
        @Override
        protected void onFound(@NotNull String stdlibVersion, @NotNull GrCallExpression stdlibStatement) {
            Intrinsics.checkNotNullParameter((Object)stdlibVersion, (String)"stdlibVersion");
            Intrinsics.checkNotNullParameter((Object)stdlibStatement, (String)"stdlibStatement");
            PsiFile psiFile = stdlibStatement.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"stdlibStatement.containingFile");
            String gradlePluginVersion = KotlinGradleInspectionVisitorKt.getResolvedKotlinGradleVersion(psiFile);
            if (Intrinsics.areEqual((Object)stdlibVersion, (Object)gradlePluginVersion) ^ true) {
                this.registerError((PsiElement)stdlibStatement, new Object[]{gradlePluginVersion, stdlibVersion});
            }
        }

        public MyVisitor(@NotNull String groupId, List<String> libraryIds) {
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter(libraryIds, (String)"libraryIds");
            super(groupId, libraryIds);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J&\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/DifferentStdlibGradleVersionInspection$Companion;", "", "()V", "findLibraryStatement", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "libraryGroup", "", "libraryIds", "", "getResolvedLibVersion", "file", "Lcom/intellij/psi/PsiFile;", "groupId", "kotlin.gradle.gradle-idea"})
    public static final class Companion {
        /*
         * Unable to fully structure code
         */
        private final GrCallExpression findLibraryStatement(GrClosableBlock closure, @NonNls String libraryGroup, List<String> libraryIds) {
            block7: {
                $this$firstOrNull$iv = GradleHeuristicHelper.INSTANCE.findStatementWithPrefixes(closure, GradleHeuristicHelper.INSTANCE.getPRODUCTION_DEPENDENCY_STATEMENTS());
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    block6: {
                        block8: {
                            statement = (GrCallExpression)element$iv;
                            $i$a$-firstOrNull-DifferentStdlibGradleVersionInspection$Companion$findLibraryStatement$1 = false;
                            $this$any$iv = libraryIds;
                            $i$f$any = false;
                            if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block8;
                            v0 = false;
                            break block6;
                        }
                        for (T element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            $i$a$-any-DifferentStdlibGradleVersionInspection$Companion$findLibraryStatement$1$1 = false;
                            v1 = statement.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"statement.text");
                            index = StringsKt.indexOf$default((CharSequence)v1, (String)it, (int)0, (boolean)false, (int)6, null);
                            if (index == -1) ** GOTO lbl-1000
                            v2 = statement.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"statement.text");
                            v3 = StringsKt.getOrNull((CharSequence)v2, (int)(index + it.length()));
                            if (v3 == null || v3.charValue() != '-') {
                                v4 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v4 = false;
                            }
                            if (!v4) continue;
                            v0 = true;
                            break block6;
                        }
                        v0 = false;
                    }
                    if (!v0) ** GOTO lbl-1000
                    v5 = statement.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"statement.text");
                    if (StringsKt.contains$default((CharSequence)v5, (CharSequence)libraryGroup, (boolean)false, (int)2, null)) {
                        v6 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = false;
                    }
                    if (!v6) continue;
                    v7 = element$iv;
                    break block7;
                }
                v7 = null;
            }
            return v7;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final String getResolvedLibVersion(@NotNull PsiFile file, @NotNull String groupId, @NotNull List<String> libraryIds) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter(libraryIds, (String)"libraryIds");
            DataNode<ProjectData> dataNode = KotlinGradleInspectionVisitorKt.findGradleProjectStructure(file);
            if (dataNode == null) {
                return null;
            }
            DataNode<ProjectData> projectStructureNode = dataNode;
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)file.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(file.project)");
            Module module = projectRootManager.getFileIndex().getModuleForFile(file.getVirtualFile());
            if (module == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"ProjectRootManager.getIn\u2026rtualFile) ?: return null");
            Module module2 = module;
            Key key = ProjectKeys.MODULE;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"ProjectKeys.MODULE");
            Iterable $this$filter$iv = KotlinGradleInspectionVisitorKt.findAll(projectStructureNode, key);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                NodeWithData it = (NodeWithData)element$iv$iv;
                boolean bl = false;
                Object t = it.getData();
                Intrinsics.checkNotNullExpressionValue(t, (String)"it.data");
                if (!Intrinsics.areEqual((Object)((ModuleData)t).getInternalName(), (Object)module2.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (NodeWithData moduleData : (List)destination$iv$iv) {
                String string = KotlinGradleModelFacadeKt.getResolvedVersionByModuleData(moduleData.getNode(), groupId, libraryIds);
                if (string == null) continue;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                return it;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

