/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.el.SpringELBundle;
import com.intellij.spring.el.SpringELFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringElStaticFieldInjectionInspection
extends AbstractBaseJavaLocalInspectionTool {
    public ProblemDescriptor @Nullable [] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiAnnotation psiAnnotation;
        if (field == null) {
            SpringElStaticFieldInjectionInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringElStaticFieldInjectionInspection.$$$reportNull$$$0(1);
        }
        if (!SpringLibraryUtil.hasSpringLibrary((Project)manager.getProject())) {
            return null;
        }
        PsiModifierList modifierList = field.getModifierList();
        if (modifierList != null && modifierList.hasModifierProperty("static") && (psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, (boolean)true, (String[])new String[]{"org.springframework.beans.factory.annotation.Value"})) != null && SpringElStaticFieldInjectionInspection.isSpElInjected(psiAnnotation)) {
            PsiJavaCodeReferenceElement nameReferenceElement = psiAnnotation.getNameReferenceElement();
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)(nameReferenceElement != null ? nameReferenceElement : psiAnnotation), SpringELBundle.message("SpringElStaticFieldInjectionInspection.cannot.inject.in.static.fields", new Object[0]), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, false)};
        }
        return super.checkField(field, manager, isOnTheFly);
    }

    private static boolean isSpElInjected(PsiAnnotation annotation) {
        Ref ref = Ref.create((Object)false);
        for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
            PsiAnnotationMemberValue value = pair.getValue();
            if (!(value instanceof PsiLiteralExpression)) continue;
            InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)annotation.getProject());
            manager.enumerate((PsiElement)value, (injectedPsi, places) -> {
                if (injectedPsi.getFileType() instanceof SpringELFileType) {
                    ref.set((Object)true);
                }
            });
        }
        return (Boolean)ref.get();
    }

    @NotNull
    public String getShortName() {
        return "SpringElStaticFieldInjectionInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "field";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/el/inspections/SpringElStaticFieldInjectionInspection";
        objectArray[2] = "checkField";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

