/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el.contextProviders.extensions;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.spring.el.contextProviders.extensions.SpringCommentLightVariableBuilder;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringELCommentVariablesExtension
extends SpringElContextsExtension {
    public static final String EL_VAR = "@el";
    private static final Pattern VAR_PATTERN = Pattern.compile("(.+)\\s*:\\s*(.*)");

    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        PsiElement context;
        if (contextElement == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(0);
        }
        SmartList variables = new SmartList();
        PsiFile containingFile = contextElement.getContainingFile();
        if (containingFile != null && (context = containingFile.getContext()) != null) {
            PsiModifierListOwner commentOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)context, PsiModifierListOwner.class);
            while (commentOwner != null) {
                variables.addAll(SpringELCommentVariablesExtension.getVariableFromComments(commentOwner));
                commentOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)commentOwner, PsiModifierListOwner.class);
            }
        }
        SmartList smartList = variables;
        if (smartList == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(1);
        }
        return smartList;
    }

    private static Collection<? extends PsiVariable> getVariableFromComments(@NotNull PsiModifierListOwner commentOwner) {
        if (commentOwner == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(2);
        }
        SmartList variables = new SmartList();
        SpringELCommentVariablesExtension.processComments((List<PsiVariable>)variables, (PsiComment[])PsiTreeUtil.getChildrenOfType((PsiElement)commentOwner, PsiComment.class));
        PsiModifierList modifierList = commentOwner.getModifierList();
        if (modifierList != null) {
            SpringELCommentVariablesExtension.processComments((List<PsiVariable>)variables, (PsiComment[])PsiTreeUtil.getChildrenOfType((PsiElement)modifierList, PsiComment.class));
        }
        return variables;
    }

    private static void processComments(@NotNull List<PsiVariable> variables, PsiComment @Nullable [] comments) {
        if (variables == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(3);
        }
        if (comments != null) {
            for (PsiComment comment : comments) {
                SpringELCommentVariablesExtension.processVariableDeclarations(comment.getText(), (vars, start, end) -> variables.addAll(SpringELCommentVariablesExtension.getVariables(comment, vars)));
            }
        }
    }

    public static void processVariableDeclarations(@NotNull String text, @NotNull ElVarsProcessor processor) {
        int end;
        int start;
        if (text == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(5);
        }
        int elVarIndex = text.indexOf(EL_VAR);
        while (elVarIndex >= 0 && (start = text.indexOf("(", elVarIndex) + 1) < (end = text.indexOf(")", elVarIndex))) {
            String varsString = text.substring(start, end);
            if (StringUtil.isNotEmpty((String)varsString)) {
                processor.process(varsString, start, end);
            }
            elVarIndex = text.indexOf(EL_VAR, elVarIndex + 1);
        }
    }

    @NotNull
    private static List<PsiVariable> getVariables(@NotNull PsiComment comment, @NotNull String vars) {
        if (comment == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(6);
        }
        if (vars == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(7);
        }
        SmartList variables = new SmartList();
        for (String var : StringUtil.split((String)vars, (String)",")) {
            Matcher varMatcher = VAR_PATTERN.matcher(var.trim());
            if (!varMatcher.matches()) continue;
            String name = varMatcher.group(1).trim();
            String typeName = varMatcher.group(2).trim();
            String fqn = typeName.indexOf(36) >= 0 ? typeName.replace('$', '.') : typeName;
            PsiType type = PsiImplUtil.buildTypeFromTypeString((String)fqn.trim(), (PsiElement)comment, (PsiFile)comment.getContainingFile());
            variables.add(new SpringCommentLightVariableBuilder(name, type, comment));
        }
        SmartList smartList = variables;
        if (smartList == null) {
            SpringELCommentVariablesExtension.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/el/contextProviders/extensions/SpringELCommentVariablesExtension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentOwner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/el/contextProviders/extensions/SpringELCommentVariablesExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextVariables";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextVariables";
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVariableFromComments";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processComments";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processVariableDeclarations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVariables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ElVarsProcessor {
        public void process(@NotNull String var1, int var2, int var3);
    }
}

