/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el;

import com.intellij.openapi.util.TextRange;
import com.intellij.spring.el.ParseException;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Stack;

public class SpringElTemplateParser {
    public static List<TextRange> parse(String expression) {
        return SpringElTemplateParser.parseExpressions(expression, "#{", "}");
    }

    private static List<TextRange> parseExpressions(String expressionString, String prefix, String suffix) {
        SmartList expressions = new SmartList();
        int startIdx = 0;
        while (startIdx < expressionString.length()) {
            int prefixIndex = expressionString.indexOf(prefix, startIdx);
            if (prefixIndex >= startIdx) {
                int suffixIndex;
                int afterPrefixIndex = prefixIndex + prefix.length();
                try {
                    suffixIndex = SpringElTemplateParser.skipToCorrectEndSuffix(prefix, suffix, expressionString, afterPrefixIndex);
                }
                catch (ParseException e) {
                    return expressions;
                }
                if (suffixIndex == -1) {
                    return expressions;
                }
                expressions.add(TextRange.create((int)prefixIndex, (int)(suffixIndex + suffix.length())));
                startIdx = suffixIndex + suffix.length();
                continue;
            }
            startIdx = expressionString.length();
        }
        return expressions;
    }

    private static boolean isSuffixHere(String expressionString, int pos, String suffix) {
        int suffixPosition = 0;
        for (int i = 0; i < suffix.length() && pos < expressionString.length(); ++i) {
            if (expressionString.charAt(pos++) == suffix.charAt(suffixPosition++)) continue;
            return false;
        }
        return suffixPosition == suffix.length();
    }

    private static int skipToCorrectEndSuffix(String prefix, String suffix, String expressionString, int afterPrefixIndex) throws ParseException {
        int pos;
        int maxLen = expressionString.length();
        int nextSuffix = expressionString.indexOf(suffix, afterPrefixIndex);
        if (nextSuffix == -1) {
            return -1;
        }
        Stack<Bracket> stack = new Stack<Bracket>();
        block5: for (pos = afterPrefixIndex; !(pos >= maxLen || SpringElTemplateParser.isSuffixHere(expressionString, pos, suffix) && stack.isEmpty()); ++pos) {
            char ch = expressionString.charAt(pos);
            switch (ch) {
                case '(': 
                case '[': 
                case '{': {
                    stack.push(new Bracket(ch, pos));
                    continue block5;
                }
                case ')': 
                case ']': 
                case '}': {
                    if (stack.isEmpty()) {
                        throw new ParseException(expressionString, pos, "Found closing '" + ch + "' at position " + pos + " without an opening '" + Bracket.theOpenBracketFor(ch) + "'");
                    }
                    Bracket p = (Bracket)stack.pop();
                    if (p.compatibleWithCloseBracket(ch)) continue block5;
                    throw new ParseException(expressionString, pos, "Found closing '" + ch + "' at position " + pos + " but most recent opening is '" + p.bracket + "' at position " + p.pos);
                }
                case '\"': 
                case '\'': {
                    int endLiteral = expressionString.indexOf(ch, pos + 1);
                    if (endLiteral == -1) {
                        throw new ParseException(expressionString, pos, "Found non terminating string literal starting at position " + pos);
                    }
                    pos = endLiteral;
                }
            }
        }
        if (!stack.isEmpty()) {
            Bracket p = (Bracket)stack.pop();
            throw new ParseException(expressionString, p.pos, "Missing closing '" + Bracket.theCloseBracketFor(p.bracket) + "' for '" + p.bracket + "' at position " + p.pos);
        }
        if (!SpringElTemplateParser.isSuffixHere(expressionString, pos, suffix)) {
            return -1;
        }
        return pos;
    }

    private static final class Bracket {
        private final char bracket;
        private final int pos;

        private Bracket(char bracket, int pos) {
            this.bracket = bracket;
            this.pos = pos;
        }

        private boolean compatibleWithCloseBracket(char closeBracket) {
            if (this.bracket == '{') {
                return closeBracket == '}';
            }
            if (this.bracket == '[') {
                return closeBracket == ']';
            }
            return closeBracket == ')';
        }

        private static char theOpenBracketFor(char closeBracket) {
            if (closeBracket == '}') {
                return '{';
            }
            if (closeBracket == ']') {
                return '[';
            }
            return '(';
        }

        private static char theCloseBracketFor(char openBracket) {
            if (openBracket == '{') {
                return '}';
            }
            if (openBracket == '[') {
                return ']';
            }
            return ')';
        }
    }
}

