/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.el;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomNamedTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiVariable;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.el.SpringElBeanVariable;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringBeanUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class SpringBeansAsElVariableUtil {
    private SpringBeansAsElVariableUtil() {
    }

    public static void addVariables(List<? super PsiVariable> resultVars, Module module) {
        SpringModel springModel = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
        SpringBeansAsElVariableUtil.addVariables(resultVars, (CommonSpringModel)springModel);
    }

    public static void addVariables(List<? super PsiVariable> resultVars, CommonSpringModel model) {
        Collection list = model.getAllCommonBeans();
        for (SpringBeanPointer pointer : list) {
            PsiElement declarationElement;
            PsiFile file = pointer.getContainingFile();
            CommonSpringBean bean = pointer.getSpringBean();
            if (bean instanceof ContextJavaBean) {
                for (PomNamedTarget target : ((ContextJavaBean)bean).getPomTargets()) {
                    PsiElement declarationElement2 = PomService.convertToPsi((PsiTarget)((PsiTarget)target));
                    String name = target.getName();
                    if (!StringUtil.isNotEmpty((String)name)) continue;
                    resultVars.add((PsiVariable)SpringBeansAsElVariableUtil.createVariable(pointer, file, name, declarationElement2));
                }
                continue;
            }
            String beanName = pointer.getName();
            if (StringUtil.isEmptyOrSpaces((String)beanName) || !pointer.isValid() || (declarationElement = pointer.getPsiElement()) == null) continue;
            Set beanNames = SpringBeanUtils.getInstance().findBeanNames(bean);
            for (String aliasName : beanNames) {
                if (StringUtil.isEmptyOrSpaces((String)aliasName)) continue;
                resultVars.add((PsiVariable)SpringBeansAsElVariableUtil.createVariable(pointer, file, aliasName, declarationElement));
            }
        }
    }

    public static SpringElBeanVariable createVariable(SpringBeanPointer springBeanPointer, String name) {
        return SpringBeansAsElVariableUtil.createVariable(springBeanPointer, springBeanPointer.getContainingFile(), name, springBeanPointer.getPsiElement());
    }

    private static SpringElBeanVariable createVariable(SpringBeanPointer springBeanPointer, PsiFile file, String beanName, PsiElement declarationElement) {
        PsiElement declaration = declarationElement instanceof PomTargetPsiElement ? declarationElement.getNavigationElement() : declarationElement;
        return new SpringElBeanVariable(springBeanPointer, file, beanName, declaration);
    }
}

