/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.plexus.lifecycle;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.internal.impldep.org.codehaus.plexus.lifecycle.LifecycleHandler;
import org.gradle.internal.impldep.org.codehaus.plexus.lifecycle.LifecycleHandlerManager;
import org.gradle.internal.impldep.org.codehaus.plexus.lifecycle.UndefinedLifecycleHandlerException;

public class DefaultLifecycleHandlerManager
implements LifecycleHandlerManager {
    private final ConcurrentMap<String, LifecycleHandler> lifecycleHandlers = new ConcurrentHashMap<String, LifecycleHandler>();
    private String defaultLifecycleHandlerId = "plexus";

    @Override
    public void addLifecycleHandler(LifecycleHandler lifecycleHandler) {
        this.lifecycleHandlers.put(lifecycleHandler.getId(), lifecycleHandler);
    }

    @Override
    public void initialize() {
        for (LifecycleHandler lifecycleHandler : this.lifecycleHandlers.values()) {
            lifecycleHandler.initialize();
        }
    }

    @Override
    public LifecycleHandler getLifecycleHandler(String id) throws UndefinedLifecycleHandlerException {
        LifecycleHandler lifecycleHandler;
        if (id == null) {
            id = this.defaultLifecycleHandlerId;
        }
        if ((lifecycleHandler = (LifecycleHandler)this.lifecycleHandlers.get(id)) == null) {
            throw new UndefinedLifecycleHandlerException("Specified lifecycle handler cannot be found: " + id);
        }
        return lifecycleHandler;
    }
}

