/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.plexus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gradle.internal.impldep.org.codehaus.plexus.ClassRealmUtil;
import org.gradle.internal.impldep.org.codehaus.plexus.ComponentRegistry;
import org.gradle.internal.impldep.org.codehaus.plexus.MutablePlexusContainer;
import org.gradle.internal.impldep.org.codehaus.plexus.PlexusContainerException;
import org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.gradle.internal.impldep.org.codehaus.plexus.component.CastUtils;
import org.gradle.internal.impldep.org.codehaus.plexus.component.composition.CycleDetectedInComponentGraphException;
import org.gradle.internal.impldep.org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.gradle.internal.impldep.org.codehaus.plexus.component.manager.ComponentManager;
import org.gradle.internal.impldep.org.codehaus.plexus.component.manager.ComponentManagerFactory;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.ComponentRepository;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.gradle.internal.impldep.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.gradle.internal.impldep.org.codehaus.plexus.lifecycle.LifecycleHandler;
import org.gradle.internal.impldep.org.codehaus.plexus.lifecycle.LifecycleHandlerManager;
import org.gradle.internal.impldep.org.codehaus.plexus.lifecycle.UndefinedLifecycleHandlerException;
import org.gradle.internal.impldep.org.codehaus.plexus.logging.Logger;
import org.gradle.internal.impldep.org.codehaus.plexus.util.StringUtils;

public class DefaultComponentRegistry
implements ComponentRegistry {
    private static final String DEFAULT_INSTANTIATION_STRATEGY = "singleton";
    private final MutablePlexusContainer container;
    private final ComponentRepository repository;
    private final LifecycleHandlerManager lifecycleHandlerManager;
    private final Logger logger;
    private boolean disposingComponents;
    private final Map<String, ComponentManagerFactory> componentManagerFactories = Collections.synchronizedMap(new TreeMap());
    private final Map<Key, ComponentManager<?>> componentManagers = new TreeMap();
    private final Map<Object, ComponentManager<?>> componentManagersByComponent = new IdentityHashMap();
    private final Map<Key, Object> unmanagedComponents = new TreeMap<Key, Object>();

    public DefaultComponentRegistry(MutablePlexusContainer container, ComponentRepository repository, LifecycleHandlerManager lifecycleHandlerManager) {
        this.container = container;
        this.repository = repository;
        this.lifecycleHandlerManager = lifecycleHandlerManager;
        this.logger = container.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ArrayList managers;
        DefaultComponentRegistry defaultComponentRegistry = this;
        synchronized (defaultComponentRegistry) {
            managers = new ArrayList(this.componentManagers.values());
            this.componentManagers.clear();
            this.componentManagersByComponent.clear();
            this.unmanagedComponents.clear();
            this.disposingComponents = true;
        }
        Collections.sort(managers, new Comparator<ComponentManager<?>>(){

            @Override
            public int compare(ComponentManager<?> left, ComponentManager<?> right) {
                if (left.getStartId() < right.getStartId()) {
                    return 1;
                }
                if (left.getStartId() == right.getStartId()) {
                    return 0;
                }
                return -1;
            }
        });
        try {
            for (ComponentManager componentManager : managers) {
                try {
                    componentManager.dispose();
                }
                catch (Exception e) {
                    this.logger.error("Error while disposing component manager. Continuing with the rest", e);
                }
            }
        }
        finally {
            defaultComponentRegistry = this;
            synchronized (defaultComponentRegistry) {
                this.disposingComponents = false;
            }
        }
    }

    @Override
    public void registerComponentManagerFactory(ComponentManagerFactory componentManagerFactory) {
        this.componentManagerFactories.put(componentManagerFactory.getId(), componentManagerFactory);
    }

    @Override
    public void addComponentDescriptor(ComponentDescriptor<?> componentDescriptor) throws CycleDetectedInComponentGraphException {
        this.repository.addComponentDescriptor(componentDescriptor);
    }

    @Override
    public synchronized <T> void addComponent(T component, String role, String roleHint) {
        ComponentDescriptor descriptor = new ComponentDescriptor(component.getClass(), null);
        descriptor.setRole(role);
        descriptor.setRoleHint(roleHint);
        Key key = new Key(descriptor.getRealm(), role, roleHint);
        this.unmanagedComponents.put(key, component);
    }

    @Override
    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> type, String role, String roleHint) {
        return this.repository.getComponentDescriptor(type, role, roleHint);
    }

    @Override
    @Deprecated
    public ComponentDescriptor<?> getComponentDescriptor(String role, String roleHint, ClassRealm realm) {
        return this.repository.getComponentDescriptor(role, roleHint, realm);
    }

    @Override
    public <T> Map<String, ComponentDescriptor<T>> getComponentDescriptorMap(Class<T> type, String role) {
        return this.repository.getComponentDescriptorMap(type, role);
    }

    @Override
    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> type, String role) {
        return this.repository.getComponentDescriptorList(type, role);
    }

    @Override
    public <T> T lookup(Class<T> type, String role, String roleHint) throws ComponentLookupException {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (role == null) {
            throw new NullPointerException("role is null");
        }
        if (roleHint == null) {
            roleHint = "";
        }
        return this.getComponent(type, role, roleHint, null);
    }

    @Override
    public <T> T lookup(ComponentDescriptor<T> componentDescriptor) throws ComponentLookupException {
        return this.getComponent(componentDescriptor.getRoleClass(), componentDescriptor.getRole(), componentDescriptor.getRoleHint(), componentDescriptor);
    }

    @Override
    public <T> Map<String, T> lookupMap(Class<T> type, String role, List<String> roleHints) throws ComponentLookupException {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (role == null) {
            throw new NullPointerException("role is null");
        }
        LinkedHashMap<String, T> components = new LinkedHashMap<String, T>();
        if (roleHints == null) {
            Map<String, ComponentDescriptor<T>> componentDescriptors = this.getComponentDescriptorMap(type, role);
            for (Map.Entry<String, ComponentDescriptor<T>> entry : componentDescriptors.entrySet()) {
                String roleHint = entry.getKey();
                ComponentDescriptor<T> componentDescriptor = entry.getValue();
                T component = this.getComponent(type, role, roleHint, componentDescriptor);
                components.put(roleHint, component);
            }
        } else {
            for (String roleHint : roleHints) {
                T component = this.getComponent(type, role, roleHint, null);
                components.put(roleHint, component);
            }
        }
        return components;
    }

    @Override
    public <T> List<T> lookupList(Class<T> type, String role, List<String> roleHints) throws ComponentLookupException {
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (role == null) {
            throw new NullPointerException("role is null");
        }
        ArrayList<T> components = new ArrayList<T>();
        if (roleHints == null) {
            List<ComponentDescriptor<T>> componentDescriptors = this.getComponentDescriptorList(type, role);
            for (ComponentDescriptor<T> componentDescriptor : componentDescriptors) {
                T component = this.getComponent(type, role, componentDescriptor.getRoleHint(), componentDescriptor);
                components.add(component);
            }
        } else {
            for (String roleHint : roleHints) {
                T component = this.getComponent(type, role, roleHint, null);
                components.add(component);
            }
        }
        return components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Object component) throws ComponentLifecycleException {
        ComponentManager<?> componentManager;
        if (component == null) {
            return;
        }
        DefaultComponentRegistry defaultComponentRegistry = this;
        synchronized (defaultComponentRegistry) {
            componentManager = this.componentManagersByComponent.get(component);
            if (componentManager == null) {
                return;
            }
        }
        componentManager.release(component);
        if (componentManager.getConnections() <= 0) {
            defaultComponentRegistry = this;
            synchronized (defaultComponentRegistry) {
                this.componentManagersByComponent.remove(component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeComponentRealm(ClassRealm classRealm) throws PlexusContainerException {
        this.repository.removeComponentRealm(classRealm);
        ArrayList dispose = new ArrayList();
        try {
            DefaultComponentRegistry defaultComponentRegistry = this;
            synchronized (defaultComponentRegistry) {
                Iterator<Map.Entry<Key, ComponentManager<?>>> iterator = this.componentManagers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Key, ComponentManager<?>> entry = iterator.next();
                    Key key = entry.getKey();
                    ComponentManager<?> componentManager = entry.getValue();
                    if (key.realm.equals(classRealm)) {
                        dispose.add(componentManager);
                        iterator.remove();
                        continue;
                    }
                    componentManager.dissociateComponentRealm(classRealm);
                }
            }
            for (ComponentManager componentManager : dispose) {
                componentManager.dispose();
            }
        }
        catch (ComponentLifecycleException e) {
            throw new PlexusContainerException("Failed to dissociate component realm: " + classRealm.getId(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getComponent(Class<T> type, String role, String roleHint, ComponentDescriptor<T> descriptor) throws ComponentLookupException {
        T component = this.getUnmanagedComponent(role, roleHint);
        if (component != null) {
            return component;
        }
        ComponentManager<T> componentManager = this.getComponentManager(type, role, roleHint, descriptor);
        try {
            component = componentManager.getComponent();
            DefaultComponentRegistry defaultComponentRegistry = this;
            synchronized (defaultComponentRegistry) {
                this.componentManagersByComponent.put(component, componentManager);
            }
            return component;
        }
        catch (ComponentInstantiationException e) {
            throw new ComponentLookupException("Unable to lookup component '" + componentManager.getRole() + "', it could not be created.", componentManager.getRole(), componentManager.getRoleHint(), componentManager.getRealm(), e);
        }
        catch (ComponentLifecycleException e) {
            throw new ComponentLookupException("Unable to lookup component '" + componentManager.getRole() + "', it could not be started.", componentManager.getRole(), componentManager.getRoleHint(), componentManager.getRealm(), e);
        }
    }

    private synchronized <T> T getUnmanagedComponent(String role, String roleHint) {
        Set<ClassRealm> realms = this.getSearchRealms(true);
        if (realms != null) {
            return null;
        }
        if (StringUtils.isEmpty(roleHint)) {
            roleHint = "default";
        }
        return (T)this.unmanagedComponents.get(new Key(null, role, roleHint));
    }

    private synchronized <T> ComponentManager<T> getComponentManager(Class<T> type, String role, String roleHint, ComponentDescriptor<T> descriptor) throws ComponentLookupException {
        if (this.disposingComponents) {
            throw new ComponentLookupException("ComponentRegistry is not active", role, roleHint);
        }
        if (descriptor == null) {
            descriptor = this.getComponentDescriptor(type, role, roleHint);
        }
        ComponentManager<T> componentManager = null;
        componentManager = descriptor != null ? this.getComponentManager(type, role, descriptor.getRoleHint(), descriptor.getRealm()) : this.getComponentManager(type, role, roleHint);
        if (componentManager == null) {
            if (descriptor == null) {
                descriptor = this.getComponentDescriptor(type, role, roleHint);
                if (descriptor == null) {
                    throw new ComponentLookupException("Component descriptor cannot be found in the component repository", role, roleHint);
                }
                componentManager = this.getComponentManager(type, role, descriptor.getRoleHint(), descriptor.getRealm());
            }
            if (componentManager == null) {
                componentManager = this.createComponentManager(descriptor, role, descriptor.getRoleHint());
            }
        }
        return componentManager;
    }

    private <T> ComponentManager<T> getComponentManager(Class<T> type, String role, String roleHint) {
        Set<ClassRealm> realms = this.getSearchRealms(false);
        for (ClassRealm realm : realms) {
            ComponentManager<?> manager = this.componentManagers.get(new Key(realm, role, roleHint));
            if (manager == null || !CastUtils.isAssignableFrom(type, manager.getType())) continue;
            return manager;
        }
        return null;
    }

    private <T> ComponentManager<T> getComponentManager(Class<T> type, String role, String roleHint, ClassRealm realm) {
        ComponentManager<?> manager = this.componentManagers.get(new Key(realm, role, roleHint));
        if (manager != null && CastUtils.isAssignableFrom(type, manager.getType())) {
            return manager;
        }
        return null;
    }

    private Set<ClassRealm> getSearchRealms(boolean specifiedOnly) {
        Set<ClassRealm> realms = ClassRealmUtil.getContextRealms(this.container.getClassWorld());
        if (realms.isEmpty()) {
            if (specifiedOnly) {
                return null;
            }
            realms.addAll(this.container.getClassWorld().getRealms());
        }
        return realms;
    }

    private <T> ComponentManager<T> createComponentManager(ComponentDescriptor<T> descriptor, String role, String roleHint) throws ComponentLookupException {
        LifecycleHandler lifecycleHandler;
        ComponentManagerFactory componentManagerFactory;
        String instantiationStrategy = descriptor.getInstantiationStrategy();
        if (instantiationStrategy == null) {
            instantiationStrategy = DEFAULT_INSTANTIATION_STRATEGY;
        }
        if ((componentManagerFactory = this.componentManagerFactories.get(instantiationStrategy)) == null) {
            throw new ComponentLookupException("Unsupported instantiation strategy: " + instantiationStrategy, role, roleHint, descriptor.getRealm());
        }
        try {
            lifecycleHandler = this.lifecycleHandlerManager.getLifecycleHandler(descriptor.getLifecycleHandler());
        }
        catch (UndefinedLifecycleHandlerException e) {
            throw new ComponentLookupException("Undefined lifecycle handler: " + descriptor.getLifecycleHandler(), role, roleHint, descriptor.getRealm());
        }
        ComponentManager<T> componentManager = componentManagerFactory.createComponentManager(this.container, lifecycleHandler, descriptor, role, roleHint);
        Key key = new Key(descriptor.getRealm(), role, roleHint);
        this.componentManagers.put(key, componentManager);
        return componentManager;
    }

    private static class Key
    implements Comparable<Key> {
        private final ClassRealm realm;
        private final String role;
        private final String roleHint;
        private final int hashCode;

        private Key(ClassRealm realm, String role, String roleHint) {
            this.realm = realm;
            if (role == null) {
                role = "null";
            }
            this.role = role;
            if (roleHint == null) {
                roleHint = "null";
            }
            this.roleHint = roleHint;
            int hashCode = realm != null ? realm.hashCode() : 0;
            hashCode = 31 * hashCode + role.hashCode();
            this.hashCode = hashCode = 31 * hashCode + roleHint.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) return false;
            if (this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.realm != null) {
                if (!this.realm.equals(key.realm)) {
                    return false;
                }
            } else if (key.realm != null) return false;
            if (!this.role.equals(key.role)) return false;
            if (!this.roleHint.equals(key.roleHint)) return false;
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.realm + "/" + this.role + "/" + this.roleHint;
        }

        @Override
        public int compareTo(Key o) {
            int value;
            if (this.realm != null) {
                value = o.realm == null ? -1 : this.realm.getId().compareTo(o.realm.getId());
            } else {
                int n = value = o.realm == null ? 0 : 1;
            }
            if (value == 0 && (value = this.role.compareTo(o.role)) == 0) {
                value = this.roleHint.compareTo(o.roleHint);
            }
            return value;
        }
    }
}

