/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.bsh;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.gradle.internal.impldep.bsh.CallStack;
import org.gradle.internal.impldep.bsh.Capabilities;
import org.gradle.internal.impldep.bsh.EvalError;
import org.gradle.internal.impldep.bsh.Interpreter;
import org.gradle.internal.impldep.bsh.InterpreterError;
import org.gradle.internal.impldep.bsh.SimpleNode;

public class TargetError
extends EvalError {
    boolean inNativeCode;

    public TargetError(String msg, Throwable t, SimpleNode node, CallStack callstack, boolean inNativeCode) {
        super(msg, node, callstack);
        this.initCause(t);
        this.inNativeCode = inNativeCode;
    }

    public TargetError(Throwable t, SimpleNode node, CallStack callstack) {
        this("TargetError", t, node, callstack, false);
    }

    public Throwable getTarget() {
        Throwable target = this.getCause();
        if (target instanceof InvocationTargetException) {
            return ((InvocationTargetException)target).getTargetException();
        }
        return target;
    }

    public String toString() {
        return super.toString() + "\nTarget exception: " + this.printTargetError(this.getCause());
    }

    public void printStackTrace() {
        this.printStackTrace(false, System.err);
    }

    public void printStackTrace(PrintStream out) {
        this.printStackTrace(false, out);
    }

    public void printStackTrace(boolean debug, PrintStream out) {
        if (debug) {
            super.printStackTrace(out);
            out.println("--- Target Stack Trace ---");
        }
        this.getCause().printStackTrace(out);
    }

    public String printTargetError(Throwable t) {
        String s = this.getCause().toString();
        if (Capabilities.canGenerateInterfaces()) {
            s = s + "\n" + this.xPrintTargetError(t);
        }
        return s;
    }

    public String xPrintTargetError(Throwable t) {
        String getTarget = "import java.lang.reflect.UndeclaredThrowableException;String result=\"\";while ( target instanceof UndeclaredThrowableException ) {\ttarget=target.getUndeclaredThrowable(); \tresult+=\"Nested: \"+target.toString();}return result;";
        Interpreter i = new Interpreter();
        try {
            i.set("target", t);
            return (String)i.eval(getTarget);
        }
        catch (EvalError e) {
            throw new InterpreterError("xprintarget: " + e.toString());
        }
    }

    public boolean inNativeCode() {
        return this.inNativeCode;
    }
}

