/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.runtimes.ComposeApplicationRuntime;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.docker.view.details.DockerComposeDetails;
import com.intellij.docker.view.details.DockerContainerDetails;
import com.intellij.docker.view.details.DockerDeploymentDetails;
import com.intellij.docker.view.details.DockerDeploymentDetailsBase;
import com.intellij.docker.view.details.DockerImageDetails;
import com.intellij.docker.view.details.DockerImagesGroupDetails;
import com.intellij.docker.view.details.TabManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.ui.UIUtil;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class DockerDeploymentDetailsManager {
    private final Project myProject;
    private final Map<Deployment, DockerDeploymentDetails> myDeployment2Details;

    public DockerDeploymentDetailsManager(Project project) {
        this.myProject = project;
        this.myDeployment2Details = FactoryMap.create(this::createDeploymentDetails);
    }

    public void updateContent(Deployment deployment) {
        if (this.myDeployment2Details.containsKey(deployment)) {
            DockerDeploymentDetails content = this.myDeployment2Details.get(deployment);
            UIUtil.invokeLaterIfNeeded(() -> content.update());
        }
    }

    private DockerDeploymentDetails createDeploymentDetails(@NotNull Deployment deployment) {
        DeploymentRuntime runtime;
        if (deployment == null) {
            DockerDeploymentDetailsManager.$$$reportNull$$$0(0);
        }
        if ((runtime = deployment.getRuntime()) instanceof DockerGroupRuntime.ImagesGroup) {
            return new DockerImagesGroupDetails(this.myProject, deployment, (DockerGroupRuntime.ImagesGroup)runtime);
        }
        if (runtime instanceof DockerGroupRuntime) {
            return new EmptyDetails(this.myProject, deployment);
        }
        if (DockerDeploymentDetailsManager.isComposeDeployment(deployment)) {
            return new DockerComposeDetails(this.myProject, deployment);
        }
        if (runtime instanceof ComposeServiceRuntime || runtime instanceof ComposeApplicationRuntime) {
            return new EmptyDetails(this.myProject, deployment);
        }
        if (DockerDeploymentDetailsManager.isImageDeployment(deployment)) {
            return new DockerImageDetails(this.myProject, deployment);
        }
        return new DockerContainerDetails(this.myProject, deployment);
    }

    @NotNull
    public DockerDeploymentDetails getDeploymentDetails(@NotNull Deployment deployment) {
        if (deployment == null) {
            DockerDeploymentDetailsManager.$$$reportNull$$$0(1);
        }
        DockerDeploymentDetails dockerDeploymentDetails = this.myDeployment2Details.get(deployment);
        if (dockerDeploymentDetails == null) {
            DockerDeploymentDetailsManager.$$$reportNull$$$0(2);
        }
        return dockerDeploymentDetails;
    }

    private static boolean isComposeDeployment(@NotNull Deployment deployment) {
        if (deployment == null) {
            DockerDeploymentDetailsManager.$$$reportNull$$$0(3);
        }
        return Optional.ofNullable(deployment.getDeploymentTask()).map(DeploymentTask::getSource).map(DeploymentSource::getType).orElse(null) instanceof DockerComposeDeploymentSourceType;
    }

    private static boolean isImageDeployment(@NotNull Deployment deployment) {
        DeploymentTask deploymentTask;
        if (deployment == null) {
            DockerDeploymentDetailsManager.$$$reportNull$$$0(4);
        }
        if ((deploymentTask = deployment.getDeploymentTask()) != null && deploymentTask.getSource().getType() instanceof DockerFileDeploymentSourceType) {
            DockerDeploymentConfiguration configuration = (DockerDeploymentConfiguration)((Object)ObjectUtils.tryCast((Object)deploymentTask.getConfiguration(), DockerDeploymentConfiguration.class));
            return configuration != null && configuration.isBuildOnly();
        }
        DeploymentRuntime runtime = deployment.getRuntime();
        if (runtime instanceof DockerApplicationRuntime) {
            DockerApplicationRuntime runtimeImpl = (DockerApplicationRuntime)runtime;
            return runtimeImpl.getContainerId() == null && runtimeImpl.getImageId() != null;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/view/details/DockerDeploymentDetailsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/view/details/DockerDeploymentDetailsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDeploymentDetails";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentDetails";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isComposeDeployment";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isImageDeployment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyDetails
    extends DockerDeploymentDetailsBase {
        EmptyDetails(@NotNull Project project, @NotNull Deployment deployment) {
            if (project == null) {
                EmptyDetails.$$$reportNull$$$0(0);
            }
            if (deployment == null) {
                EmptyDetails.$$$reportNull$$$0(1);
            }
            super(project, deployment);
        }

        @Override
        @NotNull
        protected TabManagerImpl createTabs() {
            return new TabManagerImpl(this.getProject(), this.getDeployment());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "deployment";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/view/details/DockerDeploymentDetailsManager$EmptyDetails";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

