/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerGroupRuntime;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DockerTreeFilter", storages={@Storage(value="docker.xml")})
public class DockerTreeFilter
implements PersistentStateComponent<DockerTreeFilter> {
    public boolean myStoppedContainersHidden = false;
    public boolean myUntaggedImagesHidden = false;

    public static DockerTreeFilter getInstance() {
        return (DockerTreeFilter)ApplicationManager.getApplication().getService(DockerTreeFilter.class);
    }

    @Nullable
    public DockerTreeFilter getState() {
        return this;
    }

    public void loadState(@NotNull DockerTreeFilter state) {
        if (state == null) {
            DockerTreeFilter.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    public boolean areStoppedContainersHidden() {
        return this.myStoppedContainersHidden;
    }

    public void setStoppedContainersHidden(Boolean stoppedContainersHidden) {
        this.myStoppedContainersHidden = stoppedContainersHidden;
    }

    public boolean areUntaggedImagesHidden() {
        return this.myUntaggedImagesHidden;
    }

    public void setUntaggedImagesHidden(Boolean untaggedImagesHidden) {
        this.myUntaggedImagesHidden = untaggedImagesHidden;
    }

    public boolean acceptNode(@Nullable AbstractTreeNode node) {
        DockerApplicationRuntime appRuntime = Optional.ofNullable(node).map(o -> (ServersTreeStructure.DeploymentNodeImpl)ObjectUtils.tryCast((Object)o, ServersTreeStructure.DeploymentNodeImpl.class)).map(ServersTreeStructure.DeploymentNodeImpl::getDeployment).map(Deployment::getRuntime).map(o -> (DockerApplicationRuntime)((Object)((Object)ObjectUtils.tryCast((Object)o, DockerApplicationRuntime.class)))).orElse(null);
        if (appRuntime != null) {
            CloudApplicationRuntime parent = appRuntime.getParent();
            if (parent instanceof DockerGroupRuntime.ContainersGroup || parent instanceof ComposeServiceRuntime) {
                return this.acceptContainer(appRuntime);
            }
            if (parent instanceof DockerGroupRuntime.ImagesGroup) {
                return this.acceptImage(appRuntime);
            }
        }
        return true;
    }

    private boolean acceptImage(@NotNull DockerApplicationRuntime applicationRuntime) {
        if (applicationRuntime == null) {
            DockerTreeFilter.$$$reportNull$$$0(1);
        }
        if (!this.areUntaggedImagesHidden()) {
            return true;
        }
        Set<String> tags = applicationRuntime.getImageRepoTags();
        boolean untagged = tags == null || tags.isEmpty() || tags.contains("<none>:<none>");
        return !untagged;
    }

    private boolean acceptContainer(@NotNull DockerApplicationRuntime applicationRuntime) {
        if (applicationRuntime == null) {
            DockerTreeFilter.$$$reportNull$$$0(2);
        }
        return !this.areStoppedContainersHidden() || !DockerUtil.isStoppedStatus((String)applicationRuntime.getStatusText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationRuntime";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/view/DockerTreeFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptImage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptContainer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

