/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentStatus;
import com.intellij.docker.action.DockerActionUtils;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.runtimes.DockerDeploymentRuntime;
import com.intellij.docker.view.DockerTreeFilter;
import com.intellij.docker.view.details.DockerDeploymentDetails;
import com.intellij.docker.view.details.DockerDeploymentDetailsManager;
import com.intellij.docker.view.details.ITabManager;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewLocatableDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersServiceViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.ApplicationActionUtils;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import icons.DockerIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerServiceViewContributor
extends RemoteServersServiceViewContributor {
    private static final RemoteServersServiceViewContributor.ActionGroups DOCKER_ACTION_GROUPS = new RemoteServersServiceViewContributor.ActionGroups("Docker.RemoteServersViewToolbar", "Docker.RemoteServersViewToolbar.Top", "Docker.RemoteServersViewPopup");
    private static final ServiceViewDescriptor CONTRIBUTOR_DESCRIPTOR = new SimpleServiceViewDescriptor(DockerBundle.message("DockerServiceViewContributor.contributor.descriptor.name", new Object[0]), DockerIcons.Docker){

        public ActionGroup getToolbarActions() {
            return DockerServiceViewContributor.getToolbarActions((RemoteServersServiceViewContributor.ActionGroups)DOCKER_ACTION_GROUPS);
        }

        public ActionGroup getPopupActions() {
            return DockerServiceViewContributor.getPopupActions((RemoteServersServiceViewContributor.ActionGroups)DOCKER_ACTION_GROUPS);
        }
    };
    private final Map<Project, DockerDeploymentDetailsManager> myDeploymentContentManagers = ConcurrentFactoryMap.createMap(project -> {
        DockerDeploymentDetailsManager deploymentContentManager = new DockerDeploymentDetailsManager((Project)project);
        Disposer.register((Disposable)project, () -> this.myDeploymentContentManagers.remove(project));
        return deploymentContentManager;
    });

    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        if (project == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(0);
        }
        ServiceViewDescriptor serviceViewDescriptor = CONTRIBUTOR_DESCRIPTOR;
        if (serviceViewDescriptor == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(1);
        }
        return serviceViewDescriptor;
    }

    public boolean accept(@NotNull RemoteServer<?> server) {
        if (server == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(2);
        }
        return server.getType().equals((Object)DockerCloudType.getInstance());
    }

    public void selectLog(@NotNull AbstractTreeNode<?> deploymentNode, @NotNull String logName) {
        if (deploymentNode == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(3);
        }
        if (logName == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(4);
        }
        ServiceViewManager.getInstance((Project)deploymentNode.getProject()).select(deploymentNode, DockerServiceViewContributor.class, true, true).onSuccess(any -> {
            DockerDeploymentNode node = (DockerDeploymentNode)ObjectUtils.tryCast((Object)deploymentNode, DockerDeploymentNode.class);
            if (node != null) {
                node.selectDetailsTab(logName);
            }
        });
    }

    @NotNull
    public RemoteServersServiceViewContributor.ActionGroups getActionGroups() {
        RemoteServersServiceViewContributor.ActionGroups actionGroups = DOCKER_ACTION_GROUPS;
        if (actionGroups == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(5);
        }
        return actionGroups;
    }

    public AbstractTreeNode<?> createDeploymentNode(ServerConnection<?> connection, ServersTreeStructure.RemoteServerNode serverNode, Deployment deployment) {
        Project project = Objects.requireNonNull(serverNode.getProject());
        if (project.isDisposed()) {
            return new DockerDeploymentNode(project, connection, serverNode, deployment, (ServersTreeStructure.DeploymentNodeProducer)this, DeploymentDetailsProvider.NO_DETAILS);
        }
        DockerDeploymentDetailsManager deploymentContentManager = this.myDeploymentContentManagers.get(project);
        deploymentContentManager.updateContent(deployment);
        return new DockerDeploymentNode(project, connection, serverNode, deployment, (ServersTreeStructure.DeploymentNodeProducer)this, deploymentContentManager::getDeploymentDetails);
    }

    @NotNull
    protected RemoteServersServiceViewContributor.RemoteServerNodeServiceViewContributor createNodeContributor(@NotNull AbstractTreeNode<?> node) {
        if (node == null) {
            DockerServiceViewContributor.$$$reportNull$$$0(6);
        }
        return new DockerNodeServiceViewContributor(this, node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/view/DockerServiceViewContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/view/DockerServiceViewContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getViewDescriptor";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectLog";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNodeContributor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    private static interface DeploymentDetailsProvider {
        public static final DeploymentDetailsProvider NO_DETAILS = deployment -> null;

        @Nullable
        public DockerDeploymentDetails getDeploymentDetails(@NotNull Deployment var1);
    }

    private static class DockerDeploymentNode
    extends ServersTreeStructure.DeploymentNodeImpl
    implements DetailsProvidingNode {
        private final DeploymentDetailsProvider myDetailsProvider;
        private DockerDeploymentDetails myDetails;

        DockerDeploymentNode(Project project, @NotNull ServerConnection<?> connection, @NotNull ServersTreeStructure.RemoteServerNode serverNode, @NotNull Deployment value, @NotNull ServersTreeStructure.DeploymentNodeProducer nodeProducer, @NotNull DeploymentDetailsProvider detailsProvider) {
            if (connection == null) {
                DockerDeploymentNode.$$$reportNull$$$0(0);
            }
            if (serverNode == null) {
                DockerDeploymentNode.$$$reportNull$$$0(1);
            }
            if (value == null) {
                DockerDeploymentNode.$$$reportNull$$$0(2);
            }
            if (nodeProducer == null) {
                DockerDeploymentNode.$$$reportNull$$$0(3);
            }
            if (detailsProvider == null) {
                DockerDeploymentNode.$$$reportNull$$$0(4);
            }
            super(project, connection, serverNode, value, nodeProducer);
            this.myDetailsProvider = detailsProvider;
        }

        @Nullable
        public JComponent getComponent() {
            DockerDeploymentDetails content = this.getDetails();
            return content != null ? content.show() : null;
        }

        @Override
        @Nullable
        public DockerDeploymentDetails getDetails() {
            if (this.myDetails == null) {
                this.myDetails = this.myDetailsProvider.getDeploymentDetails(this.getDeployment());
            }
            return this.myDetails;
        }

        @Override
        @Nullable
        public ITabManager getDetailsTabs() {
            DockerDeploymentDetails details = this.getDetails();
            return details == null ? null : details.forceCreateTabManager();
        }

        @NotNull
        public Collection<? extends AbstractTreeNode<?>> getChildren() {
            ArrayList result = new ArrayList();
            this.collectDeploymentChildren(result);
            Stream stream = result.stream();
            Collection collection = stream.filter(node -> !DockerDeploymentNode.isUndeployedDockerNode(node)).collect(Collectors.toList());
            if (collection == null) {
                DockerDeploymentNode.$$$reportNull$$$0(5);
            }
            return collection;
        }

        private static boolean isUndeployedDockerNode(@Nullable AbstractTreeNode<?> node) {
            Deployment deployment = Optional.ofNullable(node).map(o -> (DockerDeploymentNode)ObjectUtils.tryCast((Object)o, DockerDeploymentNode.class)).map(ServersTreeStructure.DeploymentNodeImpl::getDeployment).orElse(null);
            return deployment != null && DockerDeploymentStatus.DELETED.matches(deployment) && deployment.getRuntime() instanceof DockerDeploymentRuntime;
        }

        public void selectDetailsTab(@NotNull String tabName) {
            DockerDeploymentDetails details;
            if (tabName == null) {
                DockerDeploymentNode.$$$reportNull$$$0(6);
            }
            if ((details = this.getDetails()) != null) {
                details.selectTab(tabName);
            }
        }

        protected void update(@NotNull PresentationData presentation) {
            ComposeServiceRuntime serviceRuntime;
            if (presentation == null) {
                DockerDeploymentNode.$$$reportNull$$$0(7);
            }
            super.update(presentation);
            Deployment deployment = this.getDeployment();
            DockerApplicationRuntime runtime = (DockerApplicationRuntime)deployment.getRuntime();
            if (deployment.getStatus() == DeploymentStatus.DEPLOYED) {
                Icon icon = runtime != null && runtime.getStatus() == DockerDeploymentStatus.IMAGE ? DockerIcons.SingleImage : DockerIcons.SingleRunningContainer;
                presentation.setIcon(icon);
            }
            if ((serviceRuntime = (ComposeServiceRuntime)ObjectUtils.tryCast((Object)((Object)runtime), ComposeServiceRuntime.class)) != null) {
                presentation.setPresentableText(serviceRuntime.getServiceName());
            }
            if (this.myDetails != null) {
                this.myDetails.update();
            } else {
                ApplicationManager.getApplication().invokeLater(() -> {
                    DockerDeploymentDetails content = this.myDetailsProvider.getDeploymentDetails(deployment);
                    if (content != null) {
                        content.update();
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeProducer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detailsProvider";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/view/DockerServiceViewContributor$DockerDeploymentNode";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/view/DockerServiceViewContributor$DockerDeploymentNode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "selectDetailsTab";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface DetailsProvidingNode
    extends DeploymentNode {
        @Nullable
        public DockerDeploymentDetails getDetails();

        @Nullable
        public ITabManager getDetailsTabs();
    }

    private static class DockerNodeServiceViewContributor
    extends RemoteServersServiceViewContributor.RemoteServerNodeServiceViewContributor {
        DockerNodeServiceViewContributor(@NotNull RemoteServersServiceViewContributor rootContributor, @NotNull AbstractTreeNode<?> node) {
            if (rootContributor == null) {
                DockerNodeServiceViewContributor.$$$reportNull$$$0(0);
            }
            if (node == null) {
                DockerNodeServiceViewContributor.$$$reportNull$$$0(1);
            }
            super(rootContributor, node);
        }

        @NotNull
        public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
            if (project == null) {
                DockerNodeServiceViewContributor.$$$reportNull$$$0(2);
            }
            return new DockerNodeDescriptor(this.asService(), this.getRootContributor().getActionGroups());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootContributor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/view/DockerServiceViewContributor$DockerNodeServiceViewContributor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getViewDescriptor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DockerNodeDescriptor
    extends RemoteServersServiceViewContributor.RemoteServerNodeDescriptor
    implements ServiceViewLocatableDescriptor {
        DockerNodeDescriptor(@NotNull AbstractTreeNode<?> node, @NotNull RemoteServersServiceViewContributor.ActionGroups actionGroups) {
            if (node == null) {
                DockerNodeDescriptor.$$$reportNull$$$0(0);
            }
            if (actionGroups == null) {
                DockerNodeDescriptor.$$$reportNull$$$0(1);
            }
            super(node, actionGroups);
        }

        @Nullable
        public Navigatable getNavigatable() {
            AbstractTreeNode node = this.getNode();
            if (!(node instanceof DeploymentNode)) {
                return null;
            }
            DockerApplicationRuntime runtime = (DockerApplicationRuntime)((Object)ApplicationActionUtils.getApplicationRuntime((DeploymentNode)((DeploymentNode)node), DockerApplicationRuntime.class));
            if (runtime == null) {
                return null;
            }
            return runtime.computeNavigatable(node.getProject());
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            AbstractTreeNode node = this.getNode();
            if (!(node instanceof DeploymentNode)) {
                return null;
            }
            DockerApplicationRuntime runtime = (DockerApplicationRuntime)((Object)ApplicationActionUtils.getApplicationRuntime((DeploymentNode)((DeploymentNode)node), DockerApplicationRuntime.class));
            if (runtime == null) {
                return null;
            }
            return runtime.computeVirtualFile(node.getProject());
        }

        @Nullable
        public Runnable getRemover() {
            Runnable remover = super.getRemover();
            if (remover != null) {
                return remover;
            }
            AbstractTreeNode node = this.getNode();
            if (!(node instanceof DeploymentNode)) {
                return null;
            }
            Deployment deployment = ApplicationActionUtils.getDeployment((DeploymentNode)((DeploymentNode)node));
            if (DockerActionUtils.isFailedContainerDeployment(deployment)) {
                return () -> deployment.getConnection().undeploy(deployment, null);
            }
            DockerApplicationRuntime runtime = (DockerApplicationRuntime)((Object)ApplicationActionUtils.getApplicationRuntime((DeploymentNode)((DeploymentNode)node), DockerApplicationRuntime.class));
            if (DockerActionUtils.isImageRuntime(runtime)) {
                return runtime::deleteImage;
            }
            if (DockerActionUtils.isContainerRuntime(runtime)) {
                return runtime::deleteContainer;
            }
            return null;
        }

        public boolean isVisible() {
            return DockerTreeFilter.getInstance().acceptNode(this.getNode());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionGroups";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/view/DockerServiceViewContributor$DockerNodeDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

