/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.vfs.DockerFileSystem;
import com.intellij.docker.view.DockerFileSystemTree;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerFileChooser
extends JBPanelWithEmptyText
implements Disposable {
    private final Project myProject;
    private final DockerFileSystem myFileSystem;
    private VirtualFile myRoot;
    private DockerFileSystemTree myFileSystemTree;
    private int myBusyCounter;

    public DockerFileChooser(@NotNull Project project, @NotNull DockerApplicationRuntime applicationRuntime, boolean chooseMultiple, @Nullable Runnable runInitialized) {
        if (project == null) {
            DockerFileChooser.$$$reportNull$$$0(0);
        }
        if (applicationRuntime == null) {
            DockerFileChooser.$$$reportNull$$$0(1);
        }
        super((LayoutManager)new BorderLayout());
        this.myProject = project;
        this.setBorder((Border)JBUI.Borders.empty());
        this.withEmptyText(DockerBundle.message("DockerFileChooser.emptyText", new Object[0]));
        this.myFileSystem = new DockerFileSystem(applicationRuntime);
        Disposer.register((Disposable)this, (Disposable)this.myFileSystem);
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 150);
        loadingPanel.setLoadingText(DockerBundle.message("DockerFileChooser.loadingText", new Object[0]));
        this.add((Component)loadingPanel, "Center");
        loadingPanel.startLoading();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.myRoot = this.myFileSystem.getRoot();
            ApplicationManager.getApplication().invokeLater(() -> this.init(loadingPanel, chooseMultiple, runInitialized));
        });
    }

    private void init(@NotNull JBLoadingPanel loadingPanel, boolean chooseMultiple, @Nullable Runnable runInitialized) {
        if (loadingPanel == null) {
            DockerFileChooser.$$$reportNull$$$0(2);
        }
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        loadingPanel.stopLoading();
        this.removeAll();
        if (this.myRoot == null) {
            this.repaint();
            return;
        }
        this.myFileSystemTree = new DockerFileSystemTree(this.myProject, new OurFileChooserDescriptor(this.myRoot, chooseMultiple));
        JBLabel pathLabel = new JBLabel(DockerBundle.message("DockerFileChooser.emptyPathText", new Object[0]));
        pathLabel.setCopyable(true);
        this.myFileSystemTree.addListener(selection -> {
            @NlsSafe String labelText = selection.isEmpty() ? DockerBundle.message("DockerFileChooser.emptyPathText", new Object[0]) : this.myFileSystem.getPathInsideContainer((VirtualFile)selection.get(0));
            pathLabel.setText(labelText);
        }, this);
        JPanel pathPanel = new JPanel(new BorderLayout());
        pathPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)5));
        pathPanel.add((Component)pathLabel, "Center");
        this.add(pathPanel, "North");
        this.add(ScrollPaneFactory.createScrollPane((Component)this.getTree()), "Center");
        Disposer.register((Disposable)this, (Disposable)this.myFileSystemTree);
        if (runInitialized != null) {
            runInitialized.run();
        }
    }

    public void dispose() {
    }

    public JTree getTree() {
        return this.myFileSystemTree.getTree();
    }

    public void addOkAction(@NotNull Runnable action) {
        if (action == null) {
            DockerFileChooser.$$$reportNull$$$0(3);
        }
        this.myFileSystemTree.addOkAction(action);
    }

    public void refresh() {
        Tree tree = (Tree)this.getTree();
        tree.setPaintBusy(true);
        ++this.myBusyCounter;
        this.myFileSystem.refresh(true, () -> ApplicationManager.getApplication().invokeLater(() -> {
            --this.myBusyCounter;
            if (this.myBusyCounter == 0) {
                tree.setPaintBusy(false);
            }
        }));
    }

    @NotNull
    public RefreshAction createRefreshAction() {
        return new RefreshAction();
    }

    @Nullable
    public VirtualFile getSelectedFile() {
        return this.myFileSystemTree.getSelectedFile();
    }

    public VirtualFile @NotNull [] getSelectedFiles() {
        VirtualFile[] virtualFileArray = this.myFileSystemTree.getSelectedFiles();
        if (virtualFileArray == null) {
            DockerFileChooser.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    @Nullable
    public String getSelectedPath() {
        VirtualFile file2 = this.getSelectedFile();
        return file2 == null ? null : this.myFileSystem.getPathInsideContainer(file2);
    }

    @NotNull
    public List<String> getSelectedPaths() {
        Function mapping = this.myFileSystem::getPathInsideContainer;
        List list = ContainerUtil.map((Object[])this.getSelectedFiles(), (Function)mapping);
        if (list == null) {
            DockerFileChooser.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public String getSanitizedContainerName() {
        String string = this.myFileSystem.getSanitizedContainerName();
        if (string == null) {
            DockerFileChooser.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationRuntime";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadingPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/view/DockerFileChooser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/view/DockerFileChooser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSanitizedContainerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addOkAction";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class RefreshAction
    extends DumbAwareAction {
        RefreshAction() {
            super(DockerBundle.messagePointer("DockerFileChooser.RefreshAction.text", new Object[0]), DockerBundle.messagePointer("DockerFileChooser.RefreshAction.description", new Object[0]), AllIcons.Actions.Refresh);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(0);
            }
            DockerFileChooser.this.refresh();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/view/DockerFileChooser$RefreshAction", "actionPerformed"));
        }
    }

    private static class OurFileChooserDescriptor
    extends FileChooserDescriptor {
        OurFileChooserDescriptor(@NotNull VirtualFile root, boolean chooseMultiple) {
            if (root == null) {
                OurFileChooserDescriptor.$$$reportNull$$$0(0);
            }
            super(true, true, true, true, false, chooseMultiple);
            this.withRoots(new VirtualFile[]{root});
            this.withShowHiddenFiles(true);
        }

        public Icon getIcon(VirtualFile file2) {
            return OurFileChooserDescriptor.dressIcon((VirtualFile)file2, (Icon)IconUtil.getIcon((VirtualFile)file2, (int)0, null));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/docker/view/DockerFileChooser$OurFileChooserDescriptor", "<init>"));
        }
    }
}

