/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.stats;

import com.intellij.docker.view.DockerRuntimeEditorBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerUsageKind {
    public static String forActionPerformed(@NotNull AnAction action, @NotNull AnActionEvent event) {
        if (action == null) {
            DockerUsageKind.$$$reportNull$$$0(0);
        }
        if (event == null) {
            DockerUsageKind.$$$reportNull$$$0(1);
        }
        String withoutPlace = DockerUsageKind.forActionPerformed(action);
        ActionPlaceKind placeKind = ActionPlaceKind.getPlaceKind(event);
        return placeKind == null ? withoutPlace : withoutPlace + "." + placeKind.name();
    }

    public static String forRuntimeEditorSave(@NotNull DockerRuntimeEditorBase editor) {
        if (editor == null) {
            DockerUsageKind.$$$reportNull$$$0(2);
        }
        return "docker.tabs.save." + DockerUsageKind.trimClassSuffix(editor, "Editor");
    }

    private static String forActionPerformed(@NotNull AnAction action) {
        if (action == null) {
            DockerUsageKind.$$$reportNull$$$0(3);
        }
        return "docker.action." + DockerUsageKind.trimClassSuffix(action, "Action");
    }

    private static String trimClassSuffix(@NotNull Object subject, @NotNull String classSuffix) {
        if (subject == null) {
            DockerUsageKind.$$$reportNull$$$0(4);
        }
        if (classSuffix == null) {
            DockerUsageKind.$$$reportNull$$$0(5);
        }
        return StringUtil.trimEnd((String)subject.getClass().getSimpleName(), (String)classSuffix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classSuffix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/stats/DockerUsageKind";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forActionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "forRuntimeEditorSave";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "trimClassSuffix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum ActionPlaceKind {
        TOOLBAR("Toolbar"),
        POPUP("Popup");

        private final String mySuffix;

        private ActionPlaceKind(String suffix) {
            if (suffix == null) {
                ActionPlaceKind.$$$reportNull$$$0(0);
            }
            this.mySuffix = suffix;
        }

        public boolean matchesPlace(@NotNull String place) {
            if (place == null) {
                ActionPlaceKind.$$$reportNull$$$0(1);
            }
            return place.endsWith(this.mySuffix);
        }

        @Nullable
        public static ActionPlaceKind getPlaceKind(@NotNull AnActionEvent event) {
            if (event == null) {
                ActionPlaceKind.$$$reportNull$$$0(2);
            }
            return Arrays.stream(ActionPlaceKind.values()).filter(kind -> kind.matchesPlace(event.getPlace())).findAny().orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/docker/stats/DockerUsageKind$ActionPlaceKind";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchesPlace";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPlaceKind";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

