/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.DynamicBundle;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class DockerPortBindingConfigurable
implements Configurable {
    private JTextField myContainerPortTextField;
    private JPanel myMainPanel;
    private JComboBox myProtocolComboBox;
    private JTextField myHostIpTextField;
    private JTextField myHostPortTextField;
    private final DockerPortBindingImpl myPortBinding;

    public DockerPortBindingConfigurable(DockerPortBindingImpl portBinding) {
        this.myPortBinding = portBinding;
        this.$$$setupUI$$$();
    }

    @Nls
    public String getDisplayName() {
        return DockerBundle.message("configurable.DockerPortBindingConfigurable.display.name", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return true;
    }

    public void apply() throws ConfigurationException {
        Integer hostPort;
        int containerPort;
        String containerPortText = this.myContainerPortTextField.getText();
        if (StringUtil.isEmpty((String)containerPortText)) {
            throw new ConfigurationException(DockerBundle.message("DockerPortBindingConfigurable.error.container.port.required", new Object[0]));
        }
        try {
            containerPort = Integer.parseInt(containerPortText);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(DockerBundle.message("DockerPortBindingConfigurable.error.container.port.should.be.number", new Object[0]));
        }
        String hostPortText = this.myHostPortTextField.getText();
        if (StringUtil.isEmpty((String)hostPortText)) {
            hostPort = null;
        } else {
            try {
                hostPort = Integer.parseInt(hostPortText);
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(DockerBundle.message("DockerPortBindingConfigurable.error.host.port.should.be.number", new Object[0]));
            }
        }
        this.myPortBinding.setContainerPort(containerPort);
        this.myPortBinding.setProtocol((String)this.myProtocolComboBox.getSelectedItem());
        this.myPortBinding.setHostIp(this.myHostIpTextField.getText());
        this.myPortBinding.setHostPort(hostPort);
    }

    public void reset() {
        int containerPort = this.myPortBinding.getContainerPort();
        this.myContainerPortTextField.setText(containerPort == 0 ? "" : Integer.toString(containerPort));
        @NlsSafe String protocol = this.myPortBinding.getProtocol();
        this.myProtocolComboBox.setSelectedItem(protocol);
        this.myHostIpTextField.setText(this.myPortBinding.getHostIp());
        Integer hostPort = this.myPortBinding.getHostPort();
        this.myHostPortTextField.setText(hostPort == null ? "" : hostPort.toString());
    }

    public void disposeUIResources() {
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.docker.deploy.port-bindings";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JComboBox jComboBox;
        JTextField jTextField3;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerPortBindingConfigurable.class).getString("configurable.DockerPortBindingConfigurable.container.port.text"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myContainerPortTextField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerPortBindingConfigurable.class).getString("configurable.DockerPortBindingConfigurable.protocol.text"));
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProtocolComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("tcp");
        defaultComboBoxModel.addElement("udp");
        jComboBox.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerPortBindingConfigurable.class).getString("configurable.DockerPortBindingConfigurable.host.ip.text"));
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/DockerBundle", DockerPortBindingConfigurable.class).getString("configurable.DockerPortBindingConfigurable.host.port.text"));
        jPanel.add((Component)jBLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostIpTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myHostPortTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jBLabel.setLabelFor(jTextField3);
        jBLabel2.setLabelFor(jComboBox);
        jBLabel3.setLabelFor(jTextField2);
        jBLabel4.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

