/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.runtimes;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentStatus;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerUtil;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.docker.agent.settings.DockerSystemInfo;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.registry.DockerAgentRepositoryConfigImpl;
import com.intellij.docker.registry.DockerRepositoryModel;
import com.intellij.docker.registry.RegistryRuntimeTask;
import com.intellij.docker.runtimes.ComposeServiceRuntime;
import com.intellij.docker.runtimes.DockerParentRuntime;
import com.intellij.docker.runtimes.DockerRuntimeContext;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.runtime.ServerConnectionImpl;
import com.intellij.remoteServer.impl.runtime.deployment.DeploymentImpl;
import com.intellij.remoteServer.runtime.ConnectionStatus;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerApplicationRuntime
extends CloudApplicationRuntime {
    private static final Logger LOG = Logger.getInstance(DockerApplicationRuntime.class);
    private final DockerRuntimeContext myContext;
    private final AtomicBoolean myStatusChangedInternally;
    private volatile DockerParentRuntime myParent;
    private volatile DockerAgentApplication myAgentApplication;
    private volatile String[] myContainerNames;
    private volatile String myImageId;
    private volatile DockerDeploymentStatus myStatusWithCustomText;
    private volatile Set<String> myImageRepoTags;
    private volatile String myImageParentId;
    private volatile String myContainerId;

    public DockerApplicationRuntime(@NotNull DockerRuntimeContext context, @NotNull String uniqueName, @Nullable DockerParentRuntime parent) {
        if (context == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(0);
        }
        if (uniqueName == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(1);
        }
        super(uniqueName);
        this.myStatusChangedInternally = new AtomicBoolean();
        this.myContext = context;
        this.setParent(parent);
    }

    public DockerAgent getAgent() {
        return this.getRuntimeContext().getAgent();
    }

    @NotNull
    final DockerRuntimeContext getRuntimeContext() {
        DockerRuntimeContext dockerRuntimeContext = this.myContext;
        if (dockerRuntimeContext == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(2);
        }
        return dockerRuntimeContext;
    }

    @NotNull
    protected DockerCloudConfiguration getServerConfiguration() {
        DockerCloudConfiguration dockerCloudConfiguration = this.myContext.getServerConfiguration();
        if (dockerCloudConfiguration == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(3);
        }
        return dockerCloudConfiguration;
    }

    protected ServerTaskExecutor getTaskExecutor() {
        return this.myContext.getServerExecutor();
    }

    public AgentTaskExecutor getAgentTaskExecutor() {
        return this.myContext.getAgentExecutor();
    }

    @Nullable
    public DeploymentLogManager getDeploymentLogManager(@NotNull Project project) {
        Deployment deployment;
        if (project == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(4);
        }
        return (deployment = this.getDeploymentModel()) == null ? null : deployment.getOrCreateLogManager(project);
    }

    protected ServerType<?> getCloudType() {
        return DockerCloudType.getInstance();
    }

    void setApplication(DockerAgentApplication agentApplication) {
        this.myAgentApplication = agentApplication;
        this.myContainerId = agentApplication.getContainerId();
        this.myContainerNames = agentApplication.getContainerNames();
        this.myImageId = agentApplication.getImageId();
        this.myImageParentId = agentApplication.getImageParentId();
        @NlsSafe String statusText = agentApplication.getAgentApplicationStatus();
        if (this.myContainerId != null) {
            this.myStatusWithCustomText = DockerDeploymentStatus.newContainerStatus(statusText);
        } else {
            this.myStatusWithCustomText = DockerDeploymentStatus.newImageStatus(statusText == null ? "" : statusText);
            this.myImageRepoTags = ContainerUtil.set((Object[])agentApplication.getImageRepoTags());
        }
        this.checkAndClearInternalChangeStatus();
        this.setupDeploymentPresentableName();
    }

    public String getContainerId() {
        return this.myAgentApplication != null ? this.myContainerId : null;
    }

    public String @Nullable [] getContainerNames() {
        return this.myContainerNames;
    }

    public String getContainerName() {
        return this.myContainerNames == null || this.myContainerNames.length == 0 ? null : new TreeSet<String>(Arrays.asList(this.myContainerNames)).first();
    }

    public void setDeploymentModel(@NotNull Deployment deployment) {
        if (deployment == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(5);
        }
        super.setDeploymentModel(deployment);
        this.setupDeploymentPresentableName();
    }

    protected void setupDeploymentPresentableName() {
        if (this.myAgentApplication == null) {
            return;
        }
        Deployment deployment = this.getDeploymentModel();
        if (deployment instanceof DeploymentImpl) {
            ((DeploymentImpl)deployment).setPresentableName(this.getPresentableName());
        }
    }

    @Nullable
    @NlsSafe
    public final String getPresentableName() {
        return this.myAgentApplication.getPresentableName();
    }

    public String getImageId() {
        return this.myImageId;
    }

    @NotNull
    public Set<String> getImageRepoTags() {
        Set set = Optional.ofNullable(this.myImageRepoTags).map(HashSet::new).orElse(new HashSet());
        if (set == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(6);
        }
        return set;
    }

    public String getImageParentId() {
        return this.myImageParentId;
    }

    @Nullable
    public DeploymentStatus getStatus() {
        return this.myStatusWithCustomText == null ? null : this.myStatusWithCustomText.getStatus();
    }

    boolean checkAndClearInternalChangeStatus() {
        return this.myStatusChangedInternally.getAndSet(false);
    }

    private void internalChangeStatus(@Nullable DockerDeploymentStatus newStatus) {
        if (newStatus != null) {
            this.myStatusWithCustomText = newStatus;
            this.myStatusChangedInternally.set(true);
        }
        this.myStatusWithCustomText.apply(this.getDeploymentModel());
    }

    @Nullable
    public String getStatusText() {
        return this.myStatusWithCustomText == null ? null : this.myStatusWithCustomText.getCustomText();
    }

    @Nullable
    public CloudApplicationRuntime getParent() {
        return this.myParent == null ? null : this.myParent.asDockerRuntime();
    }

    @Nullable
    public final Navigatable computeNavigatable(@NotNull Project project) {
        DockerRuntimeNavigatable navigatable;
        if (project == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(7);
        }
        return (navigatable = this.computeRuntimeNavigatable(project)) == null ? null : navigatable.getNavigatable();
    }

    @Nullable
    public final VirtualFile computeVirtualFile(@NotNull Project project) {
        DockerRuntimeNavigatable navigatable;
        if (project == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(8);
        }
        return (navigatable = this.computeRuntimeNavigatable(project)) == null ? null : navigatable.getVirtualFile();
    }

    @Nullable
    protected DockerRuntimeNavigatable computeRuntimeNavigatable(@NotNull Project project) {
        CloudApplicationRuntime parent;
        if (project == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(9);
        }
        if (this.getContainerId() != null && (parent = this.getParent()) instanceof ComposeServiceRuntime) {
            return ((ComposeServiceRuntime)parent).computeRuntimeNavigatable(project);
        }
        return null;
    }

    public void setParent(@Nullable DockerParentRuntime parent) {
        if (this.myParent != null) {
            this.myParent.childRemoved(this);
        }
        this.myParent = parent;
        if (this.myParent != null) {
            this.myParent.childAdded(this);
        }
    }

    public void startContainer() {
        new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.startContainer();
            }
        }.run(DockerDeploymentStatus.STARTING, DockerDeploymentStatus.STARTED);
    }

    public void stopContainer() {
        new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.stopContainer();
            }
        }.run(DockerDeploymentStatus.STOPPING, DockerDeploymentStatus.STOPPED);
    }

    public void deleteContainer() {
        Deployment deployment = this.getDeploymentModel();
        String deploymentName = deployment == null ? null : deployment.getName();
        ServerConnection connection = deployment == null ? null : deployment.getConnection();
        StatusChangingTask deleteTask = new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.deleteContainer();
            }
        };
        deleteTask.run(DockerDeploymentStatus.DELETING, DockerDeploymentStatus.DELETED).thenRunAsync(() -> {
            if (connection instanceof ServerConnectionImpl && connection.getStatus() == ConnectionStatus.CONNECTED) {
                ((ServerConnectionImpl)connection).disposeAllLogs(deploymentName);
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    public void showLog(Project project, Runnable onDone) {
        new CloudApplicationRuntime.LoggingTask(){

            protected void run(CloudAgentLoggingHandler loggingHandler) {
                DockerApplicationRuntime.this.myAgentApplication.showLog(loggingHandler);
            }
        }.perform(project, onDone);
    }

    public CompletableFuture<String> promiseInspectJson() {
        return this.makeAgentPromise(() -> ((DockerAgentApplication)this.myAgentApplication).computeInspectJson());
    }

    public CompletableFuture<String> promiseProcessesJson() {
        return this.makeAgentPromise(() -> ((DockerAgentApplication)this.myAgentApplication).computeProcessesJson());
    }

    public CompletableFuture<DockerSystemInfo> promiseSystemInfo() {
        return this.makeAgentPromise(() -> ((DockerAgentApplication)this.myAgentApplication).getSystemInfo());
    }

    protected final <T> CompletableFuture<T> makeAgentPromise(@NotNull Computable<? extends T> agentComputable) {
        if (agentComputable == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(10);
        }
        CompletableFuture result = new CompletableFuture();
        this.getTaskExecutor().submit(() -> {
            try {
                Object agentResult = this.getAgentTaskExecutor().execute(agentComputable);
                result.complete(agentResult);
            }
            catch (ServerRuntimeException e) {
                result.completeExceptionally(e);
            }
        });
        return result;
    }

    public Void reportError(Throwable ex) {
        LOG.debug(ex);
        this.getCloudNotifier().showMessage(ex.getMessage(), MessageType.ERROR);
        return null;
    }

    public CompletableFuture<DockerAgentContainerInspection> promiseInspect() {
        return this.makeAgentPromise(() -> this.myAgentApplication.inspect());
    }

    public void attach(Project project, Runnable onDone) {
        new CloudApplicationRuntime.LoggingTask(){

            protected void run(CloudAgentLoggingHandler loggingHandler) {
                DockerApplicationRuntime.this.myAgentApplication.attach(loggingHandler, true);
            }
        }.perform(project, onDone);
    }

    public void exec(Project project, final String command, final String logName, Runnable onDone) {
        new CloudApplicationRuntime.LoggingTask(){

            protected void run(CloudAgentLoggingHandler loggingHandler) {
                DockerApplicationRuntime.this.myAgentApplication.exec(loggingHandler, ParametersListUtil.parseToArray((String)command), logName);
            }
        }.perform(project, onDone);
    }

    public CompletableFuture<byte[]> captureExecOutput(String @NotNull [] command, boolean includeErr) {
        if (command == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(11);
        }
        return this.myAgentApplication.captureExecOutput(command, includeErr);
    }

    public void deleteImage() {
        new StatusChangingTask(){

            @Override
            protected void doAgentTask() {
                DockerApplicationRuntime.this.myAgentApplication.deleteImage();
            }
        }.run(DockerDeploymentStatus.DELETING, DockerDeploymentStatus.DELETED);
    }

    public CompletableFuture<String> createContainer() {
        return this.makeAgentPromise(() -> this.myAgentApplication.createContainer()).exceptionally(e -> {
            this.reportError((Throwable)e);
            return null;
        });
    }

    public boolean isUndeploySupported() {
        return false;
    }

    public void undeploy(@NotNull DeploymentRuntime.UndeploymentTaskCallback callback) {
        if (callback == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(12);
        }
        throw new UnsupportedOperationException();
    }

    public void pushImage(Project project, DockerRepositoryModel repositoryModel) {
        final DockerAgentRepositoryConfigImpl repositoryConfig = new DockerAgentRepositoryConfigImpl(repositoryModel);
        @NlsSafe String qualifiedReference = repositoryConfig.getQualifiedTag();
        new RegistryRuntimeTask(){

            @Override
            protected OngoingProcess doPerform(DockerAgentProgressCallback progressCallback) {
                return DockerApplicationRuntime.this.myAgentApplication.pushImage(repositoryConfig, progressCallback);
            }
        }.performAsyncWithNotification(project, this.getTaskExecutor(), this.getAgentTaskExecutor(), DockerBundle.message("DockerApplicationRuntime.progress.message.pushing", qualifiedReference), DockerBundle.message("DockerApplicationRuntime.progress.message.pushed.successfully", qualifiedReference));
    }

    @NotNull
    public CompletableFuture<DockerAgentApplication.ContainerUpdateResult> updateContainer(@NotNull DockerAgentContainerConfig config) {
        if (config == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(13);
        }
        CompletableFuture<DockerAgentApplication.ContainerUpdateResult> completableFuture = this.makeAgentPromise(() -> {
            DockerAgentApplication.ContainerUpdateResult updateResult = this.myAgentApplication.updateContainer(config);
            this.handleContainerUpdateResult(updateResult);
            return updateResult;
        });
        if (completableFuture == null) {
            DockerApplicationRuntime.$$$reportNull$$$0(14);
        }
        return completableFuture;
    }

    protected final void handleContainerUpdateResult(@Nullable DockerAgentApplication.ContainerUpdateResult updateResult) {
        if (updateResult == null) {
            return;
        }
        String oldId = updateResult.getRemovedContainerId();
        String newId = updateResult.getCreatedContainerId();
        if (!StringUtil.equals((CharSequence)oldId, (CharSequence)this.getContainerId())) {
            return;
        }
        DockerAgentApplication newAgentApp = updateResult.getCreatedAgentApplication();
        if (newAgentApp != null && oldId != null && newId != null && !newId.equals(oldId)) {
            this.setApplication(newAgentApp);
        }
    }

    public String toString() {
        String hash = Optional.ofNullable(this.getApplicationName()).map(DockerUtil::shortedId).orElse(null);
        return "@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + " id: " + hash + ", " + (this.myContainerId == null ? "[IMG]: " + this.getImageRepoTags() : "[CNT]: " + Arrays.toString(this.getContainerNames()));
    }

    public DockerAgentApplication getAgentApplication() {
        return this.myAgentApplication;
    }

    @Nullable
    public RemoteServer<?> getServer() {
        Deployment deployment = this.getDeploymentModel();
        if (deployment == null) {
            return null;
        }
        return deployment.getConnection().getServer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueName";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/runtimes/DockerApplicationRuntime";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentComputable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/runtimes/DockerApplicationRuntime";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageRepoTags";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "updateContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentLogManager";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setDeploymentModel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeNavigatable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeVirtualFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeRuntimeNavigatable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "makeAgentPromise";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "captureExecOutput";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "undeploy";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateContainer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class DockerRuntimeVirtualFileNavigatable
    implements DockerRuntimeNavigatable {
        private final Project myProject;
        private final VirtualFile myVirtualFile;

        DockerRuntimeVirtualFileNavigatable(@NotNull Project project, @NotNull VirtualFile virtualFile) {
            if (project == null) {
                DockerRuntimeVirtualFileNavigatable.$$$reportNull$$$0(0);
            }
            if (virtualFile == null) {
                DockerRuntimeVirtualFileNavigatable.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myVirtualFile = virtualFile;
        }

        @Override
        @NotNull
        public Navigatable getNavigatable() {
            Navigatable navigatable = PsiNavigationSupport.getInstance().createNavigatable(this.myProject, this.myVirtualFile, 0);
            if (navigatable == null) {
                DockerRuntimeVirtualFileNavigatable.$$$reportNull$$$0(2);
            }
            return navigatable;
        }

        @Override
        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myVirtualFile;
            if (virtualFile == null) {
                DockerRuntimeVirtualFileNavigatable.$$$reportNull$$$0(3);
            }
            return virtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/runtimes/DockerApplicationRuntime$DockerRuntimeVirtualFileNavigatable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/runtimes/DockerApplicationRuntime$DockerRuntimeVirtualFileNavigatable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static interface DockerRuntimeNavigatable {
        @NotNull
        public Navigatable getNavigatable();

        @Nullable
        public VirtualFile getVirtualFile();
    }

    private abstract class StatusChangingTask
    extends StatusChangingAgentComputable<Void> {
        private StatusChangingTask() {
        }

        @Override
        public CompletableFuture<Void> run(DockerDeploymentStatus transitionStatus, DockerDeploymentStatus targetStatus) {
            CompletableFuture mayFail = super.run(transitionStatus, targetStatus);
            return mayFail.exceptionally(DockerApplicationRuntime.this::reportError);
        }

        @Override
        protected Void computeOnAgent() {
            this.doAgentTask();
            return null;
        }

        protected abstract void doAgentTask();
    }

    private abstract class StatusChangingAgentComputable<T> {
        private StatusChangingAgentComputable() {
        }

        public CompletableFuture<T> run(DockerDeploymentStatus transitionStatus, DockerDeploymentStatus targetStatus) {
            transitionStatus.apply(DockerApplicationRuntime.this.getDeploymentModel());
            CompletableFuture result = DockerApplicationRuntime.this.makeAgentPromise(this::computeOnAgent);
            return result.whenComplete((agentResult, failure) -> DockerApplicationRuntime.this.internalChangeStatus(targetStatus));
        }

        protected abstract T computeOnAgent();
    }
}

