/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.intellij.docker.remote.run.runtime.TarCompressionUtil;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a+\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0000\u001a \u0010\u0012\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0010*\u00020\u0006H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\";\u0010\u0003\u001a/\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0001\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\")\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"BZIP2", "", "", "COMPRESSION_STRATEGIES", "", "Lkotlin/Function1;", "Ljava/io/InputStream;", "Lkotlin/ParameterName;", "name", "inputStream", "GZIP", "MAX_HEADER_SIZE", "", "UNCOMPRESSED_STRATEGY", "XZ", "findCompressionStrategy", "Ljava/io/BufferedInputStream;", "uncompressStream", "startsWith", "", "bytes", "toBufferedInputStream", "intellij.clouds.docker"})
@JvmName(name="TarCompressionUtil")
public final class TarCompressionUtil {
    private static final List<Byte> BZIP2;
    private static final List<Byte> GZIP;
    private static final List<Byte> XZ;
    private static final Map<List<Byte>, Function1<InputStream, InputStream>> COMPRESSION_STRATEGIES;
    private static final int MAX_HEADER_SIZE;
    private static final Function1<InputStream, InputStream> UNCOMPRESSED_STRATEGY;

    @NotNull
    public static final InputStream uncompressStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Function1<InputStream, InputStream> compressionStrategy = TarCompressionUtil.findCompressionStrategy(TarCompressionUtil.toBufferedInputStream(inputStream));
        return (InputStream)compressionStrategy.invoke((Object)inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Function1<InputStream, InputStream> findCompressionStrategy(@NotNull BufferedInputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        inputStream.mark(MAX_HEADER_SIZE + 1);
        try {
            Object object;
            byte[] buffer = new byte[MAX_HEADER_SIZE];
            int readSize = IOUtils.read((InputStream)inputStream, (byte[])buffer);
            if (readSize <= 0) {
                Function1<InputStream, InputStream> function1 = UNCOMPRESSED_STRATEGY;
                return function1;
            }
            List<Byte> bufferList = ArraysKt.toList((byte[])buffer).subList(0, readSize);
            Object object2 = COMPRESSION_STRATEGIES;
            boolean bl = false;
            Iterator<Map.Entry<List<Byte>, Function1<InputStream, InputStream>>> iterator = object2.entrySet().iterator();
            while (iterator.hasNext()) {
                void bytes;
                Object object3 = object = iterator.next();
                boolean bl2 = false;
                object2 = (List)object3.getKey();
                object3 = object;
                bl2 = false;
                Function1 result = (Function1)object3.getValue();
                if (!TarCompressionUtil.startsWith(bufferList, (List<Byte>)bytes)) continue;
                object3 = result;
                return object3;
            }
            object = UNCOMPRESSED_STRATEGY;
            return object;
        }
        finally {
            inputStream.reset();
        }
    }

    public static final boolean startsWith(@NotNull List<Byte> $this$startsWith, @NotNull List<Byte> bytes) {
        Intrinsics.checkNotNullParameter($this$startsWith, (String)"$this$startsWith");
        Intrinsics.checkNotNullParameter(bytes, (String)"bytes");
        return bytes.size() <= $this$startsWith.size() && Intrinsics.areEqual($this$startsWith.subList(0, bytes.size()), bytes);
    }

    @NotNull
    public static final BufferedInputStream toBufferedInputStream(@NotNull InputStream $this$toBufferedInputStream) {
        BufferedInputStream bufferedInputStream;
        Intrinsics.checkNotNullParameter((Object)$this$toBufferedInputStream, (String)"$this$toBufferedInputStream");
        InputStream inputStream = $this$toBufferedInputStream;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = null;
        }
        if ((bufferedInputStream = (BufferedInputStream)inputStream) == null) {
            bufferedInputStream = new BufferedInputStream($this$toBufferedInputStream);
        }
        return bufferedInputStream;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        BZIP2 = CollectionsKt.listOf((Object[])new Byte[]{(byte)66, (byte)90, (byte)104});
        GZIP = CollectionsKt.listOf((Object[])new Byte[]{(byte)31, (byte)139, (byte)8});
        XZ = CollectionsKt.listOf((Object[])new Byte[]{(byte)253, (byte)55, (byte)122, (byte)88, (byte)90, (byte)0});
        COMPRESSION_STRATEGIES = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to(BZIP2, (Object)((Object)COMPRESSION_STRATEGIES.1.INSTANCE)), TuplesKt.to(GZIP, (Object)((Object)COMPRESSION_STRATEGIES.2.INSTANCE)), TuplesKt.to(XZ, (Object)((Object)COMPRESSION_STRATEGIES.3.INSTANCE))});
        Map<List<Byte>, Function1<InputStream, InputStream>> $this$map$iv = COMPRESSION_STRATEGIES;
        boolean $i$f$map = false;
        Map<List<Byte>, Function1<InputStream, InputStream>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var5_5 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var5_5.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Integer n = ((List)it.getKey()).size();
            collection.add(n);
        }
        Integer n = (Integer)CollectionsKt.max((Iterable)((List)var3_3));
        MAX_HEADER_SIZE = n != null ? n : 0;
        UNCOMPRESSED_STRATEGY = UNCOMPRESSED_STRATEGY.1.INSTANCE;
    }
}

