/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.remote.run.runtime.TarCompressionUtil;
import com.intellij.docker.remote.run.runtime.WrappedConflictException;
import com.intellij.docker.remote.run.runtime.WrappedInternalServerErrorException;
import com.intellij.docker.remote.run.runtime.WrappedNotFoundException;
import com.intellij.docker.remote.run.runtime.WrappedNotModifiedException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableConsumer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteDockerRuntimeUtil {
    private static final Logger LOG = Logger.getInstance(RemoteDockerRuntimeUtil.class);

    public static void download(@NotNull DockerAgentApplication application, @NotNull AgentTaskExecutor agentExecutor, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Map<String, String> remoteToLocalPathName, @Nullable String machineName) throws IOException, ServerRuntimeException {
        if (application == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(0);
        }
        if (agentExecutor == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(1);
        }
        if (resourcePath == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(2);
        }
        if (targetFile == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(3);
        }
        RemoteDockerRuntimeUtil.download(application, agentExecutor, resourcePath, targetFile, remoteToLocalPathName == null ? null : remoteToLocalPathName::get, machineName);
    }

    public static void download(@NotNull DockerAgentApplication application, @NotNull AgentTaskExecutor agentExecutor, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Function<String, String> remoteToLocalMapping, @Nullable String machineName) throws IOException, ServerRuntimeException {
        if (application == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(4);
        }
        if (agentExecutor == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(5);
        }
        if (resourcePath == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(6);
        }
        if (targetFile == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(7);
        }
        RemoteDockerRuntimeUtil.download(application, agentExecutor, resourcePath, machineName, (ThrowableConsumer<? super File, ? extends IOException>)((ThrowableConsumer)tarFile -> RemoteDockerRuntimeUtil.extractTar(tarFile, resourcePath, targetFile, remoteToLocalMapping)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void download(@NotNull DockerAgentApplication application, @NotNull AgentTaskExecutor agentExecutor, @NotNull String resourcePath, @Nullable String machineName, @NotNull ThrowableConsumer<? super File, ? extends IOException> extractor) throws IOException, ServerRuntimeException {
        if (application == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(8);
        }
        if (agentExecutor == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(9);
        }
        if (resourcePath == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(10);
        }
        if (extractor == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(11);
        }
        File tarFile = FileUtil.createTempFile((String)String.valueOf(application.getContainerId().hashCode()), (String)".download.tar");
        try {
            try (FileOutputStream tarOutputStream = new FileOutputStream(tarFile);){
                LOG.debug("Downloading '", new Object[]{resourcePath, "' resource from Docker container '", application.getContainerId(), "' created at Docker machine ", "'", machineName, "' to '", tarFile.getAbsolutePath(), "'"});
                try (InputStream requestInputStream = (InputStream)RemoteDockerRuntimeUtil.executeAgentTask(agentExecutor, () -> application.copyArchiveFromContainer(resourcePath));){
                    long size = IOUtils.copy((InputStream)requestInputStream, (OutputStream)tarOutputStream);
                    LOG.debug("Downloaded ", new Object[]{size, " bytes from container '", application.getContainerId(), "' to '", tarFile.getAbsolutePath(), "'"});
                }
            }
            extractor.consume((Object)tarFile);
            if (tarFile.delete()) return;
        }
        catch (Throwable throwable) {
            if (tarFile.delete()) throw throwable;
            LOG.debug("Failed to delete temporary tar file '", new Object[]{tarFile.getPath(), "'"});
            throw throwable;
        }
        LOG.debug("Failed to delete temporary tar file '", new Object[]{tarFile.getPath(), "'"});
    }

    public static <T> T executeAgentTask(@NotNull AgentTaskExecutor agentExecutor, @NotNull Computable<T> computable) throws ServerRuntimeException {
        if (agentExecutor == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(12);
        }
        if (computable == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(13);
        }
        try {
            return (T)agentExecutor.execute(computable);
        }
        catch (ServerRuntimeException e) {
            String message = StringUtil.notNullize((String)e.getMessage());
            if (message.contains("NotFoundException")) {
                throw new WrappedNotFoundException(message);
            }
            if (message.contains("InternalServerErrorException")) {
                throw new WrappedInternalServerErrorException(message);
            }
            if (message.contains("NotModifiedException")) {
                throw new WrappedNotModifiedException(message);
            }
            if (message.contains("ConflictException")) {
                throw new WrappedConflictException(message);
            }
            throw e;
        }
    }

    public static void extractTar(@NotNull File tarFile, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Function<String, String> remoteToLocalMapping) throws IOException {
        if (tarFile == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(14);
        }
        if (resourcePath == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(15);
        }
        if (targetFile == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(16);
        }
        LOG.debug("Extracting '", new Object[]{tarFile.getAbsoluteFile(), "' to '", targetFile.getPath(), "'"});
        RemoteDockerRuntimeUtil.extractTar((InputStream)new BufferedInputStream(new FileInputStream(tarFile)), resourcePath, targetFile, remoteToLocalMapping);
    }

    public static void extractTar(@NotNull InputStream inputStream, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Map<String, String> remoteToLocalPathName) throws IOException {
        if (inputStream == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(17);
        }
        if (resourcePath == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(18);
        }
        if (targetFile == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(19);
        }
        RemoteDockerRuntimeUtil.extractTar(inputStream, resourcePath, targetFile, remoteToLocalPathName == null ? null : remoteToLocalPathName::get);
    }

    private static void extractTar(@NotNull InputStream inputStream, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Function<String, String> remoteToLocalMapping) throws IOException {
        if (inputStream == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(20);
        }
        if (resourcePath == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(21);
        }
        if (targetFile == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(22);
        }
        try (TarArchiveInputStream tarInputStream = new TarArchiveInputStream(TarCompressionUtil.uncompressStream(inputStream));){
            TarArchiveEntry tarEntry = tarInputStream.getNextTarEntry();
            while (tarEntry != null) {
                if ((tarEntry.isFile() || tarEntry.isDirectory()) && StringUtil.isNotEmpty((String)tarEntry.getName())) {
                    if (remoteToLocalMapping == null) {
                        String localPathName = RemoteDockerRuntimeUtil.replacePathPrefix(tarEntry.getName(), targetFile.getName());
                        RemoteDockerRuntimeUtil.copyTarEntry(tarInputStream, tarEntry, targetFile.getParentFile(), localPathName);
                    } else {
                        String parentSourceDirPath = PathUtil.getParentPath((String)resourcePath);
                        String remotePathName = FileUtil.toCanonicalPath((String)StringUtil.join((String[])new String[]{parentSourceDirPath, tarEntry.getName()}, (String)"/"), (char)'/');
                        String localPathName = (String)remoteToLocalMapping.fun((Object)remotePathName);
                        if (localPathName != null) {
                            RemoteDockerRuntimeUtil.copyTarEntry(tarInputStream, tarEntry, targetFile, localPathName);
                        } else {
                            LOG.debug("Remote file '" + remotePathName + "' skipped");
                        }
                    }
                }
                tarEntry = tarInputStream.getNextTarEntry();
            }
        }
    }

    @NotNull
    public static String replacePathPrefix(@NotNull String path, @NotNull String newPrefix) {
        int index;
        if (path == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(23);
        }
        if (newPrefix == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(24);
        }
        if ((index = path.indexOf(47)) == -1) {
            index = path.length();
        }
        String string = newPrefix + path.substring(index);
        if (string == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static void copyTarEntry(TarArchiveInputStream tarInputStream, TarArchiveEntry tarEntry, File targetDir, String localPathName) throws IOException {
        if (SystemInfo.isWindows && localPathName.contains("\\")) {
            LOG.info("Extraction path '" + localPathName + "' contains backslashes, which will be treated as path separators");
        }
        if (tarEntry.isFile()) {
            RemoteDockerRuntimeUtil.copyStreamToFile((InputStream)tarInputStream, new File(targetDir, localPathName));
        } else if (tarEntry.isDirectory()) {
            new File(targetDir, localPathName).mkdirs();
        }
    }

    private static void copyStreamToFile(@NotNull InputStream inputStream, @NotNull File outputFile) throws IOException {
        if (inputStream == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(26);
        }
        if (outputFile == null) {
            RemoteDockerRuntimeUtil.$$$reportNull$$$0(27);
        }
        if (outputFile.getParentFile() != null && !outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
            LOG.warn("Failed to create parent directories for file '" + outputFile + "' it will be skipped");
        } else {
            try (FileOutputStream entryOutputStream = new FileOutputStream(outputFile);){
                IOUtils.copy((InputStream)inputStream, (OutputStream)entryOutputStream);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agentExecutor";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 3: 
            case 7: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tarFile";
                break;
            }
            case 17: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPrefix";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/runtime/RemoteDockerRuntimeUtil";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/runtime/RemoteDockerRuntimeUtil";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "replacePathPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeAgentTask";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractTar";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "replacePathPrefix";
                break;
            }
            case 25: {
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "copyStreamToFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

