/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.intellij.docker.DockerAgentPathMapperImpl;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentDeployment;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.DockerAgentPathMapper;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.docker.agent.settings.DockerSystemInfo;
import com.intellij.docker.remote.run.runtime.InputStreamConsumer;
import com.intellij.docker.remote.run.runtime.RemoteDockerCloudLoggingHandler;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntimeUtil;
import com.intellij.docker.remote.run.runtime.WrappedNotFoundException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteDockerApplicationRuntime {
    private static final Logger LOG = Logger.getInstance(RemoteDockerApplicationRuntime.class);
    private final RemoteDockerRuntime myRuntime;
    private final RemoteDockerCloudLoggingHandler myLoggingHandler;
    private DockerAgentApplication myApplication;

    private RemoteDockerApplicationRuntime(RemoteDockerRuntime runtime, DockerAgentApplication application) {
        this(runtime);
        this.myApplication = application;
    }

    private RemoteDockerApplicationRuntime(RemoteDockerRuntime runtime) {
        this.myRuntime = runtime;
        this.myLoggingHandler = new RemoteDockerCloudLoggingHandler(runtime.getProject());
    }

    public static RemoteDockerApplicationRuntime create(RemoteDockerRuntime runtime, DockerAgentApplication application) {
        return new RemoteDockerApplicationRuntime(runtime, application);
    }

    public static RemoteDockerApplicationRuntime create(RemoteDockerRuntime runtime, DockerAgentDeploymentConfig config) throws ServerRuntimeException {
        RemoteDockerApplicationRuntime result = new RemoteDockerApplicationRuntime(runtime);
        result.create(config, runtime.getProject());
        return result;
    }

    public void start() throws ServerRuntimeException {
        this.executeAgentTask(() -> {
            this.myApplication.startContainer();
            return null;
        });
    }

    public void attach() throws ServerRuntimeException {
        this.executeAgentTask(() -> {
            this.myApplication.attach((CloudAgentLoggingHandler)this.myLoggingHandler);
            return null;
        });
    }

    public void startAndAttach() throws ServerRuntimeException {
        this.attach();
        this.start();
    }

    @NotNull
    public ProcessOutput exec(String @NotNull [] command) throws IOException, ServerRuntimeException {
        if (command == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(0);
        }
        RemoteDockerCloudLoggingHandler loggingHandler = new RemoteDockerCloudLoggingHandler(this.myRuntime.getProject());
        this.executeAgentTask(() -> {
            this.myApplication.exec((CloudAgentLoggingHandler)loggingHandler, command, null, false);
            return null;
        });
        return RemoteDockerApplicationRuntime.consumeLogsToProcessOutput(loggingHandler);
    }

    private DockerAgentDeployment create(DockerAgentDeploymentConfig config, Project project) throws ServerRuntimeException {
        String containerName;
        String imageTag;
        Object pathMapper = project == null ? new DockerAgentPathMapper(){

            public String expandPath(String path) {
                return path;
            }

            public String collapsePath(String path) {
                return path;
            }
        } : new DockerAgentPathMapperImpl(project);
        DockerAgentDeployment deployment = (DockerAgentDeployment)this.executeAgentTask(() -> this.lambda$create$3(config, (DockerAgentPathMapper)pathMapper));
        this.myApplication = deployment;
        String displayName = config.isBuildImageOnly() ? (StringUtil.isEmptyOrSpaces((String)(imageTag = (String)ArrayUtil.getFirstElement((Object[])config.getImageTags()))) ? "untagged image" : imageTag) : (StringUtil.isEmptyOrSpaces((String)(containerName = config.getContainerName())) ? "untagged container" : containerName);
        this.executeAgentTask(() -> {
            deployment.deploy(displayName);
            return null;
        });
        return deployment;
    }

    public ProcessOutput startAndGetOutput() throws ServerRuntimeException, IOException {
        try {
            this.startAndAttach();
            ProcessOutput processOutput = this.wait4AndGetOutput();
            return processOutput;
        }
        finally {
            this.removeContainerWithVolumes();
        }
    }

    public void removeContainer() {
        try {
            this.executeAgentTask(() -> {
                this.myApplication.deleteContainer();
                return null;
            });
        }
        catch (ServerRuntimeException e) {
            LOG.info(e.getMessage());
        }
    }

    public void removeImage() {
        try {
            this.executeAgentTask(() -> {
                this.myApplication.deleteImage();
                return null;
            });
        }
        catch (ServerRuntimeException e) {
            LOG.info(e.getMessage());
        }
    }

    public void removeContainerWithVolumes() {
        try {
            this.executeAgentTask(() -> {
                this.myApplication.deleteContainerWithVolumes();
                return null;
            });
        }
        catch (ServerRuntimeException e) {
            LOG.info(e.getMessage());
        }
    }

    private void stopContainerImmediate() {
        try {
            this.executeAgentTask(() -> {
                this.myApplication.stopContainerImmediate(arg_0 -> ((Logger)LOG).info(arg_0));
                return null;
            });
        }
        catch (ServerRuntimeException e) {
            LOG.info(e.getMessage());
        }
    }

    public <T> T executeAgentTask(Computable<T> computable) throws ServerRuntimeException {
        return this.myRuntime.executeAgentTask(computable);
    }

    public InputStream getStdout() {
        return this.myLoggingHandler.getTerminalOutput();
    }

    public InputStream getStderr() {
        return this.myLoggingHandler.getStderr();
    }

    public OutputStream getStdin() {
        return this.myLoggingHandler.getTerminalInput();
    }

    public void wait4terminal() {
        this.myLoggingHandler.wait4();
    }

    public int wait4Exit() throws ServerRuntimeException {
        return (Integer)this.executeAgentTask(() -> this.myApplication.waitForExit());
    }

    public ProcessOutput wait4AndGetOutput() throws IOException, ServerRuntimeException {
        ProcessOutput result = new ProcessOutput();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        InputStreamConsumer stdoutConsumer = InputStreamConsumer.consume(this.myLoggingHandler.getTerminalOutput());
        InputStreamConsumer stderrConsumer = InputStreamConsumer.consume(this.myLoggingHandler.getStderr());
        if (indicator instanceof ProgressIndicatorEx) {
            ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void cancel() {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> RemoteDockerApplicationRuntime.this.stopContainerImmediate());
                }
            });
        }
        int exitCode = this.wait4Exit();
        result.setExitCode(exitCode);
        result.appendStdout(stdoutConsumer.wait4Result());
        result.appendStderr(stderrConsumer.wait4Result());
        return result;
    }

    @NotNull
    private static ProcessOutput consumeLogsToProcessOutput(@NotNull RemoteDockerCloudLoggingHandler loggingHandler) throws IOException {
        if (loggingHandler == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(1);
        }
        ProcessOutput result = new ProcessOutput();
        InputStreamConsumer stdoutConsumer = InputStreamConsumer.consume(loggingHandler.getTerminalOutput());
        InputStreamConsumer stderrConsumer = InputStreamConsumer.consume(loggingHandler.getStderr());
        int exitCode = 0;
        result.setExitCode(exitCode);
        result.appendStdout(stdoutConsumer.wait4Result());
        result.appendStderr(stderrConsumer.wait4Result());
        ProcessOutput processOutput = result;
        if (processOutput == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(2);
        }
        return processOutput;
    }

    public DockerAgentContainerInspection inspect() throws ServerRuntimeException {
        return (DockerAgentContainerInspection)this.executeAgentTask(() -> this.myApplication.inspect());
    }

    public DockerSystemInfo getSystemInfo() throws ServerRuntimeException {
        return (DockerSystemInfo)this.executeAgentTask(() -> this.myApplication.getSystemInfo());
    }

    public RemoteDockerRuntime getDockerRuntime() {
        return this.myRuntime;
    }

    public DockerAgent getAgent() {
        return this.myRuntime.getAgent();
    }

    public DockerAgentApplication getAgentApplication() {
        return this.myApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadDirectoryAndRemove(String sourceDirPath, File targetDir, Map<String, String> remoteToLocalPathName, String machineName) throws IOException, ServerRuntimeException {
        try {
            this.downloadDirectory(sourceDirPath, targetDir, remoteToLocalPathName, machineName);
        }
        finally {
            this.removeContainerWithVolumes();
        }
    }

    public void downloadDirectory(@NotNull String resourcePath, @NotNull File targetFile, @Nullable Map<String, String> remoteToLocalPathName, @Nullable String machineName) throws IOException, ServerRuntimeException {
        if (resourcePath == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(3);
        }
        if (targetFile == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(4);
        }
        RemoteDockerRuntimeUtil.download(this.myApplication, this.myRuntime.getAgentExecutor(), resourcePath, targetFile, remoteToLocalPathName, machineName);
    }

    public static void extractTar(@NotNull File tarFile, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Function<String, String> remoteToLocalMapping) throws IOException {
        if (tarFile == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(5);
        }
        if (resourcePath == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(6);
        }
        if (targetFile == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(7);
        }
        RemoteDockerRuntimeUtil.extractTar(tarFile, resourcePath, targetFile, remoteToLocalMapping);
    }

    static void extractTar(@NotNull InputStream inputStream, @NotNull String resourcePath, @NotNull File targetFile, @Nullable Map<String, String> remoteToLocalPathName) throws IOException {
        if (inputStream == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(8);
        }
        if (resourcePath == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(9);
        }
        if (targetFile == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(10);
        }
        RemoteDockerRuntimeUtil.extractTar(inputStream, resourcePath, targetFile, remoteToLocalPathName);
    }

    @NotNull
    static String replacePathPrefix(@NotNull String path, @NotNull String newPrefix) {
        if (path == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(11);
        }
        if (newPrefix == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(12);
        }
        String string = RemoteDockerRuntimeUtil.replacePathPrefix(path, newPrefix);
        if (string == null) {
            RemoteDockerApplicationRuntime.$$$reportNull$$$0(13);
        }
        return string;
    }

    public String getContainerId() {
        return this.getAgentApplication().getContainerId();
    }

    public static RemoteDockerApplicationRuntime createWithImageInitialization(RemoteDockerRuntime dockerRuntime, DockerAgentDeploymentConfig config, ImageInitializer initializer) throws ServerRuntimeException, IOException {
        try {
            return RemoteDockerApplicationRuntime.create(dockerRuntime, config);
        }
        catch (WrappedNotFoundException e) {
            LOG.debug("Image {", new Object[]{Arrays.toString(config.getImageTags()), "} has not been found", e});
            initializer.init();
            return RemoteDockerApplicationRuntime.create(dockerRuntime, config);
        }
    }

    public static RemoteDockerApplicationRuntime createWithPullImage(RemoteDockerRuntime dockerRuntime, DockerAgentDeploymentConfig config) throws IOException, ServerRuntimeException {
        Object[] tags = config.getImageTags();
        if (tags.length != 1) {
            throw new IOException("Exactly one image tag or ID is required: " + Arrays.toString(tags));
        }
        return RemoteDockerApplicationRuntime.createWithImageInitialization(dockerRuntime, config, () -> RemoteDockerApplicationRuntime.lambda$createWithPullImage$12(dockerRuntime, (String[])tags));
    }

    private static /* synthetic */ void lambda$createWithPullImage$12(RemoteDockerRuntime dockerRuntime, String[] tags) throws IOException, ServerRuntimeException {
        dockerRuntime.pullImage(tags[0]);
    }

    private /* synthetic */ DockerAgentDeployment lambda$create$3(DockerAgentDeploymentConfig config, DockerAgentPathMapper pathMapper) {
        return this.getAgent().createDeployment(config, (CloudAgentLoggingHandler)this.myLoggingHandler, pathMapper);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loggingHandler";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/runtime/RemoteDockerApplicationRuntime";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tarFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/runtime/RemoteDockerApplicationRuntime";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "consumeLogsToProcessOutput";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "replacePathPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "exec";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "consumeLogsToProcessOutput";
                break;
            }
            case 2: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "downloadDirectory";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractTar";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replacePathPrefix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ImageInitializer {
        public void init() throws IOException, ServerRuntimeException;
    }
}

